/*
 * Decompiled with CFR 0.152.
 */
package lightgraph;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import lightgraph.DataSet;
import lightgraph.Graph;
import lightgraph.painters.GraphPainter;
import lightgraph.painters.PanelPainter;

public class ForgetfulGraph
extends Graph {
    boolean FIXED = false;

    public void setFixed() {
        this.FIXED = true;
    }

    @Override
    public void resetGraph() {
        this.IMAGE_LOCK.get();
        Graphics2D g = this.img.createGraphics();
        this.resetGraph(new PanelPainter(g, this.BACKGROUND));
        g.dispose();
        this.IMAGE_LOCK.release();
    }

    @Override
    public void resetGraph(GraphPainter p) {
        AffineTransform transform;
        double height;
        double width;
        if (this.SCALE) {
            this.autoScale();
        }
        double offset = this.PADDING;
        if (this.XTICS || this.YTICS) {
            offset += 5.0;
        }
        if (this.XLABEL || this.YLABEL) {
            offset += 20.0;
        }
        if (!this.FIXED) {
            p.setColor(this.BACKGROUND);
            p.fill(new Rectangle(0, 0, this.CWIDTH, this.CHEIGHT));
            width = ((double)this.CWIDTH - this.PADDING - offset) / (double)this.CWIDTH;
            height = ((double)this.CHEIGHT - this.PADDING - offset) / (double)this.CHEIGHT;
            transform = new AffineTransform(width, 0.0, 0.0, -height, offset, (double)this.CHEIGHT - offset);
            this.drawBorder(p, transform);
        }
        width = ((double)this.CWIDTH - offset - this.PADDING) / (this.MAXX - this.MINX);
        height = ((double)this.CHEIGHT - offset - this.PADDING) / (this.MAXY - this.MINY);
        transform = new AffineTransform(width, 0.0, 0.0, -height, offset - this.MINX * width, (double)this.CHEIGHT + this.MINY * height - offset);
        p.setClip((int)offset, (int)offset - 5, (int)((double)this.CWIDTH - 2.0 * offset + 5.0), (int)((double)this.CHEIGHT - 2.0 * offset + 5.0));
        for (DataSet set : this.DATASETS) {
            this.drawSet(set, p, transform);
            if (set.DATA.size() <= 1) continue;
            Point2D pt = set.DATA.get(set.DATA.size() - 1);
            set.DATA.clear();
            set.DATA.add(pt);
        }
    }
}

