/*
 * Decompiled with CFR 0.152.
 */
package lightgraph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import lightgraph.DataSet;
import lightgraph.GraphDefaults;
import lightgraph.GraphMutex;
import lightgraph.GraphPanel;
import lightgraph.LGFont;
import lightgraph.gui.GraphFrame;
import lightgraph.painters.GraphPainter;
import lightgraph.painters.PanelPainter;
import lightgraph.painters.SvgPainter;

public class Graph {
    public boolean AUTOX = true;
    public boolean AUTOY = true;
    boolean XLABEL;
    boolean YLABEL;
    boolean GRID;
    boolean XTICS = true;
    int XTIC_COUNT = 7;
    boolean YTICS = true;
    int YTIC_COUNT = 5;
    boolean TITLE;
    public double MINX;
    public double MINY;
    public double MAXX = -1.7976931348623157E308;
    public double MAXY = -1.7976931348623157E308;
    double PADDING = 10.0;
    double YTICS_WIDTH = 30.0;
    double XTICS_HEIGHT = 20.0;
    double TITLE_HEIGHT = 0.0;
    double FONT_HEIGHT = 12.0;
    double LEFT_MARGIN;
    double RIGHT_MARGIN;
    double TOP_MARGIN;
    double BOTTOM_MARGIN;
    FontMetrics FONT_METRICS;
    boolean SCALE;
    public int CHEIGHT = 480;
    public int CWIDTH = 640;
    double KEY_X = 100.0;
    double KEY_Y = 45.0;
    boolean KEY_POSITION_SET = false;
    Color AXIS_COLOR;
    Color BACKGROUND;
    BufferedImage img;
    public ArrayList<DataSet> DATASETS;
    String[] xtics;
    String[] ytics;
    String xlabel;
    String ylabel;
    String title;
    public GraphPanel panel;
    GraphMutex IMAGE_LOCK = new GraphMutex();
    private JFrame frame;
    private LGFont ticFont = new LGFont("Liberation", 0, 10);
    private LGFont titleFont = new LGFont("Liberation", 0, 14);
    private LGFont labelFont = new LGFont("Liberation", 0, 12);

    public Graph() {
        this.MINX = Double.MAX_VALUE;
        this.MINY = Double.MAX_VALUE;
        this.img = new BufferedImage(this.CWIDTH, this.CHEIGHT, 1);
        Graphics g = this.img.getGraphics();
        this.FONT_METRICS = g.getFontMetrics();
        this.DATASETS = new ArrayList();
        this.SCALE = false;
        this.AXIS_COLOR = Color.BLACK;
        this.BACKGROUND = Color.WHITE;
    }

    public Graph(double[] x, double[] y) {
        this();
        this.addData(x, y);
    }

    public DataSet addData(double[] x, double[] y) {
        DataSet d = new DataSet(x, y);
        d.setColor(GraphDefaults.getDefaultColor(this.DATASETS.size()));
        this.DATASETS.add(d);
        this.SCALE = true;
        return d;
    }

    public DataSet replaceData(int set, double[] x, double[] y) {
        DataSet d = new DataSet(x, y);
        DataSet old = this.DATASETS.get(set);
        d.setColor(old.COLOR);
        d.setPoints(old.POINTS);
        d.setLine(old.LINE);
        d.setLabel(old.label);
        this.DATASETS.remove(set);
        if (set < this.DATASETS.size()) {
            this.DATASETS.add(set, d);
        } else {
            this.DATASETS.add(d);
        }
        this.SCALE = true;
        return d;
    }

    public void resizeGraph(int x, int y) {
        this.CHEIGHT = x;
        this.CWIDTH = y;
        this.img = new BufferedImage(this.CWIDTH, this.CHEIGHT, 1);
        if (this.panel != null) {
            this.panel.updateImageSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
        }
    }

    public void resetGraph() {
        this.IMAGE_LOCK.get();
        BufferedImage image = new BufferedImage(this.CWIDTH, this.CHEIGHT, 1);
        Graphics2D g = image.createGraphics();
        this.resetGraph(new PanelPainter(g, this.BACKGROUND));
        g.dispose();
        this.img = image;
        this.IMAGE_LOCK.release();
    }

    public void resetGraph(GraphPainter p) {
        if (this.SCALE) {
            this.autoScale();
        }
        this.LEFT_MARGIN = this.PADDING;
        this.RIGHT_MARGIN = this.PADDING;
        this.TOP_MARGIN = this.PADDING;
        this.BOTTOM_MARGIN = this.PADDING;
        if (this.XTICS || this.YTICS) {
            this.createTics();
        }
        if (this.XTICS) {
            this.LEFT_MARGIN += this.YTICS_WIDTH;
        }
        if (this.YTICS) {
            this.BOTTOM_MARGIN += this.XTICS_HEIGHT;
        }
        if (this.XLABEL) {
            this.LEFT_MARGIN += this.FONT_HEIGHT * 1.2;
        }
        if (this.YLABEL) {
            this.BOTTOM_MARGIN += this.FONT_HEIGHT * 1.2;
        }
        if (this.TITLE) {
            this.TOP_MARGIN += this.FONT_HEIGHT * 1.2;
        }
        p.setColor(this.BACKGROUND);
        p.fill(new Rectangle2D.Double(0.0, 0.0, this.CWIDTH, this.CHEIGHT));
        double width = ((double)this.CWIDTH - this.LEFT_MARGIN - this.RIGHT_MARGIN) / (double)this.CWIDTH;
        double height = ((double)this.CHEIGHT - this.TOP_MARGIN - this.BOTTOM_MARGIN) / (double)this.CHEIGHT;
        AffineTransform transform = new AffineTransform(width, 0.0, 0.0, -height, this.LEFT_MARGIN, (double)this.CHEIGHT - this.BOTTOM_MARGIN);
        this.drawBorder(p, transform);
        width = ((double)this.CWIDTH - this.LEFT_MARGIN - this.RIGHT_MARGIN) / (this.MAXX - this.MINX);
        height = ((double)this.CHEIGHT - this.TOP_MARGIN - this.BOTTOM_MARGIN) / (this.MAXY - this.MINY);
        transform = new AffineTransform(width, 0.0, 0.0, -height, this.LEFT_MARGIN - this.MINX * width, (double)this.CHEIGHT + this.MINY * height - this.BOTTOM_MARGIN);
        this.drawYTics(p, transform);
        this.drawXTics(p, transform);
        this.drawLabels(p);
        p.setClip((int)this.LEFT_MARGIN, (int)this.TOP_MARGIN, (int)((double)this.CWIDTH - (this.LEFT_MARGIN + this.RIGHT_MARGIN)), (int)((double)this.CHEIGHT - (this.TOP_MARGIN + this.BOTTOM_MARGIN)));
        for (DataSet set : this.DATASETS) {
            this.drawSet(set, p, transform);
        }
        this.drawKey(p);
    }

    void drawLabels(GraphPainter p) {
        double offset;
        int length;
        double width;
        if (this.XLABEL) {
            width = (double)this.CWIDTH - this.LEFT_MARGIN - this.RIGHT_MARGIN;
            length = p.getStringWidth(this.xlabel);
            offset = (width - (double)length) / 2.0 + this.LEFT_MARGIN;
            p.setFont(this.labelFont);
            p.drawString(this.xlabel, offset, (double)this.CHEIGHT - 1.2 * this.FONT_HEIGHT);
        }
        if (this.YLABEL) {
            double height = (double)this.CHEIGHT - this.TOP_MARGIN - this.BOTTOM_MARGIN;
            length = p.getStringWidth(this.ylabel);
            offset = (height - (double)length) / 2.0 + this.TOP_MARGIN + (double)length;
            p.drawVerticalString(this.ylabel, 1.2 * this.FONT_HEIGHT, offset);
        }
        if (this.TITLE) {
            width = (double)this.CWIDTH - this.LEFT_MARGIN - this.RIGHT_MARGIN;
            length = p.getStringWidth(this.title);
            offset = (width - (double)length) / 2.0 + this.LEFT_MARGIN;
            p.setFont(this.titleFont);
            p.drawString(this.title, offset, 1.2 * this.FONT_HEIGHT);
        }
    }

    void drawKey(GraphPainter p) {
        int count = 0;
        p.startGroup();
        if (!this.KEY_POSITION_SET) {
            int max = 0;
            for (DataSet set : this.DATASETS) {
                int width;
                if (set.label == null || (width = p.getStringWidth(set.label)) <= max) continue;
                max = width;
            }
            this.KEY_X = (double)(max + 8 + 50) + this.RIGHT_MARGIN;
        }
        for (DataSet set : this.DATASETS) {
            if (set.label == null) continue;
            double top = this.KEY_Y + this.FONT_HEIGHT * 1.4 * (double)count;
            double left = (double)this.CWIDTH - this.KEY_X;
            p.setColor(this.AXIS_COLOR);
            p.setFont(this.labelFont);
            p.drawString(set.label, left + 50.0, top);
            p.setColor(set.COLOR);
            ArrayList<Point2D> pts = new ArrayList<Point2D>();
            double mark_y = top - this.FONT_HEIGHT * 0.4;
            pts.add(new Point2D.Double(left + 5.0, mark_y));
            pts.add(new Point2D.Double(left + 45.0, mark_y));
            Point2D.Double middle = new Point2D.Double(left + 25.0, mark_y);
            if (set.LINE != null) {
                set.LINE.drawLine(pts, p);
            }
            if (set.POINTS != null) {
                set.POINTS.drawPoint(middle, p);
            }
            ++count;
        }
        p.endGroup();
    }

    public void drawYTics(GraphPainter p, AffineTransform t) {
        double delta = (this.MAXY - this.MINY) / (double)(this.YTIC_COUNT - 1);
        int max = 0;
        for (String tic : this.ytics) {
            max = tic.length() > max ? tic.length() : max;
        }
        p.startGroup();
        for (int i = 0; i < this.YTIC_COUNT; ++i) {
            double ynot = this.MINY + (double)i * delta;
            double xnot = this.MINX;
            Point2D.Double pt = new Point2D.Double(xnot, ynot);
            t.transform(pt, pt);
            double x0 = ((Point2D)pt).getX();
            double x1 = x0 + 5.0;
            double y = ((Point2D)pt).getY();
            p.drawLine(x0, y, x1, y);
        }
        p.endGroup();
        String format = "%" + max + "s";
        p.startGroup();
        for (int i = 0; i < this.YTIC_COUNT; ++i) {
            double ynot = this.MINY + (double)i * delta;
            double xnot = this.MINX;
            Point2D.Double pt = new Point2D.Double(xnot, ynot);
            t.transform(pt, pt);
            double x0 = ((Point2D)pt).getX();
            double y = ((Point2D)pt).getY();
            p.setFont(this.ticFont);
            String tic = String.format(format, this.ytics[i]);
            p.drawString(tic, x0 - (double)((int)this.YTICS_WIDTH), y + 5.0);
        }
        p.endGroup();
    }

    public void drawXTics(GraphPainter p, AffineTransform t) {
        double delta = (this.MAXX - this.MINX) / (double)(this.XTIC_COUNT - 1);
        int max = 0;
        p.startGroup();
        for (int i = 0; i < this.XTIC_COUNT; ++i) {
            double ynot = this.MINY;
            double xnot = this.MINX + delta * (double)i;
            Point2D.Double pt = new Point2D.Double(xnot, ynot);
            t.transform(pt, pt);
            double x = ((Point2D)pt).getX();
            double y0 = ((Point2D)pt).getY();
            double y1 = y0 - 5.0;
            p.drawLine(x, y0, x, y1);
            String tl = this.xtics[i];
            max = max > tl.length() ? max : tl.length();
        }
        p.endGroup();
        String format = "%s";
        p.startGroup();
        for (int i = 0; i < this.XTIC_COUNT; ++i) {
            double ynot = this.MINY;
            double xnot = this.MINX + delta * (double)i;
            Point2D.Double pt = new Point2D.Double(xnot, ynot);
            t.transform(pt, pt);
            double x = ((Point2D)pt).getX();
            double y0 = ((Point2D)pt).getY();
            p.setFont(this.ticFont);
            p.drawString(String.format(format, this.xtics[i]), x - 3.0, y0 + 15.0);
        }
        p.endGroup();
    }

    public void clearData() {
        this.DATASETS.clear();
    }

    public void drawSet(DataSet set, GraphPainter painter, AffineTransform transform) {
        ArrayList<Point2D> pts = new ArrayList<Point2D>();
        for (Point2D pt : set.DATA) {
            Point2D.Double scaled = new Point2D.Double();
            pts.add(transform.transform(pt, scaled));
        }
        painter.setColor(set.COLOR);
        if (set.LINE != null) {
            set.LINE.drawLine(pts, painter);
        }
        if (set.ERRORS != null) {
            if (set.POINTS != null) {
                set.ERRORS.setWeight(set.POINTS.WEIGHT);
                set.ERRORS.setSize(set.POINTS.SIZE);
            } else if (set.LINE != null) {
                set.ERRORS.setWeight(set.LINE.WIDTH);
            }
            painter.startGroup();
            double scale_x = transform.getScaleX();
            double scale_y = transform.getScaleY();
            set.ERRORS.setScale(scale_x, scale_y);
            for (int i = 0; i < pts.size(); ++i) {
                set.ERRORS.drawErrorAt(i, pts.get(i), painter);
            }
            painter.endGroup();
        }
        if (set.POINTS != null) {
            painter.startGroup();
            for (Point2D pt : pts) {
                set.POINTS.drawPoint(pt, painter);
            }
            painter.endGroup();
        }
    }

    public void setXLabel(String label) {
        if (label.length() == 0) {
            this.XLABEL = false;
            return;
        }
        this.XLABEL = true;
        this.xlabel = label;
    }

    public void setYLabel(String label) {
        if (label.length() == 0) {
            this.XLABEL = false;
            return;
        }
        this.YLABEL = true;
        this.ylabel = label;
    }

    public void setTitle(String label) {
        if (label.length() == 0) {
            this.XLABEL = false;
            return;
        }
        this.TITLE = true;
        this.title = label;
    }

    public void drawBorder(GraphPainter p, AffineTransform transform) {
        Point2D[] border = new Point2D[4];
        p.setColor(this.AXIS_COLOR);
        border[0] = new Point2D.Double(0.0, 0.0);
        border[1] = new Point2D.Double(this.CWIDTH, 0.0);
        border[2] = new Point2D.Double(this.CWIDTH, this.CHEIGHT);
        border[3] = new Point2D.Double(0.0, this.CHEIGHT);
        Path2D.Double path = new Path2D.Double();
        Point2D[] transformed = new Point2D[4];
        transform.transform(border, 0, transformed, 0, 4);
        ((Path2D)path).moveTo(transformed[3].getX(), transformed[3].getY());
        for (int i = 0; i < 4; ++i) {
            ((Path2D)path).lineTo(transformed[i].getX(), transformed[i].getY());
        }
        p.drawPath(path);
    }

    public void savePng(File f) throws IOException {
        BufferedImage image = this.img;
        this.IMAGE_LOCK.get();
        ImageIO.write((RenderedImage)image, "png", f);
        this.IMAGE_LOCK.release();
    }

    public void saveSvg(File f) {
        SvgPainter painter = new SvgPainter(this.CHEIGHT, this.CWIDTH, this.getBackground());
        this.resetGraph(painter);
        painter.finish(f);
    }

    public void createTics() {
        int now_width;
        String value;
        int i;
        double delta;
        if (this.XTICS) {
            delta = (this.MAXX - this.MINX) / (double)(this.XTIC_COUNT - 1);
            this.xtics = new String[this.XTIC_COUNT];
            int x_overflow = 0;
            for (i = 0; i < this.XTIC_COUNT; ++i) {
                double xnot = this.MINX + delta * (double)i;
                value = MessageFormat.format("{0}", xnot);
                now_width = SwingUtilities.computeStringWidth(this.FONT_METRICS, value);
                x_overflow = now_width > x_overflow ? now_width : x_overflow;
                this.xtics[i] = value;
            }
            this.RIGHT_MARGIN += (double)x_overflow;
        }
        if (this.YTICS) {
            delta = (this.MAXY - this.MINY) / (double)(this.YTIC_COUNT - 1);
            this.ytics = new String[this.YTIC_COUNT];
            int ytics_width = 0;
            for (i = 0; i < this.YTIC_COUNT; ++i) {
                double ynot = this.MINY + (double)i * delta;
                value = MessageFormat.format("{0}", ynot);
                now_width = SwingUtilities.computeStringWidth(this.FONT_METRICS, value);
                ytics_width = ytics_width > now_width ? ytics_width : now_width;
                this.ytics[i] = value;
            }
            this.YTICS_WIDTH = ytics_width;
        }
    }

    public void autoScaleX() {
        if (!this.AUTOX) {
            this.SCALE = true;
        }
        this.AUTOX = true;
    }

    public void autoScaleY() {
        if (!this.AUTOY) {
            this.SCALE = true;
        }
        this.AUTOY = true;
    }

    public void autoScale() {
        if (this.AUTOX || this.AUTOY) {
            double mnx = Double.MAX_VALUE;
            double mny = Double.MAX_VALUE;
            double mxx = -1.7976931348623157E308;
            double mxy = -1.7976931348623157E308;
            for (DataSet set : this.DATASETS) {
                for (Point2D pt : set.DATA) {
                    if (!this.checkX(pt.getX()) || !this.checkY(pt.getY())) continue;
                    mnx = pt.getX() < mnx ? pt.getX() : mnx;
                    mny = pt.getY() < mny ? pt.getY() : mny;
                    mxx = pt.getX() > mxx ? pt.getX() : mxx;
                    mxy = pt.getY() > mxy ? pt.getY() : mxy;
                }
            }
            this.MAXX = this.AUTOX ? mxx : this.MAXX;
            double d = this.MINX = this.AUTOX ? mnx : this.MINX;
            if (this.AUTOX && this.MAXX == this.MINX) {
                this.MAXX += 1.0;
                this.MINX -= 1.0;
            }
            this.MAXY = this.AUTOY ? mxy : this.MAXY;
            double d2 = this.MINY = this.AUTOY ? mny : this.MINY;
            if (this.AUTOY && this.MAXY == this.MINY) {
                this.MAXY += 1.0;
                this.MINY -= 1.0;
            }
        }
        this.SCALE = false;
    }

    boolean checkX(double x) {
        return this.AUTOX || x >= this.MINX && x <= this.MAXX;
    }

    boolean checkY(double y) {
        return this.AUTOY || y >= this.MINY && y <= this.MAXY;
    }

    public void setXRange(double min, double max) throws IllegalArgumentException {
        if (min >= max) {
            throw new IllegalArgumentException("the minimum must be less than the maximum");
        }
        this.AUTOX = false;
        this.MINX = min;
        this.MAXX = max;
        this.SCALE = true;
    }

    public void setYRange(double min, double max) throws IllegalArgumentException {
        if (min >= max) {
            throw new IllegalArgumentException("the minimum must be less than the maximum");
        }
        this.AUTOY = false;
        this.MAXY = max;
        this.MINY = min;
    }

    public DataSet getDataSet(int i) {
        return this.DATASETS.get(i);
    }

    public int dataSetCount() {
        return this.DATASETS.size();
    }

    public void appendPoint(int set, double x, double y) {
        this.DATASETS.get(set).addPoint(x, y);
        this.SCALE = true;
    }

    public void setContentSize(int width, int height) {
        if (this.XTICS || this.YTICS) {
            this.createTics();
        }
        if (this.XTICS) {
            width = (int)((double)width + this.YTICS_WIDTH);
        }
        if (this.YTICS) {
            height = (int)((double)height + this.XTICS_HEIGHT);
        }
        if (this.CWIDTH == width || this.CHEIGHT == height) {
            return;
        }
        this.CWIDTH = width;
        this.CHEIGHT = height;
        this.SCALE = true;
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean exit_on_close, String window_title) {
        if (this.frame != null) {
            this.frame.setVisible(true);
            return;
        }
        GraphFrame y = new GraphFrame(window_title);
        if (exit_on_close) {
            y.setDefaultCloseOperation(3);
        }
        this.resetGraph();
        this.panel = new GraphPanel(this.img);
        y.setGraph(this);
        y.pack();
        y.setVisible(true);
        this.frame = y;
    }

    public void show(boolean exit_on_close) {
        this.show(exit_on_close, "Graph Panel");
    }

    public void repaint() {
        this.IMAGE_LOCK.get();
        try {
            this.panel.updateImage(this.img);
        }
        catch (NullPointerException e) {
            System.out.println("unable to repaint");
            e.printStackTrace();
        }
        this.IMAGE_LOCK.release();
    }

    public void refresh(boolean rescale) {
        this.SCALE = rescale || this.SCALE;
        this.resetGraph();
        this.repaint();
    }

    public void setYTicCount(int c) {
        this.YTICS = c != 0;
        this.YTIC_COUNT = c;
    }

    public void setXTicCount(int c) {
        this.XTIC_COUNT = c;
        this.XTICS = c != 0;
    }

    public int getXTicCount() {
        return this.XTIC_COUNT;
    }

    public int getYTicCount() {
        return this.YTIC_COUNT;
    }

    public void setBackground(Color c) {
        this.BACKGROUND = c;
    }

    public void setAxisColor(Color c) {
        this.AXIS_COLOR = c;
    }

    public Color getBackground() {
        return this.BACKGROUND;
    }

    public String getXLabel() {
        return this.xlabel;
    }

    public String getYLabel() {
        return this.ylabel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setKeyX(double x) {
        this.KEY_X = x;
        this.KEY_POSITION_SET = true;
    }

    public void setKeyY(double y) {
        this.KEY_Y = y;
    }

    public double getKeyX() {
        return this.KEY_X;
    }

    public double getKeyY() {
        return this.KEY_Y;
    }

    public GraphPanel getGraphPanel() {
        if (this.panel == null) {
            this.panel = new GraphPanel(this.img);
        }
        return this.panel;
    }

    public double[] getDataCoordinates(double panel_x, double panel_y) {
        double data_x = panel_x - this.LEFT_MARGIN;
        double data_y = (double)this.CHEIGHT - this.BOTTOM_MARGIN - panel_y;
        double real_x = this.MINX + (this.MAXX - this.MINX) * data_x / ((double)this.CWIDTH - this.LEFT_MARGIN - this.RIGHT_MARGIN);
        double real_y = this.MINY + (this.MAXY - this.MINY) * data_y / ((double)this.CHEIGHT - this.BOTTOM_MARGIN - this.TOP_MARGIN);
        return new double[]{real_x, real_y};
    }

    public double[] getImageCoordinates(double real_x, double real_y) {
        double panel_x = this.LEFT_MARGIN + (real_x - this.MINX) * ((double)this.CWIDTH - this.LEFT_MARGIN - this.RIGHT_MARGIN) / (this.MAXX - this.MINX);
        double panel_y = (double)this.CHEIGHT - this.BOTTOM_MARGIN - (real_y - this.MINY) * ((double)this.CHEIGHT - this.BOTTOM_MARGIN - this.TOP_MARGIN) / (this.MAXY - this.MINY);
        return new double[]{panel_x, panel_y};
    }

    public void setTitleFont(LGFont font) {
        this.titleFont = font;
    }

    public void setLabelFont(LGFont labelFont) {
        this.labelFont = labelFont;
    }

    public void setTicFont(LGFont ticFont) {
        this.ticFont = ticFont;
    }
}

