/*
 * Decompiled with CFR 0.152.
 */
package lightgraph;

import java.awt.Font;
import javax.swing.UIManager;

public class LGFont {
    static final Font DEFAULT = UIManager.getDefaults().getFont("Menu.font");
    Font awt;
    String name;
    String style;
    int size;
    static final String[] styles = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};

    public LGFont(String name, int style, int size) {
        this.awt = new Font(name, style, size);
        this.size = size;
        this.name = name;
        this.style = styles[style];
    }

    public LGFont(String name, String style, int size) {
        this.size = size;
        this.name = name;
        int s = LGFont.getStyle(style);
        if (s >= 0) {
            this.style = styles[s];
            this.awt = new Font(name, s, size);
        } else {
            this.style = style;
            this.awt = new Font(name, 0, size);
        }
    }

    static int getStyle(String style) {
        String lc = style.toLowerCase();
        for (int i = 0; i < styles.length; ++i) {
            if (!lc.equals(styles[i].toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public String getStyle() {
        return this.style;
    }

    public LGFont(Font f) {
        if (f == null) {
            throw new IllegalArgumentException("Null is not a valid Font to derive LGFont!");
        }
        this.size = f.getSize();
        this.name = f.getName();
        this.style = styles[f.getStyle()];
    }

    public Font getAwtFont() {
        return this.awt;
    }

    public String getName() {
        return this.name;
    }

    public float getSize() {
        return this.size;
    }
}

