/*
 * Decompiled with CFR 0.152.
 */
package lightgraph.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lightgraph.Graph;
import lightgraph.gui.DataWindow;
import lightgraph.gui.GraphActions;
import lightgraph.gui.GraphButton;
import lightgraph.gui.GraphFormatWindow;

public class ButtonPanel
extends JPanel
implements MouseListener {
    Graph GRAPH;
    Dimension SIZE = new Dimension(120, 10);
    final int TAB = 20;
    int buttons = 0;
    final JFrame parent;
    GraphFormatWindow FORMATTER;
    FontMetrics metrics;
    Color fill = new Color(100, 100, 100, 50);
    Color boundary = new Color(0, 0, 0);

    ButtonPanel(JFrame parent) {
        this.parent = parent;
        this.setOpaque(false);
        this.setSize(this.SIZE);
        this.setLayout(new BoxLayout(this, 3));
        this.addButton("SVG");
        this.addButton("PNG");
        this.addButton("DATA");
        this.addButton("FORMAT");
    }

    public void setGraph(Graph g) {
        this.GRAPH = g;
    }

    public Dimension getStaticSize() {
        return this.SIZE;
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.SIZE.width - 20;
        int h = this.SIZE.height - 10;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.fill);
        g2.fillRect(0, 0, w, h);
        g2.setClip(w, 0, 20, 50);
        g2.fillRoundRect(w - 10, 0, 29, 49, 8, 8);
        g2.setColor(this.boundary);
        g2.drawRoundRect(w - 10, 0, 29, 49, 8, 8);
        g2.setClip(1, h, w, 10);
        g2.setColor(this.fill);
        g2.fillRoundRect(-10, h - 10, w + 9, 19, 8, 8);
        g2.setColor(this.boundary);
        g2.drawRoundRect(-10, h - 10, w + 9, 19, 8, 8);
        g2.setClip(null);
        g2.drawLine(w - 1, 49, w - 1, h);
    }

    public GraphButton addButton(String label) {
        GraphButton b = new GraphButton(label);
        this.add(b);
        ++this.buttons;
        int h = this.buttons * b.getHeight() + 10;
        this.SIZE = this.SIZE.height > h ? this.SIZE : new Dimension(this.SIZE.width, h);
        b.addMouseListener(this);
        return b;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        AbstractButton ab = (AbstractButton)e.getSource();
        switch (GraphActions.valueOf(ab.getText())) {
            case SVG: {
                this.saveSvg();
                break;
            }
            case PNG: {
                this.savePng();
                break;
            }
            case DATA: {
                this.showData();
                break;
            }
            case FORMAT: {
                this.showFormatter();
                break;
            }
            default: {
                System.out.println("not implemented");
            }
        }
    }

    public void showFormatter() {
        if (this.FORMATTER == null) {
            this.FORMATTER = new GraphFormatWindow(this.GRAPH);
            this.FORMATTER.initialize();
        }
        this.FORMATTER.display();
    }

    public void showData() {
        EventQueue.invokeLater(DataWindow.createDataWindow(this.GRAPH));
    }

    public void saveSvg() {
        FileDialog fd = new FileDialog((Frame)this.parent, "Save as SVG file...", 1);
        fd.setVisible(true);
        String fname = fd.getFile();
        String dir = fd.getDirectory();
        if (fname != null) {
            File file = new File(dir, fname);
            this.GRAPH.saveSvg(file);
        }
    }

    public void savePng() {
        FileDialog fd = new FileDialog((Frame)this.parent, "Save as PNG file...", 1);
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname == null) {
            return;
        }
        String dir = fd.getDirectory();
        try {
            this.GRAPH.savePng(new File(dir, fname));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

