/*
 * Decompiled with CFR 0.152.
 */
package lightgraph.gui;

import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import lightgraph.DataSet;
import lightgraph.Graph;
import lightgraph.elements.ErrorBars;
import lightgraph.gui.DataModel;

public class DataWindow
implements Runnable,
ActionListener {
    JFrame frame;
    JTable table;
    DataModel model;

    public DataWindow(String title) {
        this.frame = new JFrame(title);
        this.frame.setDefaultCloseOperation(2);
        this.model = new DataModel();
        this.table = new JTable();
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(0);
        this.table.setModel(this.model);
        JScrollPane jsp = new JScrollPane(this.table);
        this.frame.add(jsp);
        this.frame.setSize(600, 800);
        JMenuBar menubar = new JMenuBar();
        JMenu file = new JMenu("file");
        JMenuItem save = new JMenuItem("save vertical");
        save.setActionCommand("vertical");
        save.addActionListener(this);
        file.add(save);
        JMenuItem horizontal = new JMenuItem("save horizontal");
        horizontal.setActionCommand("horizontal");
        horizontal.addActionListener(this);
        file.add(horizontal);
        menubar.add(file);
        this.frame.setJMenuBar(menubar);
    }

    public void addColumn(String name, List<Double> column) {
        this.model.addColumn(name, column);
    }

    public static DataWindow createDataWindow(Graph graph) {
        DataWindow dw = new DataWindow("data");
        for (int i = 0; i < graph.dataSetCount(); ++i) {
            List<Double> data;
            String ylabel;
            String xlabel;
            DataSet ds = graph.getDataSet(i);
            ArrayList<Double> x = new ArrayList<Double>();
            ArrayList<Double> y = new ArrayList<Double>();
            for (Point2D point : ds) {
                x.add(point.getX());
                y.add(point.getY());
            }
            String label = ds.label;
            if (label == null || label.isEmpty()) {
                label = "" + i;
                xlabel = "x" + i;
                ylabel = "y" + i;
            } else {
                xlabel = label + "-x";
                ylabel = label + "-y";
            }
            dw.addColumn(xlabel, x);
            dw.addColumn(ylabel, y);
            ErrorBars errors = ds.getErrorBars();
            if (errors == null) continue;
            if (errors.hasXData()) {
                data = Arrays.stream(errors.getErrorData(0)).mapToObj(d -> d).collect(Collectors.toList());
                dw.addColumn(label + "-sigmax", data);
            }
            if (!errors.hasYData()) continue;
            data = Arrays.stream(errors.getErrorData(1)).mapToObj(d -> d).collect(Collectors.toList());
            dw.addColumn(label + "-sigmay", data);
        }
        return dw;
    }

    public static List<String> splitOnTabs(String line) {
        int next;
        ArrayList<String> ret = new ArrayList<String>();
        int last = 0;
        while ((next = line.indexOf(9, last)) >= 0) {
            ret.add(line.substring(last, next));
            last = next + 1;
        }
        ret.add(line.substring(last, line.length()));
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("vertical")) {
            this.saveVertical();
        } else {
            this.saveHorizontal();
        }
    }

    public void saveVertical() {
        FileDialog fd = new FileDialog((Frame)this.frame, "Save CSV File", 1);
        fd.setFile("data.csv");
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname == null) {
            return;
        }
        String dirname = fd.getDirectory();
        File output = new File(dirname, fname);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(output));
            bw.write("#");
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                bw.write(this.model.getColumnName(i));
                if (i >= this.model.getColumnCount() - 1) continue;
                bw.write(9);
            }
            bw.write(10);
            for (int j = 0; j < this.model.getRowCount(); ++j) {
                for (int i = 0; i < this.model.getColumnCount(); ++i) {
                    bw.write(this.model.getValueAt(j, i).toString());
                    if (i >= this.model.getColumnCount() - 1) continue;
                    bw.write(9);
                }
                bw.write(10);
            }
            bw.close();
        }
        catch (Exception except) {
            except.printStackTrace();
        }
    }

    public void saveHorizontal() {
        FileDialog fd = new FileDialog((Frame)this.frame, "Save CSV File", 1);
        fd.setFile("data.csv");
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname == null) {
            return;
        }
        String dirname = fd.getDirectory();
        File output = new File(dirname, fname);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(output));
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                bw.write("#");
                bw.write(this.model.getColumnName(i));
                bw.write(10);
                for (int j = 0; j < this.model.getRowCount(); ++j) {
                    bw.write(this.model.getValueAt(j, i).toString());
                    if (j >= this.model.getRowCount() - 1) continue;
                    bw.write(9);
                }
                bw.write(10);
            }
            bw.close();
        }
        catch (Exception except) {
            except.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.table.createDefaultColumnsFromModel();
        this.frame.setVisible(true);
    }

    public void display() {
        EventQueue.invokeLater(this);
    }
}

