/*
 * Decompiled with CFR 0.152.
 */
package lightgraph.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import lightgraph.GraphPoints;
import lightgraph.painters.PanelPainter;

class PointSelector
extends JPanel {
    Dimension d = new Dimension(40, 40);
    Point2D center = new Point2D.Double(20.0, 20.0);
    GraphPoints pts;
    Color color;
    Color background;

    PointSelector(GraphPoints pts, Color fore, Color back) {
        this.setMaximumSize(this.d);
        this.setMinimumSize(this.d);
        this.setPreferredSize(this.d);
        this.color = fore;
        this.background = back;
        this.pts = pts;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.background);
        g.fillRect(0, 0, (int)this.d.getWidth(), (int)this.d.getHeight());
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, (int)this.d.getWidth() - 1, (int)this.d.getHeight() - 1);
        g.setColor(this.color);
        PanelPainter painter = new PanelPainter((Graphics2D)g, this.background);
        if (this.pts != null) {
            this.pts.drawPoint(this.center, painter);
        }
    }

    public void setPoints(GraphPoints p) {
        this.pts = p;
        this.repaint();
    }

    public GraphPoints getPoints() {
        return this.pts;
    }

    public void setColor(Color c) {
        this.color = c;
        this.repaint();
    }
}

