/*
 * Decompiled with CFR 0.152.
 */
package lightgraph.painters;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import lightgraph.LGFont;
import lightgraph.painters.GraphPainter;

public class PanelPainter
implements GraphPainter {
    Graphics2D g;
    final Stroke default_stroke;
    Color BACKGROUND;
    private boolean FILL = false;
    float[] dashes;
    float width;
    LGFont font;

    public PanelPainter(Graphics2D g, Color background) {
        this.g = g;
        this.default_stroke = g.getStroke();
        this.BACKGROUND = background;
    }

    @Override
    public void drawPath(Shape s) {
        if (this.FILL) {
            Color fore = this.g.getColor();
            this.g.setColor(this.BACKGROUND);
            this.g.fill(s);
            this.g.setColor(fore);
        }
        this.g.draw(s);
    }

    @Override
    public void setColor(Color c) {
        this.g.setColor(c);
    }

    @Override
    public Color getColor() {
        return this.g.getColor();
    }

    @Override
    public void drawLine(double x0, double y0, double x1, double y1) {
        this.g.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
    }

    @Override
    public void fill(Shape s) {
        this.g.fill(s);
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.g.setClip(x, y, w, h);
    }

    @Override
    public void drawString(String s, double x, double y) {
        int empty;
        this.g.setFont(this.font.getAwtFont());
        int offset = 0;
        for (empty = 0; empty < s.length() && s.charAt(empty) == ' '; ++empty) {
        }
        if (empty > 0) {
            offset = this.getStringWidth(" ") * empty;
        }
        this.g.drawString(s, (int)x + offset, (int)y);
    }

    @Override
    public void setLineWidth(double width) {
        this.width = (float)width;
        this.updateStroke();
    }

    @Override
    public void setDashes(float[] dashes) {
        this.dashes = dashes;
        this.updateStroke();
    }

    void updateStroke() {
        if (this.dashes == null) {
            BasicStroke s = new BasicStroke(this.width);
            this.g.setStroke(s);
        } else {
            BasicStroke s = new BasicStroke(this.width, 0, 1, 1.0f, this.dashes, 0.0f);
            this.g.setStroke(s);
        }
    }

    @Override
    public void restoreLineWidth() {
        this.g.setStroke(this.default_stroke);
    }

    @Override
    public void setFill(boolean fill) {
        this.FILL = fill;
    }

    @Override
    public void startGroup() {
    }

    @Override
    public void endGroup() {
    }

    @Override
    public void setFont(LGFont font) {
        this.font = font;
    }

    @Override
    public int getStringWidth(String label) {
        FontMetrics metrics = this.g.getFontMetrics();
        return metrics.stringWidth(label);
    }

    @Override
    public void drawVerticalString(String s, double x, double y) {
        this.g.setFont(this.font.getAwtFont());
        FontMetrics metrics = this.g.getFontMetrics();
        AffineTransform ft = AffineTransform.getRotateInstance(-1.5707963267948966);
        Font f = this.g.getFont();
        Font transformed = f.deriveFont(ft);
        this.g.setFont(transformed);
        int start = (int)y;
        for (int i = 0; i < s.length(); ++i) {
            String ss = s.substring(i, i + 1);
            int l = metrics.stringWidth(s.substring(i, i + 1));
            this.g.drawString(ss, (int)x, start);
            start -= l;
        }
        this.g.setFont(f);
    }
}

