/*
 * Decompiled with CFR 0.152.
 */
package lightgraph.painters;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.MessageFormat;
import lightgraph.LGFont;
import lightgraph.painters.GraphPainter;

public class SvgPainter
implements GraphPainter {
    StringBuilder OUTPUT;
    Color COLOR;
    boolean CLIPPING = false;
    double LINE_WIDTH = 1.0;
    float[] DASHES;
    Rectangle clip;
    String FILL = "none";
    Color BACKGROUND;
    FontMetrics metrics;
    boolean FINISHED = false;
    LGFont font = new LGFont("Arial", "Bold", 12);
    static final String DOCTYPE = "<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n  \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n";
    static final String XML = "<?xml version=\"1.0\" standalone=\"no\"?>\n";
    static final String SVG_TAG = "<svg width=\"%.2fpx\" height=\"%.2fpx\" viewBox=\"0 0 %s %s\"\n    xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\">\n";

    public SvgPainter(int height, int width, Color background) {
        this.OUTPUT = new StringBuilder();
        this.OUTPUT.append(XML);
        this.OUTPUT.append(DOCTYPE);
        String dec = String.format(SVG_TAG, Float.valueOf((float)width * 1.0f), Float.valueOf((float)height * 1.0f), width, height);
        this.OUTPUT.append(dec);
        this.BACKGROUND = background;
        this.metrics = new BufferedImage(1, 1, 2).getGraphics().getFontMetrics();
    }

    public static String svgColorString(Color c) {
        String blue;
        String green;
        String red = Integer.toString(c.getRed(), 16);
        if (red.length() == 1) {
            red = "0" + red;
        }
        if ((green = Integer.toString(c.getGreen(), 16)).length() == 1) {
            green = "0" + green;
        }
        if ((blue = Integer.toString(c.getBlue(), 16)).length() == 1) {
            blue = "0" + blue;
        }
        return MessageFormat.format("#{0}{1}{2}", red, green, blue);
    }

    @Override
    public void drawPath(Shape s) {
        Rectangle r = s.getBounds();
        if (this.CLIPPING && !r.intersects(this.clip) && !this.clip.contains(r.getX(), r.getY())) {
            return;
        }
        this.OUTPUT.append("<path d=\"\n");
        PathIterator pit = s.getPathIterator(null);
        double[] p = new double[6];
        while (!pit.isDone()) {
            int t = pit.currentSegment(p);
            switch (t) {
                case 0: {
                    char c = 'M';
                    this.OUTPUT.append(c + " " + p[0] + "," + p[1] + "\n");
                    break;
                }
                case 1: {
                    char c = 'L';
                    this.OUTPUT.append(c + " " + p[0] + "," + p[1] + "\n");
                    break;
                }
                case 4: {
                    char c = 'Z';
                    this.OUTPUT.append(c + "\n");
                    break;
                }
                case 3: {
                    char c = 'C';
                    this.OUTPUT.append(c + " " + p[0] + "," + p[1] + ' ' + p[2] + "," + p[3] + ' ' + p[4] + "," + p[5] + "\n");
                    break;
                }
                default: {
                    char c = 'L';
                    this.OUTPUT.append(c + " " + p[0] + "," + p[1] + "\n");
                }
            }
            pit.next();
        }
        this.OUTPUT.append("\"");
        this.OUTPUT.append(" stroke=\"" + SvgPainter.svgColorString(this.COLOR) + '\"');
        if (this.DASHES != null) {
            String dash = "";
            int n = this.DASHES.length;
            for (int i = 0; i < n; ++i) {
                dash = dash + this.DASHES[i];
                if (i >= n - 1) continue;
                dash = dash + " ";
            }
            this.OUTPUT.append(" stroke-dasharray=\"" + dash + "\" ");
        }
        this.OUTPUT.append(MessageFormat.format(" fill=\"{0}\"", this.FILL));
        this.OUTPUT.append(String.format(" stroke-width=\"%f\" />\n", this.LINE_WIDTH));
    }

    @Override
    public void setColor(Color c) {
        this.COLOR = c;
    }

    @Override
    public void drawLine(double x0, double y0, double x1, double y1) {
        if (this.CLIPPING) {
            double h;
            double y;
            double w;
            double x;
            if (x0 < x1) {
                x = x0;
                w = x1 - x0;
            } else {
                x = x1;
                w = x0 - x1;
            }
            if (y0 < y1) {
                y = y0;
                h = y1 - y0;
            } else {
                y = y1;
                h = y0 - y1;
            }
            if (!(this.clip.contains(x0, y0) || this.clip.contains(x1, y1) || this.clip.intersects(new Rectangle2D.Double(x, y, w, h)))) {
                return;
            }
        }
        this.OUTPUT.append(MessageFormat.format("<line x1=\"{0}\" y1=\"{1}\" x2=\"{2}\" y2=\"{3}\" ", x0, y0, x1, y1));
        this.OUTPUT.append(" stroke=\"" + SvgPainter.svgColorString(this.COLOR) + '\"');
        this.OUTPUT.append(MessageFormat.format(" fill=\"{0}\"", this.FILL));
        this.OUTPUT.append(String.format(" stroke-width=\"%f\" />\n", this.LINE_WIDTH));
    }

    @Override
    public void fill(Shape s) {
        Rectangle r = s.getBounds();
        if (this.CLIPPING && !r.intersects(this.clip)) {
            return;
        }
        this.OUTPUT.append("<path d=\"\n");
        PathIterator pit = s.getPathIterator(null);
        double[] p = new double[6];
        while (!pit.isDone()) {
            int t = pit.currentSegment(p);
            switch (t) {
                case 0: {
                    char c = 'M';
                    this.OUTPUT.append(c + " " + p[0] + "," + p[1] + "\n");
                    break;
                }
                case 1: {
                    char c = 'L';
                    this.OUTPUT.append(c + " " + p[0] + "," + p[1] + "\n");
                    break;
                }
                case 4: {
                    char c = 'Z';
                    this.OUTPUT.append(c);
                    this.OUTPUT.append("\n");
                    break;
                }
                case 3: {
                    char c = 'C';
                    this.OUTPUT.append(c + " " + p[0] + "," + p[1] + ' ' + p[2] + "," + p[3] + ' ' + p[4] + "," + p[5] + "\n");
                    break;
                }
                default: {
                    char c = 'L';
                    this.OUTPUT.append(c + " " + p[0] + "," + p[1] + "\n");
                }
            }
            pit.next();
        }
        this.OUTPUT.append("\"");
        this.OUTPUT.append(" stroke=\"none\"");
        this.OUTPUT.append(" fill=\"" + SvgPainter.svgColorString(this.COLOR) + '\"' + "/>\n");
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.CLIPPING = true;
        this.clip = new Rectangle(x, y, w, h);
        this.OUTPUT.append("<defs>\n");
        this.OUTPUT.append("    <clipPath id=\"graphRegion\">\n");
        this.OUTPUT.append(MessageFormat.format("    <rect x=\"{0}\" y=\"{1}\" width=\"{2}\" height=\"{3}\"\n        fill=\"none\" stroke=\"none\"/>", x, y, w, h));
        this.OUTPUT.append("    </clipPath>\n");
        this.OUTPUT.append("</defs>");
        this.OUTPUT.append("<g clip-path=\"url(#graphRegion)\">\n");
    }

    @Override
    public void drawString(String s, double x, double y) {
        String tag = MessageFormat.format("<text x=\"{0}\" y=\"{1}\" font-family=\"{3}\" font-size=\"{4}pt\" font-style=\"{5}\" fill=\"{6}\" xml:space=\"preserve\">{2}</text>\n", x, y, s, this.font.getName(), Float.valueOf(this.font.getSize()), this.font.getStyle(), SvgPainter.svgColorString(this.COLOR));
        this.OUTPUT.append(tag);
    }

    public void finish(File f) {
        this.finish();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write(this.OUTPUT.toString());
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finish() {
        if (this.FINISHED) {
            return;
        }
        this.FINISHED = true;
        if (this.CLIPPING) {
            this.OUTPUT.append("</g>\n");
        }
        this.OUTPUT.append("</svg>");
    }

    public String getOutput() {
        if (!this.FINISHED) {
            this.finish();
        }
        return this.OUTPUT.toString();
    }

    @Override
    public Color getColor() {
        return this.COLOR;
    }

    @Override
    public void setLineWidth(double d) {
        this.LINE_WIDTH = d;
    }

    @Override
    public void restoreLineWidth() {
        this.LINE_WIDTH = 1.0;
    }

    @Override
    public void setDashes(float[] dashes) {
        this.DASHES = dashes;
    }

    @Override
    public void setFill(boolean fill) {
        this.FILL = fill ? SvgPainter.svgColorString(this.BACKGROUND) : "none";
    }

    @Override
    public void startGroup() {
        this.OUTPUT.append("<g>\n");
    }

    @Override
    public void endGroup() {
        this.OUTPUT.append("</g>\n");
    }

    @Override
    public void setFont(LGFont font) {
        this.font = font;
    }

    @Override
    public int getStringWidth(String label) {
        String stripped = this.stripSvgTags(label);
        return this.metrics.stringWidth(stripped);
    }

    String stripSvgTags(String tagged) {
        return tagged.replaceAll("<[^>]*>", "");
    }

    @Override
    public void drawVerticalString(String s, double x, double y) {
        String tag = MessageFormat.format("<text x=\"{0}\" y=\"{1}\" font-family=\"{3}\" font-size=\"{4}pt\" font-style=\"{5}\" fill=\"{6}\" transform=\"rotate(-90 {0} {1})\" xml:space=\"preserve\">{2}</text>\n", x, y, s, this.font.getName(), Float.valueOf(this.font.getSize()), this.font.getStyle(), SvgPainter.svgColorString(this.COLOR));
        this.OUTPUT.append(tag);
    }
}

