/*
 * Decompiled with CFR 0.152.
 */
package lightgraph;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import lightgraph.GraphLine;
import lightgraph.GraphPoints;
import lightgraph.elements.ErrorBars;

public class DataSet
implements Iterable<Point2D> {
    public Color COLOR;
    public GraphPoints POINTS = GraphPoints.hollowCircles();
    public GraphLine LINE = GraphLine.solidLine();
    ArrayList<Point2D> DATA;
    public ErrorBars ERRORS;
    public String label;

    public DataSet(double[] x, double[] y) {
        this.COLOR = Color.BLUE;
        this.DATA = new ArrayList();
        for (int i = 0; i < x.length; ++i) {
            this.DATA.add(new Point2D.Double(x[i], y[i]));
        }
    }

    public void addYErrorBars(double[] errors) {
        if (errors.length != this.DATA.size()) {
            System.err.println("Warning: the number of errors does not equal the number of points");
        }
        this.ERRORS = new ErrorBars(errors, 1);
    }

    public void addXErrorBars(double[] errors) {
        if (errors.length != this.DATA.size()) {
            System.err.println("Warning: the number of errors does not equal the number of points");
        }
        this.ERRORS = new ErrorBars(errors, 0);
    }

    public void addXYErrorBars(double[] xerr, double[] yerr) {
        if (xerr.length != this.DATA.size() || yerr.length != this.DATA.size()) {
            System.err.println("Warning: the number of errors does not equal the number of points");
        }
        this.ERRORS = new ErrorBars(xerr, yerr);
    }

    public void removeErrorBars() {
        this.ERRORS = null;
    }

    public void setColor(Color c) {
        this.COLOR = c;
    }

    public void setLine(GraphLine l) {
        this.LINE = l;
    }

    public void setPoints(GraphPoints p) {
        this.POINTS = p;
    }

    public void addPoint(double x, double y) {
        this.DATA.add(new Point2D.Double(x, y));
    }

    @Override
    public Iterator<Point2D> iterator() {
        return this.DATA.iterator();
    }

    public void setData(double[] x, double[] y) {
        this.DATA.clear();
        for (int i = 0; i < x.length; ++i) {
            this.DATA.add(new Point2D.Double(x[i], y[i]));
        }
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public double getLineWidth() {
        if (this.LINE == null) {
            return 0.0;
        }
        return this.LINE.getLineWidth();
    }

    public void setLineWidth(double d) {
        if (this.LINE == null) {
            return;
        }
        this.LINE.setLineWidth(d);
    }

    public double getPointSize() {
        if (this.POINTS == null) {
            return 0.0;
        }
        return this.POINTS.SIZE;
    }

    public void setPointSize(double d) {
        if (this.POINTS == null) {
            return;
        }
        this.POINTS.setSize(d);
    }

    public double getPointWeight() {
        if (this.POINTS == null) {
            return 0.0;
        }
        return this.POINTS.WEIGHT;
    }

    public void setPointWeight(double d) {
        if (this.POINTS == null) {
            return;
        }
        this.POINTS.setWeight(d);
    }

    public ErrorBars getErrorBars() {
        return this.ERRORS;
    }
}

