/*
 * Decompiled with CFR 0.152.
 */
package lightgraph;

import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import lightgraph.DataSet;
import lightgraph.Graph;
import lightgraph.GraphPoints;
import lightgraph.Proceed;

public class GraphLight {
    int COUNTER = 0;
    Graph xy;
    DataSet b;

    GraphLight(Graph xy) {
        this.xy = xy;
        this.b = xy.addData(new double[]{0.0}, new double[]{0.0});
    }

    boolean next() {
        this.b.DATA.get(0).setLocation((double)this.COUNTER * 0.1, 0.0);
        switch (this.COUNTER) {
            case 200: {
                this.xy.setXRange(0.0, 500.0);
                break;
            }
            case 400: {
                this.xy.autoScaleX();
                break;
            }
            case 600: {
                this.xy.setYRange(0.0, 10.0);
                break;
            }
            case 800: {
                this.xy.setXRange(-100.0, 100.0);
                this.xy.setYRange(-5.0, 5.0);
                this.xy.resizeGraph(1000, 1000);
            }
        }
        this.xy.resetGraph();
        this.xy.repaint();
        ++this.COUNTER;
        return this.COUNTER > 1000;
    }

    public static void main(String[] args) {
        double[] x = new double[1000];
        double[] y = new double[1000];
        double[] z = new double[1000];
        for (int i = 0; i < x.length; ++i) {
            x[i] = (double)i * Math.PI * 0.01;
            y[i] = Math.cos(x[i]);
            z[i] = Math.sin(x[i]);
        }
        final Graph xy = new Graph(x, y);
        xy.setContentSize(800, 600);
        xy.setXRange(1.0, 11.5);
        xy.setYRange(-0.5, 0.5);
        xy.appendPoint(0, 0.0, 0.0);
        DataSet ds = xy.getDataSet(0);
        ds.setLabel("cos");
        GraphPoints cross = GraphPoints.crossX();
        cross.setSize(6.0);
        ds.setPoints(cross);
        ds = xy.addData(x, z);
        ds.setLabel("sin");
        GraphPoints squares = GraphPoints.hollowSquares();
        squares.setSize(6.0);
        ds.setPoints(squares);
        xy.setXLabel("theta");
        xy.setYLabel("function");
        xy.setTitle("plot testing");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                xy.show(true);
            }
        });
    }

    public static void main2(String[] args) {
        int i;
        double[] x = new double[1000];
        double[] y = new double[1000];
        double[] y2 = new double[20];
        double[] x2 = new double[20];
        for (i = 0; i < x.length; ++i) {
            x[i] = i - 500;
            y[i] = 0.001 * Math.pow(x[i], 3.0) - 0.05 * Math.pow(x[i], 2.0) + x[i] * 0.8 - 1.0;
        }
        for (i = 0; i < x2.length; ++i) {
            x2[i] = x[i * 50];
            y2[i] = y[i * 50] * (1.25 - 0.5 * Math.random());
        }
        final Graph xy = new Graph(x, y);
        DataSet s = xy.getDataSet(0);
        s.setPoints(null);
        s = xy.addData(x2, y2);
        s.setLine(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                xy.show();
            }
        });
        GraphLight staple = new GraphLight(xy);
        Timer timmy = new Timer();
        timmy.scheduleAtFixedRate((TimerTask)new Proceed(staple), 1000L, 10L);
    }
}

