/*
 * Decompiled with CFR 0.152.
 */
package lightgraph;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import lightgraph.painters.GraphPainter;

public abstract class GraphLine {
    double WIDTH = 1.0;

    public abstract void drawLine(ArrayList<Point2D> var1, GraphPainter var2);

    public double getLineWidth() {
        return this.WIDTH;
    }

    public void setLineWidth(double w) {
        this.WIDTH = w;
    }

    public static GraphLine solidLine() {
        return new GraphLine(){

            @Override
            public void drawLine(ArrayList<Point2D> pts, GraphPainter painter) {
                painter.setLineWidth(this.WIDTH);
                Path2D.Double path = new Path2D.Double();
                if (pts.size() > 0) {
                    Point2D pt = pts.get(0);
                    ((Path2D)path).moveTo(pt.getX(), pt.getY());
                    for (int i = 1; i < pts.size(); ++i) {
                        pt = pts.get(i);
                        ((Path2D)path).lineTo(pt.getX(), pt.getY());
                    }
                    painter.drawPath(path);
                }
                painter.restoreLineWidth();
            }
        };
    }

    public static GraphLine dashes(float[] d) {
        final float[] dashes = d;
        return new GraphLine(){

            @Override
            public void drawLine(ArrayList<Point2D> pts, GraphPainter painter) {
                painter.setLineWidth(this.WIDTH);
                painter.setDashes(dashes);
                Path2D.Double path = new Path2D.Double();
                if (pts.size() > 0) {
                    Point2D pt = pts.get(0);
                    ((Path2D)path).moveTo(pt.getX(), pt.getY());
                    for (int i = 1; i < pts.size(); ++i) {
                        pt = pts.get(i);
                        ((Path2D)path).lineTo(pt.getX(), pt.getY());
                    }
                    painter.drawPath(path);
                }
                painter.setDashes(null);
                painter.restoreLineWidth();
            }
        };
    }

    public static GraphLine shortDashes() {
        return GraphLine.dashes(new float[]{4.0f, 2.0f});
    }

    public static GraphLine longDashes() {
        return GraphLine.dashes(new float[]{10.0f, 2.0f});
    }

    public static GraphLine longShortDashes() {
        return GraphLine.dashes(new float[]{10.0f, 2.0f, 4.0f, 2.0f});
    }

    public static GraphLine longShortShortDashes() {
        return GraphLine.dashes(new float[]{10.0f, 2.0f, 4.0f, 2.0f, 4.0f, 2.0f});
    }

    public static ArrayList<GraphLine> getLines() {
        ArrayList<GraphLine> lines = new ArrayList<GraphLine>();
        lines.add(GraphLine.solidLine());
        lines.add(GraphLine.shortDashes());
        lines.add(GraphLine.longDashes());
        lines.add(GraphLine.longShortDashes());
        lines.add(GraphLine.longShortShortDashes());
        return lines;
    }
}

