/*
 * Decompiled with CFR 0.152.
 */
package lightgraph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JPanel;
import lightgraph.gui.Paintable;

public class GraphPanel
extends JPanel {
    BufferedImage img;
    CopyOnWriteArraySet<Paintable> paintables = new CopyOnWriteArraySet();

    public GraphPanel(BufferedImage img) {
        this.img = img;
        this.setPreferredSize(new Dimension(img.getWidth(), img.getHeight()));
    }

    public void updateImage(BufferedImage img) {
        this.img = img;
        this.repaint();
    }

    public void updateImageSize(Dimension d) {
        this.setPreferredSize(d);
        this.setBounds(0, 0, d.width, d.height);
        this.validate();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(this.img, 0, 0, this.img.getWidth(), this.img.getHeight(), Color.WHITE, this);
        for (Paintable p : this.paintables) {
            p.paint((Graphics2D)g);
        }
    }

    public void addPaintable(Paintable p) {
        this.paintables.add(p);
    }

    public void removePaintable(Paintable p) {
        this.paintables.remove(p);
    }
}

