/*
 * Decompiled with CFR 0.152.
 */
package lightgraph;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import lightgraph.painters.GraphPainter;

public abstract class GraphPoints {
    double SIZE = 6.0;
    double WEIGHT = 1.0;

    public abstract void drawPoint(Point2D var1, GraphPainter var2);

    public void setSize(double s) {
        this.SIZE = s;
    }

    public void setWeight(double w) {
        this.WEIGHT = w;
    }

    public static GraphPoints hollowSquares() {
        return new GraphPoints(){
            Rectangle2D bounds;
            Point2D corner;
            {
                this.bounds = new Rectangle2D.Double(0.0, 0.0, this.SIZE, this.SIZE);
                this.corner = new Point2D.Double(0.0, 0.0);
            }

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                painter.setLineWidth(this.WEIGHT);
                double leg = this.SIZE / 2.0;
                this.corner.setLocation(pt.getX() + leg, pt.getY() + leg);
                this.bounds.setFrameFromCenter(pt, this.corner);
                painter.setFill(true);
                painter.drawPath(this.bounds);
                painter.restoreLineWidth();
                painter.setFill(false);
            }
        };
    }

    public static GraphPoints crossX() {
        return new GraphPoints(){

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                painter.setLineWidth(this.WEIGHT);
                double leg = this.SIZE / 2.0;
                painter.drawLine(pt.getX() - leg, pt.getY() - leg, pt.getX() + leg, pt.getY() + leg);
                painter.drawLine(pt.getX() - leg, pt.getY() + leg, pt.getX() + leg, pt.getY() - leg);
                painter.restoreLineWidth();
            }
        };
    }

    public static GraphPoints crossPlus() {
        return new GraphPoints(){

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                painter.setLineWidth(this.WEIGHT);
                double leg = this.SIZE / 2.0;
                painter.drawLine(pt.getX() - leg, pt.getY(), pt.getX() + leg, pt.getY());
                painter.drawLine(pt.getX(), pt.getY() + leg, pt.getX(), pt.getY() - leg);
                painter.restoreLineWidth();
            }
        };
    }

    public static GraphPoints filledSquares() {
        return new GraphPoints(){
            Rectangle2D bounds;
            Point2D corner;
            {
                this.bounds = new Rectangle2D.Double(0.0, 0.0, this.SIZE, this.SIZE);
                this.corner = new Point2D.Double(0.0, 0.0);
            }

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                double leg = this.SIZE / 2.0;
                this.corner.setLocation(pt.getX() + leg, pt.getY() + leg);
                this.bounds.setFrameFromCenter(pt, this.corner);
                painter.fill(this.bounds);
            }
        };
    }

    static GraphPoints hollowDiamonds() {
        return new GraphPoints(){
            GeneralPath shape;

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                double leg = this.SIZE / 2.0;
                this.shape = new GeneralPath();
                this.shape.moveTo(pt.getX() - leg, pt.getY());
                this.shape.lineTo(pt.getX(), pt.getY() + leg);
                this.shape.lineTo(pt.getX() + leg, pt.getY());
                this.shape.lineTo(pt.getX(), pt.getY() - leg);
                this.shape.closePath();
                painter.setFill(true);
                painter.setLineWidth(this.WEIGHT);
                painter.drawPath(this.shape);
                painter.restoreLineWidth();
                painter.setFill(false);
            }
        };
    }

    public static GraphPoints dots() {
        GraphPoints gp = new GraphPoints(){
            RectangularShape shape = new Ellipse2D.Double(0.0, 0.0, 2.0, 2.0);

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                this.shape.setFrame(pt.getX() - 1.0, pt.getY() - 1.0, 2.0 * this.WEIGHT, 2.0 * this.WEIGHT);
                painter.fill(this.shape);
            }
        };
        return gp;
    }

    public static GraphPoints hollowCircles() {
        GraphPoints gp = new GraphPoints(){
            RectangularShape shape;
            {
                this.shape = new Ellipse2D.Double(0.0, 0.0, this.SIZE, this.SIZE);
            }

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                painter.setFill(true);
                this.shape.setFrame(pt.getX() - this.SIZE / 2.0, pt.getY() - this.SIZE / 2.0, this.SIZE, this.SIZE);
                painter.setLineWidth(this.WEIGHT);
                painter.drawPath(this.shape);
                painter.restoreLineWidth();
                painter.setFill(false);
            }
        };
        return gp;
    }

    public static GraphPoints filledCircles() {
        GraphPoints gp = new GraphPoints(){
            RectangularShape shape;
            {
                this.shape = new Ellipse2D.Double(0.0, 0.0, this.SIZE, this.SIZE);
            }

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                this.shape.setFrame(pt.getX() - this.SIZE / 2.0, pt.getY() - this.SIZE / 2.0, this.SIZE, this.SIZE);
                painter.fill(this.shape);
            }
        };
        return gp;
    }

    public static GraphPoints outlinedTriangles() {
        GraphPoints gp = new GraphPoints(){
            GeneralPath shape;

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                double x = pt.getX();
                double y = pt.getY();
                this.shape = new GeneralPath();
                this.shape.moveTo(x, y - Math.sqrt(3.0) * 0.25 * this.SIZE);
                this.shape.lineTo(0.5 * this.SIZE + x, Math.sqrt(3.0) * 0.25 * this.SIZE + y);
                this.shape.lineTo(-0.5 * this.SIZE + x, Math.sqrt(3.0) * 0.25 * this.SIZE + y);
                this.shape.closePath();
                painter.fill(this.shape);
                Color c = painter.getColor();
                painter.setColor(Color.BLACK);
                painter.setLineWidth(this.WEIGHT);
                painter.drawPath(this.shape);
                painter.restoreLineWidth();
                painter.setColor(c);
            }
        };
        return gp;
    }

    public static GraphPoints hollowTriangles() {
        GraphPoints gp = new GraphPoints(){
            GeneralPath shape;

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                double x = pt.getX();
                double y = pt.getY();
                this.shape = new GeneralPath();
                this.shape.moveTo(x, y - Math.sqrt(3.0) * 0.25 * this.SIZE);
                this.shape.lineTo(0.5 * this.SIZE + x, Math.sqrt(3.0) * 0.25 * this.SIZE + y);
                this.shape.lineTo(-0.5 * this.SIZE + x, Math.sqrt(3.0) * 0.25 * this.SIZE + y);
                this.shape.closePath();
                painter.setFill(true);
                painter.setLineWidth(this.WEIGHT);
                painter.drawPath(this.shape);
                painter.setFill(false);
                painter.restoreLineWidth();
            }
        };
        return gp;
    }

    public static GraphPoints filledTriangles() {
        GraphPoints gp = new GraphPoints(){
            GeneralPath shape;
            AffineTransform at = new AffineTransform();

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                double x = pt.getX();
                double y = pt.getY();
                this.shape = new GeneralPath();
                this.shape.moveTo(x, y - Math.sqrt(3.0) * 0.25 * this.SIZE);
                this.shape.lineTo(0.5 * this.SIZE + x, Math.sqrt(3.0) * 0.25 * this.SIZE + y);
                this.shape.lineTo(-0.5 * this.SIZE + x, Math.sqrt(3.0) * 0.25 * this.SIZE + y);
                this.shape.closePath();
                painter.fill(this.shape);
            }
        };
        return gp;
    }

    public static GraphPoints outlinedCircles() {
        GraphPoints gp = new GraphPoints(){
            RectangularShape shape;
            {
                this.shape = new Ellipse2D.Double(0.0, 0.0, this.SIZE, this.SIZE);
            }

            @Override
            public void drawPoint(Point2D pt, GraphPainter painter) {
                Color c = painter.getColor();
                this.shape.setFrame(pt.getX() - this.SIZE / 2.0, pt.getY() - this.SIZE / 2.0, this.SIZE, this.SIZE);
                painter.fill(this.shape);
                painter.setColor(Color.BLACK);
                painter.setLineWidth(this.WEIGHT);
                painter.drawPath(this.shape);
                painter.restoreLineWidth();
                painter.setColor(c);
            }
        };
        return gp;
    }

    public static List<GraphPoints> getGraphPoints() {
        ArrayList<GraphPoints> points = new ArrayList<GraphPoints>();
        points.add(GraphPoints.crossPlus());
        points.add(GraphPoints.crossX());
        points.add(GraphPoints.dots());
        points.add(GraphPoints.hollowCircles());
        points.add(GraphPoints.filledCircles());
        points.add(GraphPoints.hollowSquares());
        points.add(GraphPoints.hollowDiamonds());
        points.add(GraphPoints.filledSquares());
        points.add(GraphPoints.outlinedTriangles());
        points.add(GraphPoints.hollowTriangles());
        points.add(GraphPoints.filledTriangles());
        points.add(GraphPoints.outlinedCircles());
        return points;
    }
}

