/*
 * Decompiled with CFR 0.152.
 */
package lightgraph.elements;

import java.awt.geom.Point2D;
import lightgraph.DataSet;
import lightgraph.Graph;
import lightgraph.painters.GraphPainter;

public class ErrorBars {
    double SCALEX = 1.0;
    double SCALEY = 1.0;
    public static final int XAXIS = 0;
    public static final int YAXIS = 1;
    double[] x_errors;
    double[] y_errors;
    private double size = 4.0;
    private double weight = 1.0;

    public ErrorBars(double[] errors, int axis) {
        if (axis == 0) {
            this.x_errors = errors;
        } else if (axis == 1) {
            this.y_errors = errors;
        } else {
            throw new IllegalArgumentException(String.format("Not a valid axis: %d", axis));
        }
    }

    public ErrorBars(double[] xerrors, double[] yerrors) {
        this.x_errors = xerrors;
        this.y_errors = yerrors;
    }

    public void setScale(double scale_x, double scale_y) {
        this.SCALEX = scale_x;
        this.SCALEY = scale_y;
    }

    public void drawErrorAt(int i, Point2D pt, GraphPainter painter) {
        double end;
        double leg;
        if (this.x_errors != null && i < this.x_errors.length) {
            painter.setLineWidth(this.weight);
            leg = this.x_errors[i] * this.SCALEX;
            end = this.size / 2.0;
            painter.drawLine(pt.getX() - leg, pt.getY(), pt.getX() + leg, pt.getY());
            painter.drawLine(pt.getX() - leg, pt.getY() + end, pt.getX() - leg, pt.getY() - end);
            painter.drawLine(pt.getX() + leg, pt.getY() + end, pt.getX() + leg, pt.getY() - end);
            painter.restoreLineWidth();
        }
        if (this.y_errors != null && i < this.y_errors.length) {
            painter.setLineWidth(this.weight);
            leg = this.y_errors[i] * this.SCALEY;
            end = this.size / 2.0;
            painter.drawLine(pt.getX(), pt.getY() + leg, pt.getX(), pt.getY() - leg);
            painter.drawLine(pt.getX() - end, pt.getY() + leg, pt.getX() + end, pt.getY() + leg);
            painter.drawLine(pt.getX() - end, pt.getY() - leg, pt.getX() + end, pt.getY() - leg);
            painter.restoreLineWidth();
        }
    }

    public void setWeight(double v) {
        this.weight = v;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public static void main(String[] args) {
        int n = 20;
        double[] x = new double[n];
        double[] y = new double[n];
        double[] z = new double[n];
        double[] y1 = new double[n];
        double[] y2 = new double[n];
        double[] z2 = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = 0.25 * (double)i;
            y[i] = 3.5 - x[i] * x[i];
            y1[i] = y[i] + 10.0;
            y2[i] = y[i] - 10.0;
            z[i] = Math.sqrt(x[i]);
            z2[i] = 0.1 * z[i];
        }
        Graph g = new Graph();
        DataSet set = g.addData(x, y);
        set.addYErrorBars(z);
        set = g.addData(x, y1);
        set.addXErrorBars(z2);
        set = g.addData(x, y2);
        set.addXYErrorBars(z2, z);
        g.show(true, "Error Bar Test");
    }

    public boolean hasXData() {
        return this.x_errors != null;
    }

    public boolean hasYData() {
        return this.y_errors != null;
    }

    public double[] getErrorData(int axis) {
        switch (axis) {
            case 0: {
                return this.x_errors;
            }
            case 1: {
                return this.y_errors;
            }
        }
        throw new IllegalArgumentException("Axis must be either x, 0, or y, 1. Provided value: " + axis);
    }
}

