/*
 * Decompiled with CFR 0.152.
 */
package lightgraph.graphfx;

import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import lightgraph.DataSet;
import lightgraph.Graph;
import lightgraph.painters.SvgPainter;

public class GraphFx
extends Application {
    private Graph graph;
    WebView view;

    public void startGraph() {
        this.graph = new Graph();
    }

    public void start(Stage stage) throws Exception {
        this.startGraph();
        BorderPane root = new BorderPane();
        this.view = new WebView();
        root.setCenter((Node)this.view);
        stage.setScene(new Scene((Parent)root, 600.0, 600.0));
        stage.show();
        int n = 100;
        double[] x = new double[n];
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = 5.0 - 0.1 * (double)i;
            y[i] = x[i] * x[i] - 2.0;
        }
        this.addData(x, y);
        this.graph.setXLabel("x");
        this.graph.setYLabel("x<tspan baseline-shift=\"super\" font-size=\"8pt\">2</tspan>");
        this.refreshGraph();
    }

    public void refreshGraph() {
        SvgPainter painter = new SvgPainter(this.graph.CHEIGHT, this.graph.CWIDTH, this.graph.getBackground());
        this.graph.resetGraph(painter);
        String op = painter.getOutput();
        WebEngine webEngine = this.view.getEngine();
        webEngine.loadContent(String.format("<html>%s</html>", op));
        webEngine.loadContent(op);
        webEngine.reload();
    }

    public DataSet addData(double[] x, double[] y) {
        return this.graph.addData(x, y);
    }

    public static void main(String[] args) {
        GraphFx.launch((String[])args);
    }
}

