/*
 * Decompiled with CFR 0.152.
 */
package lightgraph.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lightgraph.DataSet;
import lightgraph.Graph;
import lightgraph.GraphLine;
import lightgraph.GraphPoints;
import lightgraph.gui.ColorSelector;
import lightgraph.gui.GraphFormatWindow;
import lightgraph.gui.LineSelector;
import lightgraph.gui.PointSelector;

class DataSetRow {
    DataSet set;
    List<GraphPoints> points = GraphPoints.getGraphPoints();
    List<GraphLine> lines;
    JPanel panel;
    PointSelector point_selector;
    LineSelector line_selector;
    ColorSelector color_selector;
    JTextField label;
    JTextField line_width;
    JTextField point_size;
    JTextField point_weight;

    public DataSetRow(DataSet set, Graph graph) {
        this.points.add(null);
        this.lines = GraphLine.getLines();
        this.lines.add(null);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 2));
        String t = set.label == null ? "" : set.label;
        this.label = new JTextField(t);
        GraphFormatWindow.sizeComponent(this.label, 100, 25);
        this.panel.add(this.label);
        JLabel lw_label = new JLabel("Line Width: ");
        this.panel.add(lw_label);
        this.line_width = new JTextField(String.format("%2.1f", set.getLineWidth()));
        GraphFormatWindow.sizeComponent(this.line_width, 50, 25);
        this.panel.add(this.line_width);
        this.set = set;
        this.line_selector = new LineSelector(set.LINE, set.COLOR, graph.getBackground());
        this.panel.add(this.line_selector);
        this.line_selector.addMouseListener(new MouseListener(){
            int index = 0;

            @Override
            public void mouseClicked(MouseEvent e) {
                ++this.index;
                if (this.index >= DataSetRow.this.lines.size()) {
                    this.index = 0;
                }
                DataSetRow.this.line_selector.setLine(DataSetRow.this.lines.get(this.index));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.point_selector = new PointSelector(set.POINTS, set.COLOR, graph.getBackground());
        this.panel.add(this.point_selector);
        this.point_selector.addMouseListener(new MouseListener(){
            int index = 0;

            @Override
            public void mouseClicked(MouseEvent e) {
                ++this.index;
                if (this.index >= DataSetRow.this.points.size()) {
                    this.index = 0;
                }
                DataSetRow.this.point_selector.setPoints(DataSetRow.this.points.get(this.index));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JLabel ps_label = new JLabel("Point Size: ");
        this.panel.add(ps_label);
        this.point_size = new JTextField(String.format("%2.1f", set.getPointSize()));
        GraphFormatWindow.sizeComponent(this.point_size, 50, 25);
        this.panel.add(this.point_size);
        JLabel pw_label = new JLabel("Point Weight: ");
        this.panel.add(pw_label);
        this.point_weight = new JTextField(String.format("%2.1f", set.getPointWeight()));
        GraphFormatWindow.sizeComponent(this.point_weight, 50, 25);
        this.panel.add(this.point_weight);
        this.color_selector = new ColorSelector(set.COLOR);
        this.panel.add(this.color_selector);
        this.color_selector.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                final JDialog dialog = new JDialog(null, "Choose a Color", Dialog.ModalityType.APPLICATION_MODAL);
                final JColorChooser chooser = new JColorChooser(DataSetRow.this.color_selector.getColor());
                Container cont = dialog.getContentPane();
                JPanel row = new JPanel();
                row.setLayout(new BoxLayout(row, 2));
                JButton cancel = new JButton("cancel");
                row.add(cancel);
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.setVisible(false);
                    }
                });
                JButton accept = new JButton("accept");
                accept.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataSetRow.this.color_selector.setColor(chooser.getColor());
                        DataSetRow.this.point_selector.setColor(chooser.getColor());
                        DataSetRow.this.line_selector.setColor(chooser.getColor());
                        dialog.setVisible(false);
                    }
                });
                row.add(accept);
                cont.add((Component)row, "South");
                cont.add((Component)chooser, "Center");
                dialog.pack();
                dialog.setVisible(true);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    void updateSet() {
        this.set.setPoints(this.point_selector.getPoints());
        double d = Double.parseDouble(this.point_size.getText());
        this.set.setPointSize(d);
        d = Double.parseDouble(this.point_weight.getText());
        this.set.setPointWeight(d);
        this.set.setColor(this.color_selector.getColor());
        String l = this.label.getText().trim();
        this.set.label = l.isEmpty() ? null : l;
        this.set.setLine(this.line_selector.getLine());
        d = Double.parseDouble(this.line_width.getText());
        if (d == 0.0 || this.line_selector.getLine() == null) {
            this.set.setLine(null);
        } else {
            this.set.setLineWidth(d);
        }
    }

    DataSet getSet() {
        return this.set;
    }
}

