/*
 * Decompiled with CFR 0.152.
 */
package lightgraph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lightgraph.DataSet;
import lightgraph.Graph;
import lightgraph.gui.DataSetRow;

public class GraphFormatWindow {
    Graph graph;
    JCheckBox autox;
    JCheckBox autoy;
    JTextField xrange_low;
    JTextField xrange_high;
    JTextField yrange_low;
    JTextField yrange_high;
    JTextField width;
    JTextField height;
    JTextField font_size;
    JTextField x_tics;
    JTextField y_tics;
    JTextField key_x;
    JTextField key_y;
    JTextField xlabel;
    JTextField ylabel;
    JTextField title;
    final JFrame frame = new JFrame("graph format window");
    ArrayList<DataSetRow> datasets = new ArrayList();
    JPanel dataset_pane;

    public GraphFormatWindow(Graph graph) {
        this.graph = graph;
    }

    public void initialize() {
        this.frame.setSize(600, 600);
        ArrayList<Component> rowlist = new ArrayList<Component>();
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 3));
        rowlist.add(new JLabel("Width:"));
        this.width = new JTextField();
        GraphFormatWindow.sizeComponent(this.width, 80, 20);
        rowlist.add(this.width);
        rowlist.add(new JLabel("    Height: "));
        this.height = new JTextField();
        GraphFormatWindow.sizeComponent(this.height, 80, 20);
        rowlist.add(this.height);
        content.add(this.createRow(rowlist));
        rowlist.add(new JLabel("X-TICS: "));
        this.x_tics = new JTextField("" + this.graph.getXTicCount());
        GraphFormatWindow.sizeComponent(this.x_tics, 40, 20);
        rowlist.add(this.x_tics);
        rowlist.add(new JLabel("Y-TICS: "));
        this.y_tics = new JTextField("" + this.graph.getYTicCount());
        GraphFormatWindow.sizeComponent(this.y_tics, 40, 20);
        rowlist.add(this.y_tics);
        content.add(this.createRow(rowlist));
        rowlist.add(new JLabel("Font Size:"));
        this.font_size = new JTextField();
        this.font_size.setText("not impl.");
        this.font_size.setEnabled(false);
        rowlist.add(this.font_size);
        GraphFormatWindow.sizeComponent(this.font_size, 80, 20);
        rowlist.add(new JLabel("Key X"));
        this.key_x = new JTextField();
        rowlist.add(this.key_x);
        GraphFormatWindow.sizeComponent(this.key_x, 80, 20);
        rowlist.add(new JLabel("Key Y"));
        this.key_y = new JTextField();
        rowlist.add(this.key_y);
        GraphFormatWindow.sizeComponent(this.key_y, 80, 20);
        content.add(this.createRow(rowlist));
        this.createXRangeComponents(content);
        this.createYRangeComponents(content);
        this.createLabelComponents(content);
        this.dataset_pane = new JPanel();
        this.dataset_pane.setLayout(new BoxLayout(this.dataset_pane, 3));
        JScrollPane jsp = new JScrollPane(this.dataset_pane, 20, 30);
        content.add(jsp);
        content.add(Box.createVerticalGlue());
        JButton cancel = new JButton("cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphFormatWindow.this.frame.setVisible(false);
            }
        });
        JButton accept = new JButton("accept");
        accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphFormatWindow.this.changeSettings();
            }
        });
        rowlist.add(Box.createHorizontalGlue());
        rowlist.add(cancel);
        rowlist.add(accept);
        content.add(this.createRow(rowlist));
        this.frame.add(content);
    }

    void createLabelComponents(JPanel content) {
        JLabel xlabel_label = new JLabel("x-axis label: ");
        JLabel ylabel_label = new JLabel("y-axis label: ");
        JLabel title_label = new JLabel("title: ");
        this.xlabel = new JTextField();
        this.ylabel = new JTextField();
        this.title = new JTextField();
        GraphFormatWindow.sizeComponent(this.xlabel, 300, 20);
        GraphFormatWindow.sizeComponent(this.ylabel, 300, 20);
        GraphFormatWindow.sizeComponent(this.title, 300, 20);
        JPanel row = new JPanel();
        BoxLayout lay = new BoxLayout(row, 2);
        row.setLayout(lay);
        row.add(xlabel_label);
        row.add(this.xlabel);
        content.add(row);
        row = new JPanel();
        lay = new BoxLayout(row, 2);
        row.setLayout(lay);
        row.add(ylabel_label);
        row.add(this.ylabel);
        content.add(row);
        row = new JPanel();
        lay = new BoxLayout(row, 2);
        row.setLayout(lay);
        row.add(title_label);
        row.add(this.title);
        content.add(row);
    }

    void createXRangeComponents(JPanel content) {
        ArrayList<Component> rowlist = new ArrayList<Component>();
        JLabel autox_label = new JLabel("Autoscale x axis:");
        this.xrange_low = new JTextField();
        GraphFormatWindow.sizeComponent(this.xrange_low, 80, 20);
        this.xrange_high = new JTextField();
        GraphFormatWindow.sizeComponent(this.xrange_high, 80, 20);
        this.autox = new JCheckBox();
        this.autox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean v = GraphFormatWindow.this.autox.isSelected();
                GraphFormatWindow.this.xrange_low.setEnabled(!v);
                GraphFormatWindow.this.xrange_high.setEnabled(!v);
            }
        });
        rowlist.add(autox_label);
        rowlist.add(this.autox);
        rowlist.add(autox_label);
        rowlist.add(new JLabel("   low: "));
        rowlist.add(this.xrange_low);
        rowlist.add(new JLabel("   high: "));
        rowlist.add(this.xrange_high);
        content.add(this.createRow(rowlist));
    }

    void createYRangeComponents(JPanel content) {
        ArrayList<Component> rowlist = new ArrayList<Component>();
        JLabel autoy_label = new JLabel("Autoscale y axis:");
        this.yrange_low = new JTextField();
        GraphFormatWindow.sizeComponent(this.yrange_low, 80, 20);
        this.yrange_high = new JTextField();
        GraphFormatWindow.sizeComponent(this.yrange_high, 80, 20);
        this.autoy = new JCheckBox();
        this.autoy.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean v = GraphFormatWindow.this.autoy.isSelected();
                GraphFormatWindow.this.yrange_low.setEnabled(!v);
                GraphFormatWindow.this.yrange_high.setEnabled(!v);
            }
        });
        rowlist.add(autoy_label);
        rowlist.add(this.autoy);
        rowlist.add(autoy_label);
        rowlist.add(new JLabel("   low: "));
        rowlist.add(this.yrange_low);
        rowlist.add(new JLabel("   high: "));
        rowlist.add(this.yrange_high);
        content.add(this.createRow(rowlist));
    }

    void changeSettings() {
        if (!this.validateInputs()) {
            return;
        }
        this.frame.setVisible(false);
        if (this.autox.isSelected()) {
            this.graph.AUTOX = true;
        } else {
            this.graph.setXRange(Double.parseDouble(this.xrange_low.getText()), Double.parseDouble(this.xrange_high.getText()));
        }
        if (this.autoy.isSelected()) {
            this.graph.AUTOY = true;
        } else {
            this.graph.setYRange(Double.parseDouble(this.yrange_low.getText()), Double.parseDouble(this.yrange_high.getText()));
        }
        this.graph.CHEIGHT = (int)Double.parseDouble(this.height.getText());
        this.graph.CWIDTH = (int)Double.parseDouble(this.width.getText());
        this.graph.panel.setBounds(0, 0, this.graph.CWIDTH, this.graph.CHEIGHT);
        int i = Integer.parseInt(this.x_tics.getText());
        this.graph.setXTicCount(i);
        i = Integer.parseInt(this.y_tics.getText());
        this.graph.setYTicCount(i);
        double d = Double.parseDouble(this.key_x.getText());
        this.graph.setKeyX(d);
        d = Double.parseDouble(this.key_y.getText());
        this.graph.setKeyY(d);
        for (DataSetRow row : this.datasets) {
            row.updateSet();
        }
        this.graph.setTitle(this.title.getText());
        this.graph.setXLabel(this.xlabel.getText());
        this.graph.setYLabel(this.ylabel.getText());
        this.graph.refresh(true);
    }

    boolean validateInputs() {
        boolean r = this.validateDoubleField(this.xrange_high);
        r &= this.validateDoubleField(this.yrange_low);
        r &= this.validateDoubleField(this.yrange_high);
        r &= this.validateDoubleField(this.xrange_low);
        r &= this.validateDoubleField(this.width, 0.0);
        r &= this.validateDoubleField(this.height, 0.0);
        r &= this.validateDoubleField(this.key_x, 0.0);
        r &= this.validateDoubleField(this.key_y, 0.0);
        r &= this.validateIntField(this.x_tics);
        r &= this.validateIntField(this.y_tics);
        for (DataSetRow s : this.datasets) {
            r &= this.validateDoubleField(s.line_width, 0.0);
            r &= this.validateDoubleField(s.point_size, 0.0);
            r &= this.validateDoubleField(s.point_weight, 0.0);
        }
        return r;
    }

    boolean validateDoubleField(JTextField t) {
        if (!t.isEnabled()) {
            return true;
        }
        try {
            Double.parseDouble(t.getText());
            t.setBackground(Color.WHITE);
        }
        catch (NumberFormatException exc) {
            exc.printStackTrace();
            t.setBackground(Color.RED);
            return false;
        }
        return true;
    }

    boolean validateDoubleField(JTextField t, double min) {
        if (!t.isEnabled()) {
            return true;
        }
        try {
            double d = Double.parseDouble(t.getText());
            if (d < min) {
                throw new NumberFormatException(String.format("values less than %f are not acceptable.", min));
            }
            t.setBackground(Color.WHITE);
        }
        catch (NumberFormatException exc) {
            exc.printStackTrace();
            t.setBackground(Color.RED);
            return false;
        }
        return true;
    }

    boolean validateIntField(JTextField t) {
        if (!t.isEnabled()) {
            return true;
        }
        try {
            int d = Integer.parseInt(t.getText());
            if (d < 0) {
                throw new NumberFormatException("values less than zero are not acceptable.");
            }
            t.setBackground(Color.WHITE);
        }
        catch (NumberFormatException exc) {
            exc.printStackTrace();
            t.setBackground(Color.RED);
            return false;
        }
        return true;
    }

    public static void sizeComponent(Component c, int width, int height) {
        Dimension d = new Dimension(width, height);
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        c.setPreferredSize(d);
    }

    JPanel createRow(List<Component> components) {
        JPanel row = new JPanel();
        row.setLayout(new BoxLayout(row, 2));
        for (Component c : components) {
            row.add(c);
        }
        components.clear();
        return row;
    }

    public void display() {
        this.parseGraph();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphFormatWindow.this.frame.setVisible(true);
            }
        });
    }

    public void parseGraph() {
        if (this.graph.AUTOX) {
            this.autox.setSelected(true);
        } else {
            this.autox.setSelected(false);
        }
        this.xrange_low.setText("" + this.graph.MINX);
        this.xrange_high.setText("" + this.graph.MAXX);
        if (this.graph.AUTOY) {
            this.autoy.setSelected(true);
        } else {
            this.autoy.setSelected(false);
        }
        this.yrange_low.setText("" + this.graph.MINY);
        this.yrange_high.setText("" + this.graph.MAXY);
        this.height.setText(String.valueOf(this.graph.CHEIGHT));
        this.width.setText(String.valueOf(this.graph.CWIDTH));
        this.key_x.setText(String.format("%.2f", this.graph.getKeyX()));
        this.key_y.setText(String.format("%.2f", this.graph.getKeyY()));
        this.title.setText(this.graph.getTitle());
        this.xlabel.setText(this.graph.getXLabel());
        this.ylabel.setText(this.graph.getYLabel());
        this.createDataSetRows();
    }

    void createDataSetRows() {
        ArrayList<DataSet> sets = new ArrayList<DataSet>();
        sets.addAll(this.graph.DATASETS);
        for (DataSetRow dsr : this.datasets) {
            if (sets.contains(dsr.getSet())) {
                sets.remove(dsr.getSet());
                continue;
            }
            this.dataset_pane.remove(dsr.panel);
        }
        for (DataSet set : sets) {
            DataSetRow row = new DataSetRow(set, this.graph);
            this.dataset_pane.add(row.panel);
            this.datasets.add(row);
        }
    }
}

