/*
 * Decompiled with CFR 0.152.
 */
package lightgraph.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import lightgraph.GraphLine;
import lightgraph.painters.PanelPainter;

class LineSelector
extends JPanel {
    Dimension d = new Dimension(80, 40);
    ArrayList<Point2D> sample;
    Point2D start = new Point2D.Double(20.0, 20.0);
    Point2D end = new Point2D.Double(60.0, 20.0);
    GraphLine line;
    Color color;
    Color background;

    LineSelector(GraphLine l, Color fore, Color back) {
        this.setMaximumSize(this.d);
        this.setMinimumSize(this.d);
        this.setPreferredSize(this.d);
        this.color = fore;
        this.background = back;
        this.line = l;
        this.sample = new ArrayList();
        this.sample.add(this.start);
        this.sample.add(this.end);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.background);
        g.fillRect(0, 0, (int)this.d.getWidth(), (int)this.d.getHeight());
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, (int)this.d.getWidth() - 1, (int)this.d.getHeight() - 1);
        g.setColor(this.color);
        PanelPainter painter = new PanelPainter((Graphics2D)g, this.background);
        if (this.line != null) {
            this.line.drawLine(this.sample, painter);
        }
    }

    public void setLine(GraphLine l) {
        this.line = l;
        this.repaint();
    }

    public GraphLine getLine() {
        return this.line;
    }

    public void setColor(Color c) {
        this.color = c;
        this.repaint();
    }
}

