/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.commons.printer;

import org.orbisgis.commons.annotations.NotNull;
import org.orbisgis.commons.printer.CustomPrinter;
import org.orbisgis.commons.printer.ICustomPrinter;
import org.orbisgis.commons.utilities.CheckUtils;

public class Html
extends CustomPrinter {
    public Html(@NotNull StringBuilder builder) {
        super(builder);
    }

    public Html() {
        super(new StringBuilder());
    }

    @Override
    public void appendTableLineSeparator() {
        if (this.isDrawingTable) {
            this.builder.append("<tr></tr>\n");
        }
    }

    @Override
    public void startTable(int columnWidth, int columnCount) {
        this.builder.append("<table>\n");
        super.startTable(columnWidth, columnCount);
    }

    @Override
    public void endTable() {
        super.endTable();
        this.builder.append("</table>\n");
    }

    @Override
    public void appendTableValue(@NotNull Object value, @NotNull ICustomPrinter.CellPosition position) {
        CheckUtils.checkNotNull(value, "The value to append should not be null.");
        CheckUtils.checkNotNull((Object)position, "The position of the value should not be null.");
        if (this.isDrawingTable) {
            Object cut;
            if (this.columnIndex == 0) {
                this.builder.append("<tr>\n");
            }
            if (((String)(cut = value.toString())).length() > this.columnWidth) {
                cut = ((String)cut).substring(0, this.columnWidth - 3) + "...";
            }
            this.builder.append("<td align=\"");
            this.builder.append((Object)position);
            this.builder.append("\">");
            this.builder.append((String)cut);
            this.builder.append("</td>");
            this.builder.append("\n");
            ++this.columnIndex;
            if (this.columnIndex == this.columnCount) {
                this.builder.append("</tr>\n");
                this.columnIndex = 0;
            }
        }
    }

    @Override
    public void appendTableHeaderValue(@NotNull Object value, @NotNull ICustomPrinter.CellPosition position) {
        CheckUtils.checkNotNull(value, "The value to append should not be null.");
        CheckUtils.checkNotNull((Object)position, "The position of the value should not be null.");
        if (this.isDrawingTable) {
            Object cut;
            if (this.columnIndex == 0) {
                this.builder.append("<tr>\n");
            }
            if (((String)(cut = value.toString())).length() > this.columnWidth) {
                cut = ((String)cut).substring(0, this.columnWidth - 3) + "...";
            }
            this.builder.append("<th align=\"");
            this.builder.append((Object)position);
            this.builder.append("\">");
            this.builder.append((String)cut);
            this.builder.append("</th>");
            this.builder.append("\n");
            ++this.columnIndex;
            if (this.columnIndex == this.columnCount) {
                this.builder.append("</tr>\n");
                this.columnIndex = 0;
            }
        }
    }

    @Override
    public void appendTableTitle(@NotNull Object title) {
        CheckUtils.checkNotNull(title, "The title to append should not be null.");
        if (this.isDrawingTable) {
            Object cut = title.toString();
            if (((String)cut).length() > this.columnWidth) {
                cut = ((String)cut).substring(0, this.columnWidth - 3) + "...";
            }
            this.builder.append("<caption>");
            this.builder.append((String)cut);
            this.builder.append("</caption>\n");
        }
    }

    @Override
    public void appendValue(Object value) {
        CheckUtils.checkNotNull(value, "The value to append should not be null.");
        if (this.isDrawingTable) {
            this.appendTableValue(value);
        } else {
            this.builder.append("<p>").append(value).append("</p>\n");
        }
    }
}

