/*
 * Decompiled with CFR 0.152.
 */
package org.cts;

import java.util.ArrayList;
import java.util.List;
import org.cts.Identifiable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Identifier
implements Identifiable {
    private static int localId = 0;
    private String authorityName;
    private String authorityKey;
    private String name;
    private String shortName;
    private String remarks;
    private List<Identifiable> aliases;

    public static int getNewId() {
        return localId++;
    }

    public Identifier(String authorityName, String authorityKey, String name, String shortName, String remarks, List<Identifiable> aliases) {
        this.authorityName = authorityName;
        this.authorityKey = authorityKey;
        this.name = name;
        this.shortName = shortName;
        this.remarks = remarks;
        this.aliases = aliases;
    }

    public Identifier(Class clazz) {
        this("LOCAL_" + clazz.getSimpleName(), "" + Identifier.getNewId(), "UNKNOWN", null, null, null);
    }

    public Identifier(Class clazz, String name) {
        this("LOCAL_" + clazz.getSimpleName(), "" + Identifier.getNewId(), name, null, null, null);
    }

    public Identifier(Class clazz, String name, String shortName) {
        this("LOCAL_" + clazz.getSimpleName(), "" + Identifier.getNewId(), name, shortName, null, null);
    }

    public Identifier(Class clazz, String name, String shortName, List<Identifiable> aliases) {
        this("LOCAL_" + clazz.getSimpleName(), "" + Identifier.getNewId(), name, shortName, null, aliases);
    }

    public Identifier(String authorityName, String authorityKey, String name) {
        this(authorityName, authorityKey, name, null, null, null);
    }

    public Identifier(String authorityName, String authorityKey, String name, String shortName) {
        this(authorityName, authorityKey, name, shortName, null, null);
    }

    @Override
    public String getAuthorityName() {
        return this.authorityName;
    }

    @Override
    public String getAuthorityKey() {
        return this.authorityKey;
    }

    @Override
    public String getCode() {
        return this.authorityName + ":" + this.authorityKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName == null ? this.name : this.shortName;
    }

    @Override
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public void addRemark(String new_remark) {
        this.remarks = this.remarks + "\n" + new_remark;
    }

    @Override
    public List<Identifiable> getAliases() {
        return this.aliases == null ? new ArrayList() : this.aliases;
    }

    @Override
    public boolean addAlias(Identifiable alias) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<Identifiable>();
        }
        return this.aliases.add(alias);
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("AUTHORITY[\"");
        w.append(this.getAuthorityName());
        w.append("\",\"");
        w.append(this.getAuthorityKey());
        w.append("\"]");
        return w.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Identifier) {
            Identifier other = (Identifier)object;
            if (this.getCode().equals(other.getCode())) {
                return true;
            }
            for (Identifiable id1 : this.getAliases()) {
                boolean areEquals = id1.getCode().equals(other.getCode());
                if (areEquals) {
                    return true;
                }
                for (Identifiable id2 : other.getAliases()) {
                    areEquals = id2.getCode().equals(this.getCode());
                    if (areEquals) {
                        return true;
                    }
                    if (!id1.getCode().equals(id2.getCode())) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.authorityKey != null ? this.authorityKey.hashCode() : 0);
        hash = 11 * hash + (this.aliases != null ? this.aliases.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "[" + this.authorityName + ":" + this.authorityKey + "] " + this.name;
    }
}

