/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.CoordinateOperation;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambertAzimuthalEqualArea
extends Projection {
    public static final Identifier LAEA = new Identifier("EPSG", "9820", "Lambert Azimuthal Equal Area", "LAEA");
    protected final double lat0;
    protected final double lon0 = this.getCentralMeridian();
    protected final double FE;
    protected final double FN;
    protected final double beta0;
    protected final double qp;
    protected final double D;
    protected final double Rq;

    public LambertAzimuthalEqualArea(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(LAEA, ellipsoid, parameters);
        this.lat0 = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        double e = ellipsoid.getEccentricity();
        double e2 = ellipsoid.getSquareEccentricity();
        this.qp = 1.0 - (1.0 - e2) / 2.0 / e * Math.log((1.0 - e) / (1.0 + e));
        double esin0 = e * Math.sin(this.lat0);
        double q0 = (1.0 - e2) * (Math.sin(this.lat0) / (1.0 - esin0 * esin0) - Math.log((1.0 - esin0) / (1.0 + esin0)) / 2.0 / e);
        this.beta0 = Math.asin(q0 / this.qp);
        this.Rq = ellipsoid.getSemiMajorAxis() * Math.pow(this.qp / 2.0, 0.5);
        this.D = ellipsoid.getSemiMajorAxis() * Math.cos(this.lat0) / Math.sqrt(1.0 - esin0 * esin0) / this.Rq / Math.cos(this.beta0);
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double e = this.ellipsoid.getEccentricity();
        double e2 = this.ellipsoid.getSquareEccentricity();
        double esin = e * Math.sin(coord[0]);
        double q = (1.0 - e2) * (Math.sin(coord[0]) / (1.0 - esin * esin) - Math.log((1.0 - esin) / (1.0 + esin)) / 2.0 / e);
        double beta = Math.asin(q / this.qp);
        double B = this.Rq * Math.sqrt(2.0 / (1.0 + Math.sin(this.beta0) * Math.sin(beta) + Math.cos(this.beta0) * Math.cos(beta) * Math.cos(coord[1] - this.lon0)));
        coord[0] = this.FE + B * this.D * Math.cos(beta) * Math.sin(coord[1] - this.lon0);
        coord[1] = this.FN + B / this.D * (Math.cos(this.beta0) * Math.sin(beta) - Math.sin(this.beta0) * Math.cos(beta) * Math.cos(coord[1] - this.lon0));
        return coord;
    }

    @Override
    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        return new LambertAzimuthalEqualArea(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                double e = this.ellipsoid.getEccentricity();
                double e2 = this.ellipsoid.getSquareEccentricity();
                double e4 = e2 * e2;
                double e6 = e4 * e2;
                double x = (coord[0] - this.FE) / this.D;
                double y = (coord[1] - this.FN) * this.D;
                double rho = Math.sqrt(x * x + y * y);
                double C = 2.0 * Math.asin(rho / 2.0 / this.Rq);
                double betap = Math.asin(Math.cos(C) * Math.sin(this.beta0) + y * Math.sin(C) * Math.cos(this.beta0) / rho);
                coord[0] = betap + (e2 / 3.0 + 0.0 * e4 + 0.0 * e6) * Math.sin(2.0 * betap) + (0.0 * e4 + 0.0 * e6) * Math.sin(4.0 * betap) + 0.0 * e6 * Math.sin(6.0 * betap);
                coord[1] = this.lon0 + Math.atan(x * Math.sin(C) / (rho * Math.cos(this.beta0) * Math.cos(C) - y * Math.sin(this.beta0) * Math.sin(C)));
                return coord;
            }
        };
    }
}

