/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation;

import java.io.FileInputStream;
import java.io.InputStream;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.cs.OutOfExtentException;
import org.cts.datum.Ellipsoid;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.Geocentric2Geographic;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.UnitConversion;
import org.cts.op.transformation.GeocentricTranslation;
import org.cts.op.transformation.grids.IGNGeographicGrid;
import org.cts.units.Unit;

public class FrenchGeocentricNTF2RGF
extends AbstractCoordinateOperation {
    private static final Identifier opId = new Identifier("EPSG", "9655", "French geographic interpolation", "NTF2RGF93");
    private static final GeocentricTranslation NTF2WGS84 = new GeocentricTranslation(-168.0, -60.0, 320.0);
    private static final Geocentric2Geographic GEOC2GEOG = new Geocentric2Geographic(Ellipsoid.GRS80);
    public static final UnitConversion RAD2DD = UnitConversion.createUnitConverter(Unit.RADIAN, Unit.DEGREE);
    private IGNGeographicGrid GRID3D;
    private String gridPath;

    public FrenchGeocentricNTF2RGF(String gridPath) throws Exception {
        super(opId);
        this.precision = 0.01;
        try {
            InputStream is = FrenchGeocentricNTF2RGF.class.getClassLoader().getResourceAsStream("org/cts/op/transformation/grids/gr3df97a.txt");
            if (is == null) {
                this.gridPath = gridPath;
                this.GRID3D = new IGNGeographicGrid(new FileInputStream(gridPath + "gr3df97a.txt"), false);
            } else {
                this.gridPath = "org/cts/op/transformation/grids/";
                this.GRID3D = new IGNGeographicGrid(is, false);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + "\nThis problem occured when trying to load the gr3df97a.txt grid file, using this path : " + gridPath);
        }
    }

    public FrenchGeocentricNTF2RGF() throws Exception {
        super(opId);
        this.gridPath = "org/cts/op/transformation/grids/";
        this.precision = 0.01;
        try {
            InputStream is = FrenchGeocentricNTF2RGF.class.getClassLoader().getResourceAsStream("org/cts/op/transformation/grids/gr3df97a.txt");
            this.GRID3D = new IGNGeographicGrid(is, false);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + "\nThis problem occured when trying to load the gr3df97a.txt grid file, using this path : " + this.gridPath);
        }
    }

    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord.length < 3) {
            throw new CoordinateDimensionException(coord, 3);
        }
        double[] coordi = (double[])coord.clone();
        coordi = NTF2WGS84.transform(coordi);
        coordi = GEOC2GEOG.transform(coordi);
        double oldLon = 10.0;
        double oldLat = 10.0;
        double tx = -168.0;
        double ty = -60.0;
        double tz = 320.0;
        while (Math.max(Math.abs(oldLon - coordi[0]), Math.abs(oldLat - coordi[1])) > 1.0E-11) {
            oldLon = coordi[0];
            oldLat = coordi[1];
            coordi = RAD2DD.transform(coordi);
            try {
                double[] t = this.GRID3D.bilinearInterpolation(coordi[0], coordi[1]);
                tx = t[0];
                ty = t[1];
                tz = t[2];
            }
            catch (OutOfExtentException e) {
                throw new IllegalCoordinateException(e.getMessage());
            }
            coordi[0] = tx + coord[0];
            coordi[1] = ty + coord[1];
            coordi[2] = tz + coord[2];
            coordi = GEOC2GEOG.transform(coordi);
        }
        coord[0] = tx + coord[0];
        coord[1] = ty + coord[1];
        coord[2] = tz + coord[2];
        return coord;
    }

    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        try {
            return new FrenchGeocentricNTF2RGF(){

                public double[] transform(double[] coord) throws IllegalCoordinateException {
                    double[] coordi = (double[])coord.clone();
                    coordi = GEOC2GEOG.transform(coordi);
                    coordi = RAD2DD.transform(coordi);
                    double tx = -168.0;
                    double ty = -60.0;
                    double tz = 320.0;
                    try {
                        double[] t = FrenchGeocentricNTF2RGF.this.GRID3D.bilinearInterpolation(coordi[0], coordi[1]);
                        tx = t[0];
                        ty = t[1];
                        tz = t[2];
                    }
                    catch (OutOfExtentException e) {
                        throw new IllegalCoordinateException(e.getMessage());
                    }
                    coord[0] = -tx + coord[0];
                    coord[1] = -ty + coord[1];
                    coord[2] = -tz + coord[2];
                    return coord;
                }

                public CoordinateOperation inverse() throws NonInvertibleOperationException {
                    return FrenchGeocentricNTF2RGF.this;
                }
            };
        }
        catch (Exception e) {
            throw new NonInvertibleOperationException(e.getMessage());
        }
    }

    public String toString() {
        return "French Geocentric transformation from NTF to RGF93";
    }
}

