/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.jdbc;

import java.io.File;
import java.net.MalformedURLException;
import org.orbisgis.data.api.datasource.IDataSourceLocation;

public class DataSourceLocation
implements IDataSourceLocation {
    private final String location;

    public DataSourceLocation(String location) {
        this.location = location;
    }

    public String toString() {
        Object obj = this.asType(String.class);
        return obj != null ? obj.toString() : "No location";
    }

    public Object asType(Class<?> type) {
        switch (type.getCanonicalName()) {
            case "java.io.File": {
                return new File(this.location);
            }
            case "java.net.URL": {
                try {
                    return new File(this.location).toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            case "java.lang.String": {
                return this.location;
            }
            case "java.net.URI": {
                return new File(this.location).toURI();
            }
        }
        return null;
    }
}

