/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.jdbc;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.MetaClass;
import groovy.sql.GroovyRowResult;
import groovy.sql.Sql;
import groovy.text.SimpleTemplateEngine;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.h2.util.ScriptReader;
import org.h2gis.functions.io.utility.IOMethods;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.URIUtilities;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.orbisgis.commons.printer.Ascii;
import org.orbisgis.commons.printer.ICustomPrinter;
import org.orbisgis.data.api.dataset.IJdbcTable;
import org.orbisgis.data.api.datasource.IDataSourceLocation;
import org.orbisgis.data.api.datasource.IJdbcDataSource;
import org.orbisgis.data.api.dsl.IResultSetBuilder;
import org.orbisgis.data.jdbc.DataSourceLocation;
import org.orbisgis.data.jdbc.dsl.ResultSetBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcDataSource
extends Sql
implements IJdbcDataSource,
IResultSetBuilder {
    static final Map<String, Class> TYPE_NAME_TO_CLASS = new HashMap<String, Class>(){
        {
            this.put("GEOMETRY", Geometry.class);
            this.put("GEOGRAPHY", Geometry.class);
            this.put("POINT", Point.class);
            this.put("POINTM", Point.class);
            this.put("POINTZ", Point.class);
            this.put("POINTZM", Point.class);
            this.put("LINESTRING", LineString.class);
            this.put("LINESTRINGM", LineString.class);
            this.put("LINESTRINGZ", LineString.class);
            this.put("LINESTRINGZM", LineString.class);
            this.put("POLYGON", Polygon.class);
            this.put("POLYGONM", Polygon.class);
            this.put("POLYGONZ", Polygon.class);
            this.put("POLYGONZM", Polygon.class);
            this.put("MULTIPOINT", MultiPoint.class);
            this.put("MULTIPOINTM", MultiPoint.class);
            this.put("MULTIPOINTZ", MultiPoint.class);
            this.put("MULTIPOINTZM", MultiPoint.class);
            this.put("MULTILINESTRING", MultiLineString.class);
            this.put("MULTILINESTRINGM", MultiLineString.class);
            this.put("MULTILINESTRINGZ", MultiLineString.class);
            this.put("MULTILINESTRINGZM", MultiLineString.class);
            this.put("MULTIPOLYGON", MultiPolygon.class);
            this.put("MULTIPOLYGONM", MultiPolygon.class);
            this.put("MULTIPOLYGONZ", MultiPolygon.class);
            this.put("MULTIPOLYGONZM", MultiPolygon.class);
            this.put("GEOMETRYCOLLECTION", GeometryCollection.class);
            this.put("GEOMETRYCOLLECTIONM", GeometryCollection.class);
            this.put("BYTEA", byte[].class);
            this.put("INT2", Short.class);
            this.put("INT4", Integer.class);
            this.put("INT8", Long.class);
            this.put("INTEGER", Integer.class);
            this.put("FLOAT4", Float.class);
            this.put("FLOAT", Float.class);
            this.put("REAL", Float.class);
            this.put("DOUBLE", Double.class);
            this.put("DOUBLE PRECISION", Double.class);
            this.put("FLOAT8", Double.class);
            this.put("BOOL", Boolean.class);
            this.put("BOOLEAN", Boolean.class);
            this.put("VARCHAR", String.class);
            this.put("CHARACTER VARYING", String.class);
            this.put("DATE", Date.class);
            this.put("TIME", Time.class);
            this.put("TIMESTAMP", Timestamp.class);
            this.put("TIMESTAMPZ", Timestamp.class);
            this.put("TIMESTAMPTZ", Timestamp.class);
            this.put("TINYINT", Byte.class);
            this.put("SMALLINT", Short.class);
            this.put("BIGINT", Long.class);
        }
    };
    private IOMethods ioMethods = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcDataSource.class);
    private MetaClass metaClass;
    private final DBTypes databaseType;
    private final DataSource dataSource;

    public JdbcDataSource(Sql parent, DBTypes databaseType) {
        super(parent);
        this.dataSource = parent.getDataSource();
        this.metaClass = InvokerHelper.getMetaClass(((Object)((Object)this)).getClass());
        this.databaseType = databaseType;
        LOG.setLevel(Level.OFF);
    }

    public JdbcDataSource(DataSource dataSource, DBTypes databaseType) {
        super(dataSource);
        this.dataSource = dataSource;
        this.metaClass = InvokerHelper.getMetaClass(((Object)((Object)this)).getClass());
        this.databaseType = databaseType;
        LOG.setLevel(Level.OFF);
    }

    public JdbcDataSource(Connection connection, DBTypes databaseType) {
        super(connection);
        this.dataSource = null;
        this.metaClass = InvokerHelper.getMetaClass(((Object)((Object)this)).getClass());
        this.databaseType = databaseType;
        LOG.setLevel(Level.OFF);
    }

    public Collection<String> getTableNames(String namePattern) {
        return this.getTableNames(null, null, namePattern, (IJdbcDataSource.TableType[])null);
    }

    public Collection<String> getTableNames(String namePattern, IJdbcDataSource.TableType ... types) {
        return this.getTableNames(null, null, namePattern, types);
    }

    public Collection<String> getTableNames(String schemaPattern, String namePattern) {
        return this.getTableNames(null, schemaPattern, namePattern, (IJdbcDataSource.TableType[])null);
    }

    public Collection<String> getTableNames(String schemaPattern, String namePattern, IJdbcDataSource.TableType ... types) {
        return this.getTableNames(null, schemaPattern, namePattern, types);
    }

    public Collection<String> getTableNames(String catalogPattern, String schemaPattern, String namePattern) {
        return this.getTableNames(catalogPattern, schemaPattern, namePattern, (IJdbcDataSource.TableType[])null);
    }

    public Collection<String> getTableNames(String catalogPattern, String schemaPattern, String namePattern, IJdbcDataSource.TableType ... types) {
        String[] array = null;
        if (types != null) {
            array = (String[])Arrays.stream(types).filter(Objects::nonNull).map(Enum::toString).toArray(String[]::new);
        }
        try {
            return JDBCUtilities.getTableNames((Connection)this.getConnection(), (String)catalogPattern, (String)schemaPattern, (String)namePattern, array);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get the table names.", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public Connection getConnection(String var1, String var2) throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource.getConnection(var1, var2);
        }
        LOGGER.error("Unable to get the DataSource.\n");
        return null;
    }

    public PrintWriter getLogWriter() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource.getLogWriter();
        }
        LOGGER.error("Unable to get the DataSource.\n");
        return null;
    }

    public void setLogWriter(PrintWriter writer) throws SQLException {
        if (this.dataSource != null) {
            this.dataSource.setLogWriter(writer);
        }
        LOGGER.error("Unable to get the DataSource.\n");
    }

    public void setLoginTimeout(int time) throws SQLException {
        if (this.dataSource != null) {
            this.dataSource.setLoginTimeout(time);
        }
        LOGGER.error("Unable to get the DataSource.\n");
    }

    public int getLoginTimeout() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource.getLoginTimeout();
        }
        LOGGER.error("Unable to get the DataSource.\n");
        return -1;
    }

    public <T> T unwrap(Class<T> aClass) throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource.unwrap(aClass);
        }
        LOGGER.error("Unable to get the DataSource.\n");
        return null;
    }

    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource.isWrapperFor(aClass);
        }
        LOGGER.error("Unable to get the DataSource.\n");
        return false;
    }

    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        if (this.dataSource != null) {
            return this.dataSource.getParentLogger();
        }
        LOGGER.error("Unable to get the DataSource.\n");
        return null;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Connection getConnection() {
        Connection con = super.getConnection();
        if (con == null) {
            try {
                con = this.getDataSource().getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException("Unable to get the connection from the DataSource.\n" + e.getLocalizedMessage());
            }
        }
        return con;
    }

    public DBTypes getDataBaseType() {
        return this.databaseType;
    }

    public IResultSetBuilder forwardOnly() {
        return new ResultSetBuilder(this).forwardOnly();
    }

    public IResultSetBuilder scrollInsensitive() {
        return new ResultSetBuilder(this).scrollInsensitive();
    }

    public IResultSetBuilder scrollSensitive() {
        return new ResultSetBuilder(this).scrollSensitive();
    }

    public IResultSetBuilder readOnly() {
        return new ResultSetBuilder(this).readOnly();
    }

    public IResultSetBuilder updatable() {
        return new ResultSetBuilder(this).updatable();
    }

    public IResultSetBuilder holdCursorOverCommit() {
        return new ResultSetBuilder(this).holdCursorOverCommit();
    }

    public IResultSetBuilder closeCursorAtCommit() {
        return new ResultSetBuilder(this).closeCursorAtCommit();
    }

    public IResultSetBuilder fetchForward() {
        return new ResultSetBuilder(this).fetchForward();
    }

    public IResultSetBuilder fetchReverse() {
        return new ResultSetBuilder(this).fetchReverse();
    }

    public IResultSetBuilder fetchUnknown() {
        return new ResultSetBuilder(this).fetchUnknown();
    }

    public IResultSetBuilder fetchSize(int size) {
        return new ResultSetBuilder(this).fetchSize(size);
    }

    public IResultSetBuilder timeout(int time) {
        return new ResultSetBuilder(this).timeout(time);
    }

    public IResultSetBuilder maxRow(int maxRow) {
        return new ResultSetBuilder(this).maxRow(maxRow);
    }

    public IResultSetBuilder cursorName(String name) {
        return new ResultSetBuilder(this).cursorName(name);
    }

    public IResultSetBuilder poolable() {
        return new ResultSetBuilder(this).poolable();
    }

    public IResultSetBuilder maxFieldSize(int size) {
        return new ResultSetBuilder(this).maxFieldSize(size);
    }

    public int[] executeBatch(String[] queries) throws SQLException {
        return new ResultSetBuilder(this).executeBatch(queries);
    }

    public int[] executeBatch(GString[] queries) throws SQLException {
        return new ResultSetBuilder(this).executeBatch(queries);
    }

    public long[] executeLargeBatch(String[] queries) throws SQLException {
        return new ResultSetBuilder(this).executeLargeBatch(queries);
    }

    public long[] executeLargeBatch(GString[] queries) throws SQLException {
        return new ResultSetBuilder(this).executeLargeBatch(queries);
    }

    public long executeLargeUpdate(String sql) throws SQLException {
        return new ResultSetBuilder(this).executeLargeUpdate(sql);
    }

    public long executeLargeUpdate(GString sql) throws SQLException {
        return new ResultSetBuilder(this).executeLargeUpdate(sql);
    }

    public GroovyRowResult firstRow(GString gstring) throws SQLException {
        try {
            GroovyRowResult row = super.firstRow(gstring);
            if (!this.getConnection().getAutoCommit()) {
                super.commit();
            }
            return row;
        }
        catch (SQLException e) {
            LOGGER.debug("Unable to execute the request as a GString.", (Object)e.getLocalizedMessage());
            try {
                if (!this.getConnection().getAutoCommit()) {
                    super.rollback();
                }
            }
            catch (SQLException e2) {
                LOGGER.error("Unable to rollback.", (Object)e2.getLocalizedMessage());
            }
            GroovyRowResult row = super.firstRow(gstring.toString());
            if (!this.getConnection().getAutoCommit()) {
                super.commit();
            }
            return row;
        }
    }

    public boolean execute(GString gstring) throws SQLException {
        return this.execute(gstring.toString());
    }

    public boolean execute(String sql) throws SQLException {
        try {
            boolean b = super.execute(sql);
            if (!this.getConnection().getAutoCommit()) {
                super.commit();
            }
            return b;
        }
        catch (SQLException e) {
            try {
                if (!this.getConnection().getAutoCommit()) {
                    super.rollback();
                }
            }
            catch (SQLException e2) {
                LOGGER.error("Unable to rollback.", (Object)e2.getLocalizedMessage());
            }
            throw e;
        }
    }

    public List<GroovyRowResult> rows(GString gstring) throws SQLException {
        try {
            List rows = super.rows(gstring);
            if (!this.getConnection().getAutoCommit()) {
                super.commit();
            }
            return rows;
        }
        catch (SQLException e) {
            try {
                if (!this.getConnection().getAutoCommit()) {
                    super.rollback();
                }
            }
            catch (SQLException e2) {
                LOGGER.error("Unable to rollback.", (Object)e2.getLocalizedMessage());
            }
            List rows = super.rows(gstring.toString());
            if (!this.getConnection().getAutoCommit()) {
                super.commit();
            }
            return rows;
        }
    }

    public void eachRow(String sql, @ClosureParams(value=SimpleType.class, options={"groovy.sql.GroovyResultSet"}) Closure closure) throws SQLException {
        try {
            super.eachRow(sql, closure);
            if (!this.getConnection().getAutoCommit()) {
                super.commit();
            }
        }
        catch (SQLException e) {
            LOGGER.debug("Unable to execute the request as a String.\n" + e.getLocalizedMessage());
            try {
                if (!this.getConnection().getAutoCommit()) {
                    super.rollback();
                }
            }
            catch (SQLException e2) {
                LOGGER.error("Unable to rollback.", (Object)e2.getLocalizedMessage());
            }
            super.eachRow(sql, closure);
        }
    }

    public void eachRow(GString gstring, @ClosureParams(value=SimpleType.class, options={"java.sql.ResultSet"}) Closure closure) throws SQLException {
        try {
            super.eachRow(gstring, closure);
            if (!this.getConnection().getAutoCommit()) {
                super.commit();
            }
        }
        catch (SQLException e) {
            LOGGER.debug("Unable to execute the request as a GString.\n" + e.getLocalizedMessage());
            try {
                if (!this.getConnection().getAutoCommit()) {
                    super.rollback();
                }
            }
            catch (SQLException e2) {
                LOGGER.error("Unable to rollback.", (Object)e2.getLocalizedMessage());
            }
            super.eachRow(gstring.toString(), closure);
        }
    }

    public boolean executeScript(String fileName, Map<String, String> bindings) throws Exception {
        boolean b = false;
        try {
            File file = URIUtilities.fileFromString((String)fileName);
            if (FileUtilities.isExtensionWellFormated((File)file, (String)"sql")) {
                b = this.executeScript(new FileInputStream(file), bindings);
                if (!this.getConnection().getAutoCommit()) {
                    super.commit();
                }
                return b;
            }
        }
        catch (IOException | SQLException e) {
            try {
                if (!this.getConnection().getAutoCommit()) {
                    super.rollback();
                }
            }
            catch (SQLException e2) {
                throw new SQLException("Unable to rollback.", e2);
            }
            throw e;
        }
        return b;
    }

    public boolean executeScript(InputStream stream, Map<String, String> bindings) throws Exception {
        String commandSQL;
        SimpleTemplateEngine engine = null;
        if (bindings != null && !bindings.isEmpty()) {
            engine = new SimpleTemplateEngine();
        }
        ScriptReader scriptReader = new ScriptReader((Reader)new InputStreamReader(stream));
        scriptReader.setSkipRemarks(true);
        while ((commandSQL = scriptReader.readStatement()) != null) {
            if (commandSQL.isEmpty()) continue;
            if (engine != null) {
                try {
                    commandSQL = engine.createTemplate(commandSQL).make(bindings).toString();
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unable to create the template for the Sql command '" + commandSQL + "'.\n" + e.getLocalizedMessage());
                }
            }
            try {
                this.execute(commandSQL);
                if (this.getConnection().getAutoCommit()) continue;
                super.commit();
            }
            catch (SQLException e) {
                throw new SQLException("Unable to execute the Sql command '" + commandSQL + "'.\n" + e.getLocalizedMessage());
            }
        }
        return true;
    }

    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public boolean save(String tableName, String filePath) throws Exception {
        return this.save(tableName, filePath, null);
    }

    public boolean save(String tableName, String filePath, boolean delete) throws Exception {
        if (this.getConnection() == null) {
            throw new IllegalArgumentException("No connection, cannot save.");
        }
        if (this.ioMethods == null) {
            this.ioMethods = new IOMethods();
        }
        this.ioMethods.exportToFile(this.getConnection(), tableName, filePath, null, delete);
        return true;
    }

    public boolean save(String tableName, String filePath, String encoding) throws Exception {
        if (this.getConnection() == null) {
            throw new IllegalArgumentException("No connection, cannot save.");
        }
        if (this.ioMethods == null) {
            this.ioMethods = new IOMethods();
        }
        this.ioMethods.exportToFile(this.getConnection(), tableName, filePath, encoding, false);
        return true;
    }

    public boolean save(String tableName, URL url) throws Exception {
        return this.save(tableName, url, null);
    }

    public boolean save(String tableName, URL url, String encoding) throws Exception {
        return this.save(tableName, url.toURI(), encoding);
    }

    public boolean save(String tableName, URI uri) throws Exception {
        return this.save(tableName, uri, null);
    }

    public boolean save(String tableName, URI uri, String encoding) throws Exception {
        return this.save(tableName, new File(uri), encoding);
    }

    public boolean save(String tableName, File file) throws Exception {
        return this.save(tableName, file, null);
    }

    public boolean save(String tableName, File file, String encoding) throws Exception {
        return this.save(tableName, file.getAbsolutePath(), encoding);
    }

    private String getTableNameFromPath(String filePath) {
        String name = URIUtilities.fileFromString((String)filePath).getName();
        if (name.contains(".")) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        if (this.databaseType == DBTypes.H2GIS) {
            return name.toUpperCase();
        }
        return name.toLowerCase();
    }

    public String link(String filePath, String tableName, boolean delete) throws Exception {
        String formatedTableName = TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()).toString();
        IOMethods.linkedFile((Connection)this.getConnection(), (String)filePath, (String)tableName, (boolean)delete);
        return formatedTableName;
    }

    public String link(String filePath, String tableName) throws Exception {
        return this.link(filePath, tableName, false);
    }

    public String link(String filePath, boolean delete) throws Exception {
        String tableName = this.getTableNameFromPath(filePath);
        if (Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$").matcher(tableName).find()) {
            return this.link(filePath, tableName, delete);
        }
        throw new IllegalArgumentException("The file name contains unsupported characters");
    }

    public String link(String filePath) throws Exception {
        return this.link(filePath, false);
    }

    public String link(URL url, String tableName, boolean delete) throws Exception {
        return this.link(url.toURI(), tableName, delete);
    }

    public String link(URL url, String tableName) throws Exception {
        return this.link(url.toURI(), tableName);
    }

    public String link(URL url, boolean delete) throws Exception {
        return this.link(url.toURI(), delete);
    }

    public String link(URL url) throws Exception {
        return this.link(url.toURI());
    }

    public String link(URI uri, String tableName, boolean delete) throws Exception {
        return this.link(new File(uri), tableName, delete);
    }

    public String link(URI uri, String tableName) throws Exception {
        return this.link(new File(uri), tableName);
    }

    public String link(URI uri, boolean delete) throws Exception {
        return this.link(new File(uri), delete);
    }

    public String link(URI uri) throws Exception {
        return this.link(new File(uri));
    }

    public String link(File file, String tableName, boolean delete) throws Exception {
        return this.link(file.getAbsolutePath(), tableName, delete);
    }

    public String link(File file, String tableName) throws Exception {
        return this.link(file.getAbsolutePath(), tableName);
    }

    public String link(File file, boolean delete) throws Exception {
        return this.link(file.getAbsolutePath(), delete);
    }

    public String link(File file) throws Exception {
        return this.link(file.getAbsolutePath());
    }

    public String load(String filePath, String tableName, String encoding, boolean delete) throws Exception {
        String formatedTableName = TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()).toString();
        if (this.ioMethods == null) {
            this.ioMethods = new IOMethods();
        }
        this.ioMethods.importFile(this.getConnection(), filePath, tableName, encoding, delete);
        return formatedTableName;
    }

    public String load(String filePath, String tableName) throws Exception {
        return this.load(filePath, tableName, null, false);
    }

    public String load(String filePath, String tableName, boolean delete) throws Exception {
        return this.load(filePath, tableName, null, delete);
    }

    public String load(String filePath) throws Exception {
        return this.load(filePath, false);
    }

    public String load(String filePath, boolean delete) throws Exception {
        String tableName = this.getTableNameFromPath(filePath).replace(".", "_");
        if (Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$").matcher(tableName).find()) {
            return this.load(filePath, tableName, null, delete);
        }
        LOGGER.error("Unsupported file characters");
        return null;
    }

    public String load(URL url, String tableName) throws Exception {
        return this.load(url.toURI(), tableName, null, false);
    }

    public String load(URL url, String tableName, boolean delete) throws Exception {
        return this.load(url.toURI(), tableName, null, delete);
    }

    public String load(URL url) throws Exception {
        return this.load(url.toURI(), false);
    }

    public String load(URL url, boolean delete) throws Exception {
        return this.load(url.toURI(), delete);
    }

    public String load(URL url, String tableName, String encoding, boolean delete) throws Exception {
        return this.load(url.toURI(), tableName, encoding, delete);
    }

    public String load(URI uri, String tableName) throws Exception {
        return this.load(new File(uri), tableName, null, false);
    }

    public String load(URI uri, String tableName, boolean delete) throws Exception {
        return this.load(new File(uri), tableName, null, delete);
    }

    public String load(URI uri) throws Exception {
        return this.load(new File(uri), false);
    }

    public String load(URI uri, boolean delete) throws Exception {
        return this.load(new File(uri), delete);
    }

    public String load(URI uri, String tableName, String encoding, boolean delete) throws Exception {
        return this.load(new File(uri), tableName, encoding, delete);
    }

    public String load(File file, String tableName) throws Exception {
        return this.load(file.getAbsolutePath(), tableName, null, false);
    }

    public String load(File file, String tableName, boolean delete) throws Exception {
        return this.load(file.getAbsolutePath(), tableName, null, delete);
    }

    public String load(File file) throws Exception {
        return this.load(file.getAbsolutePath(), false);
    }

    public String load(File file, boolean delete) throws Exception {
        return this.load(file.getAbsolutePath(), delete);
    }

    public String load(File file, String tableName, String encoding, boolean delete) throws Exception {
        return this.load(file.getAbsolutePath(), tableName, encoding, delete);
    }

    public String load(IJdbcDataSource dataSource, String inputTableName, String outputTableName, boolean deleteIfExists) throws Exception {
        return this.load(dataSource, inputTableName, outputTableName, deleteIfExists, 1000);
    }

    public String load(IJdbcDataSource dataSource, String inputTableName, String outputTableName) throws Exception {
        return this.load(dataSource, inputTableName, outputTableName, false, 1000);
    }

    public String load(IJdbcDataSource dataSource, String inputTableName, boolean deleteIfExists) throws Exception {
        IOMethods.exportToDataBase((Connection)dataSource.getConnection(), (String)inputTableName, (Connection)this.getConnection(), (String)inputTableName, (int)(deleteIfExists ? -1 : 0), (int)1000);
        TableLocation targetTableLocation = TableLocation.parse((String)inputTableName, (DBTypes)this.getDataBaseType());
        return targetTableLocation.toString();
    }

    public String load(IJdbcDataSource dataSource, String inputTableName) throws Exception {
        return IOMethods.exportToDataBase((Connection)dataSource.getConnection(), (String)inputTableName, (Connection)this.getConnection(), (String)inputTableName, (int)0, (int)1000);
    }

    public String load(IJdbcDataSource dataSource, String inputTableName, String outputTableName, boolean deleteIfExists, int batchSize) throws Exception {
        return IOMethods.exportToDataBase((Connection)dataSource.getConnection(), (String)inputTableName, (Connection)this.getConnection(), (String)outputTableName, (int)(deleteIfExists ? -1 : 0), (int)1000);
    }

    public IDataSourceLocation getLocation() {
        try {
            Connection con = this.getConnection();
            if (con == null) {
                LOGGER.error("Unable to get the connection.");
                return null;
            }
            String url = con.getMetaData().getURL();
            return url == null ? null : new DataSourceLocation(url.substring(url.lastIndexOf(":") + 1));
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get the connection metadata.\n" + e.getLocalizedMessage());
            return null;
        }
    }

    public IOMethods getIoMethods() {
        if (this.ioMethods == null) {
            this.ioMethods = new IOMethods();
        }
        return this.ioMethods;
    }

    public Collection<String> getTableNames() throws Exception {
        return JDBCUtilities.getTableNames((Connection)this.getConnection(), null, null, null, null);
    }

    public IJdbcTable getDataSet(String dataSetName) throws Exception {
        return this.getTable(dataSetName);
    }

    public int call(GString gstring) throws SQLException {
        return super.call(gstring.toString());
    }

    public List<Object> getParameters(GString gString) {
        return super.getParameters(gString);
    }

    public String asSql(GString gString, List<Object> params) {
        return super.asSql(gString, params);
    }

    public void setStatementParameters(PreparedStatement preparedStatement, List<Object> params) throws SQLException {
        for (int i = 1; i <= params.size(); ++i) {
            Object param = params.get(i - 1);
            if (param instanceof Array) {
                preparedStatement.setArray(i, (Array)param);
                continue;
            }
            if (param instanceof BigDecimal) {
                preparedStatement.setBigDecimal(i, (BigDecimal)param);
                continue;
            }
            if (param instanceof Blob) {
                preparedStatement.setBlob(i, (Blob)param);
                continue;
            }
            if (param instanceof Boolean) {
                preparedStatement.setBoolean(i, (Boolean)param);
                continue;
            }
            if (param instanceof Byte) {
                preparedStatement.setByte(i, (Byte)param);
                continue;
            }
            if (param instanceof byte[]) {
                preparedStatement.setBytes(i, (byte[])param);
                continue;
            }
            if (param instanceof Clob) {
                preparedStatement.setClob(i, (Clob)param);
                continue;
            }
            if (param instanceof Date) {
                preparedStatement.setDate(i, (Date)param);
                continue;
            }
            if (param instanceof Double) {
                preparedStatement.setDouble(i, (Double)param);
                continue;
            }
            if (param instanceof Float) {
                preparedStatement.setFloat(i, ((Float)param).floatValue());
                continue;
            }
            if (param instanceof Integer) {
                preparedStatement.setInt(i, (Integer)param);
                continue;
            }
            if (param instanceof Long) {
                preparedStatement.setLong(i, (Long)param);
                continue;
            }
            if (param instanceof NClob) {
                preparedStatement.setNClob(i, (NClob)param);
                continue;
            }
            if (param instanceof Ref) {
                preparedStatement.setRef(i, (Ref)param);
                continue;
            }
            if (param instanceof Short) {
                preparedStatement.setShort(i, (Short)param);
                continue;
            }
            if (param instanceof SQLXML) {
                preparedStatement.setSQLXML(i, (SQLXML)param);
                continue;
            }
            if (param instanceof String) {
                preparedStatement.setString(i, (String)param);
                continue;
            }
            if (param instanceof Time) {
                preparedStatement.setTime(i, (Time)param);
                continue;
            }
            if (param instanceof Timestamp) {
                preparedStatement.setTimestamp(i, (Timestamp)param);
                continue;
            }
            if (param instanceof URL) {
                preparedStatement.setURL(i, (URL)param);
                continue;
            }
            preparedStatement.setObject(i, param);
        }
    }

    public JdbcDataSource autoCommit(boolean autoCommit) {
        try {
            Connection con = this.getConnection();
            if (con != null) {
                con.setAutoCommit(autoCommit);
                return this;
            }
            LOGGER.error("Unable to get the connection.");
        }
        catch (SQLException e) {
            LOGGER.error("Unable to set the auto-commit mode.\n" + e.getLocalizedMessage());
        }
        return this;
    }

    public Class<?> typeNameToClass(String typeName) {
        return TYPE_NAME_TO_CLASS.get(typeName);
    }

    public boolean createSpatialIndex(String tableName, String columnName) {
        if (columnName == null || tableName == null) {
            LOGGER.error("Unable to create a spatial index");
            return false;
        }
        try {
            return JDBCUtilities.createSpatialIndex((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()), (String)columnName);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to create a spatial index on the column '" + columnName + "' in the table '" + tableName + "'.\n" + e.getLocalizedMessage());
            return false;
        }
    }

    public boolean createSpatialIndex(String tableName) {
        if (tableName == null) {
            LOGGER.error("Unable to create a spatial index");
            return false;
        }
        try {
            TableLocation table = TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType());
            String geomColumn = (String)GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((Connection)this.getConnection(), (TableLocation)table).first();
            if (geomColumn == null || geomColumn.isEmpty()) {
                return false;
            }
            return JDBCUtilities.createSpatialIndex((Connection)this.getConnection(), (TableLocation)table, (String)geomColumn);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to create a spatial index on the table '" + tableName + "'.\n" + e.getLocalizedMessage());
            return false;
        }
    }

    public boolean createIndex(String tableName, String columnName) {
        if (columnName == null || tableName == null) {
            LOGGER.error("Unable to create an index");
            return false;
        }
        try {
            return JDBCUtilities.createIndex((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()), (String)columnName);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to create an index on the column '" + columnName + "' in the table '" + tableName + "'.\n" + e.getLocalizedMessage());
            return false;
        }
    }

    public boolean hasGeometryColumn(String tableName) {
        if (tableName == null) {
            LOGGER.error("Unable to get the table");
            return false;
        }
        try {
            return GeometryTableUtilities.hasGeometryColumn((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()));
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get the table.\n" + e.getLocalizedMessage());
            return false;
        }
    }

    public List<String> getGeometryColumns(String tableName) {
        if (tableName == null) {
            LOGGER.error("Unable to get the table");
            return null;
        }
        try {
            return GeometryTableUtilities.getGeometryColumnNames((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()));
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get the table.\n" + e.getLocalizedMessage());
            return null;
        }
    }

    public String getGeometryColumn(String tableName) {
        if (tableName == null) {
            LOGGER.error("Unable to get the table");
            return null;
        }
        try {
            return (String)GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType())).first();
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get the table.\n" + e.getLocalizedMessage());
            return null;
        }
    }

    public boolean isIndexed(String tableName, String columnName) {
        try {
            return JDBCUtilities.isIndexed((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()), (String)columnName);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to check if the column '" + columnName + "' from the table '" + tableName + "' is indexed.\n" + e.getLocalizedMessage());
            return false;
        }
    }

    public boolean isSpatialIndexed(String tableName, String columnName) throws Exception {
        return JDBCUtilities.isSpatialIndexed((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()), (String)columnName);
    }

    public boolean isSpatialIndexed(String tableName) throws Exception {
        TableLocation table = TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType());
        String geomColumn = (String)GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((Connection)this.getConnection(), (TableLocation)table).first();
        if (geomColumn == null || geomColumn.isEmpty()) {
            return false;
        }
        return JDBCUtilities.isSpatialIndexed((Connection)this.getConnection(), (String)tableName, (String)geomColumn);
    }

    public void dropIndex(String tableName, String columnName) throws Exception {
        if (columnName != null || tableName != null) {
            JDBCUtilities.dropIndex((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()), (String)columnName);
        }
    }

    public void dropTable(String ... tableName) throws Exception {
        if (tableName != null) {
            String query = Stream.of(tableName).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining(" , "));
            try {
                if (!query.isEmpty()) {
                    this.execute("DROP TABLE IF EXISTS " + query);
                }
            }
            catch (SQLException e) {
                throw new SQLException("Unable to drop the tables '" + query + "'.", e);
            }
        }
    }

    public void dropTable(List<String> tableNames) throws Exception {
        if (tableNames != null) {
            String query = tableNames.stream().filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining(","));
            try {
                if (!query.isEmpty()) {
                    this.execute("DROP TABLE IF EXISTS " + query);
                }
            }
            catch (SQLException e) {
                throw new SQLException("Unable to drop the tables '" + query + "'.", e);
            }
        }
    }

    public boolean setSrid(String tableName, String columnName, int srid) throws Exception {
        return GeometryTableUtilities.alterSRID((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()), (String)columnName, (int)srid);
    }

    public int getSrid(String tableName) throws Exception {
        if (tableName == null) {
            throw new IllegalArgumentException("Unable to get the srid");
        }
        return GeometryTableUtilities.getSRID((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()));
    }

    public int getSrid(String tableName, String columnName) throws Exception {
        if (tableName == null) {
            throw new IllegalArgumentException("Unable to get the srid");
        }
        return GeometryTableUtilities.getSRID((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType()), (String)columnName);
    }

    public boolean setSrid(String tableName, int srid) throws Exception {
        String geomColumn = (String)GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((Connection)this.getConnection(), (TableLocation)TableLocation.parse((String)tableName, (DBTypes)this.getDataBaseType())).first();
        if (geomColumn == null || geomColumn.isEmpty()) {
            throw new IllegalArgumentException("Unable to get the srid");
        }
        return GeometryTableUtilities.alterSRID((Connection)this.getConnection(), (String)tableName, (String)geomColumn, (int)srid);
    }

    public boolean isEmpty(String tableName) throws Exception {
        try {
            GroovyRowResult row = this.firstRow("SELECT * FROM " + tableName + " LIMIT 1 ");
            if (row == null) {
                return true;
            }
            return row.isEmpty();
        }
        catch (SQLException e) {
            throw new SQLException("Unable to check if the table is empty.", e);
        }
    }

    public void print(String tableName) throws Exception {
        this.print(tableName, 1000);
    }

    public void print(String tableName, int numberOfRows) throws Exception {
        Connection con;
        if (tableName == null || tableName.isEmpty()) {
            System.out.println("The table name is null or empty.");
        }
        if ((con = this.getConnection()) == null) {
            System.out.println("Unable to get the connection to the database");
        }
        try (Statement statement = con.createStatement();){
            ResultSet rs = statement.executeQuery("SELECT * FROM " + tableName + " as foo");
            StringBuilder builder = new StringBuilder();
            Ascii printer = new Ascii(builder);
            List columnNames = JDBCUtilities.getColumnNames((ResultSetMetaData)rs.getMetaData());
            if (columnNames == null) {
                printer.endTable();
                System.out.print(printer);
                return;
            }
            printer.startTable(20, columnNames.size());
            printer.appendTableTitle((Object)tableName);
            printer.appendTableLineSeparator();
            for (String column : columnNames) {
                printer.appendTableHeaderValue((Object)column, ICustomPrinter.CellPosition.CENTER);
            }
            printer.appendTableLineSeparator();
            boolean tooManyRows = false;
            if (rs != null) {
                try {
                    int count = 0;
                    while (rs.next()) {
                        if (count > numberOfRows) {
                            tooManyRows = true;
                            break;
                        }
                        for (String column : columnNames) {
                            Object obj = rs.getObject(column);
                            if (obj instanceof Number) {
                                printer.appendTableValue(rs.getObject(column), ICustomPrinter.CellPosition.RIGHT);
                                continue;
                            }
                            printer.appendTableValue(rs.getObject(column), ICustomPrinter.CellPosition.LEFT);
                        }
                        ++count;
                    }
                }
                catch (Exception e) {
                    throw new SQLException("Error while reading the table '" + tableName + "'.\n" + e.getLocalizedMessage());
                }
            }
            if (tooManyRows && numberOfRows > 1) {
                printer.appendText("Note that the table contains more than " + numberOfRows + " rows");
            } else {
                printer.appendTableLineSeparator();
            }
            printer.endTable();
            System.out.println(printer);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getColumnNamesTypes(String location) throws Exception {
        HashMap<String, String> fieldNameList = new HashMap<String, String>();
        try (Statement statement = this.getConnection().createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM " + location + " LIMIT 0;");){
            ResultSetMetaData metadata = resultSet.getMetaData();
            int columnCount = metadata.getColumnCount();
            for (int columnId = 1; columnId <= columnCount; ++columnId) {
                fieldNameList.put(metadata.getColumnName(columnId), metadata.getColumnTypeName(columnId));
            }
        }
        return fieldNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class> getColumnNamesClasses(String location) throws Exception {
        HashMap<String, Class> columnsWithClass = new HashMap<String, Class>();
        Connection con = this.getConnection();
        try (Statement statement = con.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM " + location + " LIMIT 0;");){
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int columnId = 1; columnId <= columnCount; ++columnId) {
                String columnName = metaData.getColumnName(columnId);
                String type = metaData.getColumnTypeName(columnId);
                if (type.toLowerCase().startsWith("geometry")) {
                    columnsWithClass.put(columnName, this.typeNameToClass(GeometryTableUtilities.getMetaData((Connection)con, (String)location, (String)TableLocation.capsIdentifier((String)columnName, (DBTypes)this.getDataBaseType())).getGeometryType()));
                    continue;
                }
                columnsWithClass.put(columnName, this.typeNameToClass(type));
            }
        }
        return columnsWithClass;
    }
}

