/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.SpatialResultSet;
import org.h2gis.utilities.SpatialResultSetMetaData;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.Tuple;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.locationtech.jts.geom.Geometry;
import org.orbisgis.data.api.dataset.IJdbcSpatialTable;
import org.orbisgis.data.api.dataset.IRaster;
import org.orbisgis.data.api.datasource.IJdbcDataSource;
import org.orbisgis.data.jdbc.JdbcTable;
import org.orbisgis.data.jdbc.ResultSetIterator;
import org.orbisgis.data.jdbc.resultset.ResultSetSpliterator;
import org.orbisgis.data.jdbc.resultset.StreamSpatialResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcSpatialTable
extends JdbcTable<StreamSpatialResultSet>
implements IJdbcSpatialTable<StreamSpatialResultSet> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcTable.class);

    public JdbcSpatialTable(DBTypes dataBaseType, IJdbcDataSource jdbcDataSource, TableLocation tableLocation, Statement statement, String baseQuery, List<Object> params) {
        super(dataBaseType, jdbcDataSource, tableLocation, statement, params, baseQuery);
    }

    @Override
    public boolean isSpatial() {
        return true;
    }

    public Geometry getGeometry(int columnIndex) throws Exception {
        SpatialResultSet rs = (SpatialResultSet)this.getResultSet();
        if (rs != null) {
            return rs.getGeometry(columnIndex);
        }
        throw new SQLException("Cannot find any geometry on column index " + columnIndex);
    }

    public Geometry getGeometry(String columnLabel) throws Exception {
        SpatialResultSet rs = (SpatialResultSet)this.getResultSet();
        if (rs != null) {
            return rs.getGeometry(columnLabel);
        }
        throw new SQLException("Cannot find any geometry on column name " + columnLabel);
    }

    public Geometry getGeometry() throws Exception {
        SpatialResultSet rs = (SpatialResultSet)this.getResultSet();
        if (rs != null) {
            return rs.getGeometry();
        }
        throw new SQLException("Cannot read the data");
    }

    public IRaster getRaster(int columnIndex) throws Exception {
        throw new UnsupportedOperationException();
    }

    public IRaster getRaster(String columnLabel) throws Exception {
        throw new UnsupportedOperationException();
    }

    public IRaster getRaster() throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<String> getSpatialColumns() throws Exception {
        ArrayList<String> list = new ArrayList<String>(this.getRasterColumns());
        List<String> geometric = this.getGeometricColumns();
        if (geometric != null) {
            list.addAll(geometric);
        }
        return list;
    }

    public List<String> getRasterColumns() throws Exception {
        return new ArrayList<String>();
    }

    public List<String> getGeometricColumns() throws Exception {
        block7: {
            if (this.getTableLocation() == null) {
                try {
                    ResultSet rs = this.getResultSet();
                    if (rs != null) {
                        return GeometryTableUtilities.getGeometryColumnNames((ResultSetMetaData)rs.getMetaData());
                    }
                    break block7;
                }
                catch (SQLException e) {
                    LOGGER.error("Unable to get the geometric columns on ResultSet.", (Throwable)e);
                    return null;
                }
            }
            Connection con = this.getJdbcDataSource().getConnection();
            if (con == null) {
                throw new SQLException("Cannot get the connection to the database");
            }
            try {
                return GeometryTableUtilities.getGeometryColumnNames((Connection)con, (TableLocation)this.getTableLocation());
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    public Geometry getExtent(String[] geometryColumns, String filter) throws Exception {
        if (this.getTableLocation() == null) {
            Connection con = this.getJdbcDataSource().getConnection();
            if (con == null) {
                throw new SQLException("Cannot get the connection to the database");
            }
            return GeometryTableUtilities.getEnvelope((Connection)con, (String)this.getBaseQuery(), (String[])geometryColumns, (String)filter);
        }
        Connection con = this.getJdbcDataSource().getConnection();
        if (con == null) {
            throw new SQLException("Cannot get the connection to the database");
        }
        return GeometryTableUtilities.getEnvelope((Connection)con, (TableLocation)this.getTableLocation(), (String[])geometryColumns, (String)filter);
    }

    public Geometry getExtent(String ... geometryColumns) throws Exception {
        if (this.getTableLocation() == null) {
            Connection con = this.getJdbcDataSource().getConnection();
            if (con == null) {
                throw new SQLException("Cannot get the connection to the database");
            }
            try {
                return GeometryTableUtilities.getEnvelope((Connection)con, (String)this.getBaseQuery(), (String[])geometryColumns);
            }
            catch (SQLException e) {
                return null;
            }
        }
        Connection con = this.getJdbcDataSource().getConnection();
        if (con == null) {
            throw new SQLException("Cannot get the connection to the database");
        }
        return GeometryTableUtilities.getEnvelope((Connection)con, (TableLocation)this.getTableLocation(), (String[])geometryColumns);
    }

    public Geometry getExtent() throws Exception {
        if (this.getTableLocation() == null) {
            Connection con = this.getJdbcDataSource().getConnection();
            if (con == null) {
                throw new SQLException("Cannot get the connection to the database");
            }
            ResultSet rs0 = this.getResultSet();
            if (rs0 == null) {
                throw new SQLException("Cannot read the data");
            }
            Tuple geomMeta = null;
            TableLocation tableLocation = this.getTableLocation();
            geomMeta = tableLocation == null ? GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((ResultSetMetaData)rs0.getMetaData()) : GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((Connection)con, (TableLocation)tableLocation);
            if (geomMeta == null) {
                return null;
            }
            return GeometryTableUtilities.getEnvelope((ResultSet)rs0, (String)((String)geomMeta.first()));
        }
        Connection con = this.getJdbcDataSource().getConnection();
        if (con == null) {
            throw new SQLException("Cannot get the connection to the database");
        }
        Tuple geomMeta = GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((Connection)con, (TableLocation)this.getTableLocation());
        return GeometryTableUtilities.getEnvelope((Connection)con, (TableLocation)this.getTableLocation(), (String)((String)geomMeta.first()));
    }

    public Geometry getEstimatedExtent() throws Exception {
        if (this.getTableLocation() == null) {
            throw new UnsupportedOperationException();
        }
        Connection con = this.getJdbcDataSource().getConnection();
        if (con == null) {
            throw new SQLException("Cannot get the connection to the database");
        }
        Tuple geomMeta = GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((Connection)con, (TableLocation)this.getTableLocation());
        return GeometryTableUtilities.getEstimatedExtent((Connection)con, (TableLocation)this.getTableLocation(), (String)((String)geomMeta.first()));
    }

    public void setSrid(int srid) throws Exception {
        List<String> geomColumns = this.getGeometricColumns();
        if (this.getTableLocation() == null || geomColumns.isEmpty()) {
            throw new IllegalArgumentException("Invalid table");
        }
        Connection con = this.getJdbcDataSource().getConnection();
        if (con == null) {
            throw new SQLException("Cannot get the connection to the database");
        }
        String geomColumn = this.getGeometricColumns().get(0);
        String type = this.getColumnType(geomColumn);
        con.createStatement().execute("ALTER TABLE " + this.getLocation() + " ALTER COLUMN " + geomColumn + " TYPE geometry(" + type + ", " + srid + ") USING ST_SetSRID(" + geomColumn + "," + srid + ");");
    }

    public Map<String, String> getGeometryTypes() throws Exception {
        if (this.getTableLocation() == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                throw new SQLException("Cannot read the data");
            }
            try {
                GeometryTableUtilities.getMetaData((ResultSet)this.getResultSet()).forEach((? super K key, ? super V value) -> map.put((String)key, value.getGeometryType()));
                return map;
            }
            catch (SQLException e) {
                return null;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Connection con = this.getJdbcDataSource().getConnection();
        if (con == null) {
            throw new SQLException("Cannot get the connection to the database");
        }
        try {
            GeometryTableUtilities.getMetaData((Connection)con, (TableLocation)this.getTableLocation()).forEach((? super K s, ? super V meta) -> map.put((String)s, meta.getGeometryType()));
            return map;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public SpatialResultSetMetaData getMetaData() throws SQLException {
        ResultSet rs = this.getResultSet();
        return rs.getMetaData().unwrap(SpatialResultSetMetaData.class);
    }

    public Iterator<StreamSpatialResultSet> iterator() {
        return new ResultSetIterator<JdbcSpatialTable>(this);
    }

    public Stream<StreamSpatialResultSet> stream() throws Exception {
        ResultSetSpliterator<StreamSpatialResultSet> spliterator = new ResultSetSpliterator<StreamSpatialResultSet>(this.getRowCount(), new StreamSpatialResultSet((SpatialResultSet)this.getResultSet()));
        return StreamSupport.stream(spliterator, true);
    }
}

