/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.jdbc;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.h2gis.functions.io.utility.IOMethods;
import org.h2gis.utilities.GeometryMetaData;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.orbisgis.commons.printer.Ascii;
import org.orbisgis.commons.printer.Html;
import org.orbisgis.commons.printer.ICustomPrinter;
import org.orbisgis.data.api.dataset.IJdbcSpatialTable;
import org.orbisgis.data.api.dataset.IJdbcTable;
import org.orbisgis.data.api.dataset.IStreamResultSet;
import org.orbisgis.data.api.dataset.IStreamSpatialResultSet;
import org.orbisgis.data.api.dataset.ITable;
import org.orbisgis.data.api.datasource.IJdbcDataSource;
import org.orbisgis.data.api.dsl.IBuilderResult;
import org.orbisgis.data.api.dsl.IFilterBuilder;
import org.orbisgis.data.api.dsl.IResultSetProperties;
import org.orbisgis.data.jdbc.JdbcTableSummary;
import org.orbisgis.data.jdbc.dsl.QueryBuilder;
import org.orbisgis.data.jdbc.dsl.ResultSetProperties;
import org.orbisgis.data.jdbc.resultset.DefaultResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcTable<T extends ResultSet>
extends DefaultResultSet
implements IJdbcTable<T>,
GroovyObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcTable.class);
    private IOMethods ioMethods = null;
    private static final int ASCII_COLUMN_WIDTH = 20;
    private MetaClass metaClass = InvokerHelper.getMetaClass(this.getClass());
    private final DBTypes dataBaseType;
    private final IJdbcDataSource jdbcDataSource;
    private final TableLocation tableLocation;
    private final Statement statement;
    private final List<Object> params;
    private final String baseQuery;
    protected ResultSet resultSet;
    private IResultSetProperties rsp;

    public JdbcTable(DBTypes dataBaseType, IJdbcDataSource jdbcDataSource, TableLocation tableLocation, Statement statement, List<Object> params, String baseQuery) {
        this.dataBaseType = dataBaseType;
        this.jdbcDataSource = jdbcDataSource;
        this.tableLocation = tableLocation;
        this.statement = statement;
        this.params = params;
        this.baseQuery = baseQuery;
        this.rsp = new ResultSetProperties();
    }

    public String getBaseQuery() {
        return this.baseQuery;
    }

    public boolean reload() throws SQLException {
        this.resultSet = null;
        return this.getResultSet() != null;
    }

    @Override
    protected ResultSet getResultSet() throws SQLException {
        if (this.resultSet == null) {
            Statement st = this.getStatement();
            this.resultSet = st instanceof PreparedStatement ? ((PreparedStatement)st).executeQuery() : this.getStatement().executeQuery(this.getBaseQuery());
        }
        return this.resultSet;
    }

    protected ResultSet getResultSetLimit(int limit) throws SQLException {
        ResultSet resultSet;
        if (this.getBaseQuery().contains(" LIMIT ")) {
            resultSet = this.getResultSet();
        } else {
            Connection con = this.jdbcDataSource.getConnection();
            resultSet = con.createStatement().executeQuery("SELECT * FROM (" + this.getBaseQuery() + ") AS FOO LIMIT " + limit);
        }
        return resultSet;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet rs = this.getResultSet();
        return rs.getMetaData();
    }

    public IJdbcDataSource getJdbcDataSource() {
        return this.jdbcDataSource;
    }

    public TableLocation getTableLocation() {
        return this.tableLocation;
    }

    public DBTypes getDbType() {
        return this.dataBaseType;
    }

    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public boolean isSpatial() {
        return false;
    }

    public boolean isLinked() {
        if (this.getTableLocation() != null) {
            try {
                Connection con = this.jdbcDataSource.getConnection();
                if (con == null) {
                    LOGGER.error("Unable to get the connection.");
                    return false;
                }
                return JDBCUtilities.isLinkedTable((Connection)con, (String)this.getTableLocation().toString());
            }
            catch (SQLException e) {
                LOGGER.error("Unable to get the type of the table '" + this.getTableLocation().getTable() + ".\n" + e.getLocalizedMessage());
            }
        }
        return false;
    }

    public boolean isTemporary() {
        if (this.getTableLocation() != null) {
            try {
                Connection con = this.jdbcDataSource.getConnection();
                if (con == null) {
                    LOGGER.error("Unable to get the connection.");
                    return false;
                }
                return JDBCUtilities.isTemporaryTable((Connection)con, (TableLocation)this.getTableLocation());
            }
            catch (SQLException e) {
                LOGGER.error("Unable to get the type of the table '" + this.getTableLocation().getTable() + ".\n" + e.getLocalizedMessage());
            }
        }
        return false;
    }

    public Collection<String> getColumnNames() throws Exception {
        Connection con = this.jdbcDataSource.getConnection();
        if (this.tableLocation == null) {
            try {
                ResultSet rs = this.getResultSetLimit(0);
                return JDBCUtilities.getColumnNames((ResultSetMetaData)rs.getMetaData()).stream().map(this::formatColumnName).collect(Collectors.toCollection(ArrayList::new));
            }
            catch (SQLException e) {
                throw new SQLException("Unable to get the collection of columns names", e);
            }
        }
        try {
            return JDBCUtilities.getColumnNames((Connection)con, (TableLocation)this.tableLocation);
        }
        catch (SQLException e) {
            throw new SQLException("Unable to get the column names of the table " + this.tableLocation + ".", e);
        }
    }

    public Map<String, String> getColumnNamesTypes() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            ResultSet rs = this.getResultSetLimit(0);
            ResultSetMetaData metaData = rs.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                map.put(metaData.getColumnName(i), metaData.getColumnTypeName(i));
            }
        }
        catch (SQLException e) {
            throw new SQLException("Unable to get the column types", e);
        }
        return map;
    }

    public String getColumnType(String columnName) throws SQLException {
        try {
            ResultSet rs = this.getResultSetLimit(0);
            ResultSetMetaData metaData = rs.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                if (!columnName.equalsIgnoreCase(metaData.getColumnName(i))) continue;
                String type = metaData.getColumnTypeName(i);
                if (type.toLowerCase().startsWith("geometry")) {
                    if (this.dataBaseType == DBTypes.H2 || this.dataBaseType == DBTypes.H2GIS) {
                        return GeometryMetaData.getMetaDataFromTablePattern((String)type).getGeometryType();
                    }
                    if (this.tableLocation != null && !this.getName().isEmpty()) {
                        return GeometryTableUtilities.getMetaData((Connection)this.jdbcDataSource.getConnection(), (TableLocation)this.tableLocation, (String)TableLocation.capsIdentifier((String)columnName, (DBTypes)this.dataBaseType)).getGeometryType();
                    }
                }
                return type;
            }
        }
        catch (SQLException e) {
            throw new SQLException("Cannot get the type of the column.", e);
        }
        return null;
    }

    private String getGeometricType(String columnName) {
        if (this.tableLocation != null && !this.getName().isEmpty()) {
            try {
                Connection con = this.jdbcDataSource.getConnection();
                return GeometryTableUtilities.getMetaData((Connection)con, (TableLocation)this.tableLocation, (String)TableLocation.capsIdentifier((String)columnName, (DBTypes)this.dataBaseType)).getGeometryType();
            }
            catch (SQLException e) {
                LOGGER.error("Unable to get the geometric type of the column '" + columnName + "'\n" + e.getLocalizedMessage());
            }
        } else {
            try {
                ResultSet rs = this.getResultSet();
                if (rs == null) {
                    LOGGER.error("Unable to get the resultset.");
                    return null;
                }
                LinkedHashMap map = GeometryTableUtilities.getMetaData((ResultSet)rs);
                if (!map.containsKey(columnName)) {
                    LOGGER.error("Unable to get data from the column '" + columnName + "'.");
                    return null;
                }
                return ((GeometryMetaData)map.get(columnName)).getGeometryType();
            }
            catch (SQLException e) {
                LOGGER.error("Unable to get data from the resultset.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public int getColumnCount() throws SQLException {
        ResultSet rs = this.getResultSet();
        ResultSetMetaData metaData = rs.getMetaData();
        return metaData.getColumnCount();
    }

    public int getRowCount() throws SQLException {
        Connection con = this.jdbcDataSource.getConnection();
        Object query = "";
        query = this.tableLocation == null ? (this.getBaseQuery().startsWith("(") && this.getBaseQuery().endsWith(")") ? "SELECT COUNT(*) FROM " + this.getBaseQuery() + "AS FOO" : "SELECT COUNT(*) FROM (" + this.getBaseQuery() + ") AS FOO") : "SELECT count(*) FROM " + this.tableLocation.toString(this.getDbType());
        try {
            ResultSet rowCountRs = con.createStatement().executeQuery((String)query);
            rowCountRs.next();
            int c = rowCountRs.getInt(1);
            if (!con.getAutoCommit()) {
                con.commit();
            }
            return c;
        }
        catch (SQLException e) {
            try {
                if (!con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (SQLException e1) {
                LOGGER.error("Unable to rollback.", (Throwable)e1);
            }
            throw e;
        }
    }

    public Collection<String> getUniqueValues(String column) throws Exception {
        if (this.tableLocation == null) {
            throw new IllegalArgumentException("Cannot get data on null or empty table");
        }
        if (this.tableLocation.getTable().isEmpty()) {
            throw new IllegalArgumentException("Cannot get data on null or empty table");
        }
        try {
            Connection con = this.jdbcDataSource.getConnection();
            if (con == null) {
                throw new SQLException("Cannot get the connection to the database");
            }
            TableLocation loc = this.getTableLocation();
            if (loc == null) {
                throw new IllegalArgumentException("Cannot get data on null or empty table");
            }
            return JDBCUtilities.getUniqueFieldValues((Connection)con, (String)loc.toString(this.getDbType()), (String)column);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to request unique values fo the column '" + column + "'.\n", (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> firstRow() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.isEmpty()) {
            return map;
        }
        ResultSet rs = this.getResultSetLimit(1);
        rs.next();
        Collection<String> columns = this.getColumnNames();
        for (String column : columns) {
            try {
                map.put(column, rs.getObject(column));
            }
            catch (SQLException e) {
                throw new SQLException("Unable to get data from first row.", e);
            }
        }
        return map;
    }

    public String save(String filePath, boolean deleteFile) throws Exception {
        String toSave = this.getTableLocation() == null ? "(" + this.getBaseQuery() + ")" : this.getTableLocation().toString(this.getDbType());
        try {
            if (this.ioMethods == null) {
                this.ioMethods = new IOMethods();
            }
            this.ioMethods.exportToFile(this.getJdbcDataSource().getConnection(), toSave, filePath, null, deleteFile);
            return filePath;
        }
        catch (SQLException e) {
            throw new SQLException("Cannot save the file : " + filePath);
        }
    }

    public String save(String filePath, String encoding) throws Exception {
        String toSave = this.getTableLocation() == null ? "(" + this.getBaseQuery() + ")" : this.getTableLocation().toString(this.getDbType());
        try {
            if (this.ioMethods == null) {
                this.ioMethods = new IOMethods();
            }
            this.ioMethods.exportToFile(this.getJdbcDataSource().getConnection(), toSave, filePath, encoding, false);
            return filePath;
        }
        catch (SQLException e) {
            throw new SQLException("Cannot save the file : " + filePath, e);
        }
    }

    public String save(IJdbcDataSource dataSource, boolean deleteTable) throws Exception {
        return this.save(dataSource, deleteTable, 1000);
    }

    public String save(IJdbcDataSource dataSource, String outputTableName, boolean deleteTable) throws Exception {
        return this.save(dataSource, outputTableName, deleteTable, 1000);
    }

    public String save(IJdbcDataSource dataSource, int batchSize) throws Exception {
        return this.save(dataSource, false, batchSize);
    }

    public String save(IJdbcDataSource dataSource, String outputTableName, boolean deleteTable, int batchSize) throws Exception {
        if (dataSource == null) {
            throw new SQLException("Cannot get the connection to the database");
        }
        String inputTableName = this.getTableLocation() == null ? "(" + this.getBaseQuery() + ")" : this.getTableLocation().toString(this.getDbType());
        try {
            return IOMethods.exportToDataBase((Connection)this.getJdbcDataSource().getConnection(), (String)inputTableName, (Connection)dataSource.getConnection(), (String)outputTableName, (int)(deleteTable ? -1 : 0), (int)batchSize);
        }
        catch (SQLException e) {
            throw new SQLException("Unable to save the table " + inputTableName + " to " + dataSource.getLocation().toString());
        }
    }

    public String save(IJdbcDataSource dataSource, boolean deleteTable, int batchSize) throws Exception {
        if (dataSource == null) {
            throw new SQLException("Cannot get the connection to the database");
        }
        String inputTableName = this.getTableLocation() == null ? "(" + this.getBaseQuery() + ")" : this.getTableLocation().toString(this.getDbType());
        return IOMethods.exportToDataBase((Connection)this.getJdbcDataSource().getConnection(), (String)inputTableName, (Connection)dataSource.getConnection(), (String)inputTableName, (int)(deleteTable ? -1 : 0), (int)batchSize);
    }

    private String getQuery() {
        return this.baseQuery.trim();
    }

    protected String getQuery(String ... columns) {
        TableLocation loc = this.getTableLocation();
        if (loc == null) {
            return null;
        }
        return "SELECT " + String.join((CharSequence)", ", columns) + " FROM " + this.getTableLocation().getTable().toUpperCase();
    }

    public IBuilderResult filter(String filter) {
        String loc = this.getTableLocation() != null ? this.getTableLocation().toString(this.getDbType()) : this.getBaseQuery();
        QueryBuilder builder = new QueryBuilder(this.getJdbcDataSource(), loc, this.getResultSetProperties());
        return builder.filter(filter);
    }

    public IBuilderResult filter(GString filter) {
        String loc = this.getTableLocation() != null ? this.getTableLocation().toString(this.getDbType()) : this.getBaseQuery();
        QueryBuilder builder = new QueryBuilder(this.getJdbcDataSource(), loc, this.getResultSetProperties());
        return builder.filter(filter);
    }

    public IBuilderResult filter(String filter, List<Object> params) {
        String loc = this.getTableLocation() != null ? this.getTableLocation().toString(this.getDbType()) : this.getBaseQuery();
        QueryBuilder builder = new QueryBuilder(this.getJdbcDataSource(), loc, this.getResultSetProperties());
        return builder.filter(filter, params);
    }

    public IFilterBuilder columns(String ... columns) {
        String loc = this.getTableLocation() != null ? this.getTableLocation().toString(this.getDbType()) : this.getBaseQuery();
        QueryBuilder builder = new QueryBuilder(this.getJdbcDataSource(), loc, this.getResultSetProperties());
        return builder.columns(columns);
    }

    public IJdbcTable<? extends IStreamResultSet> getTable() throws Exception {
        return (IJdbcTable)this.asType(IJdbcTable.class);
    }

    public IJdbcSpatialTable<IStreamSpatialResultSet> getSpatialTable() throws Exception {
        if (this.isSpatial()) {
            return (IJdbcSpatialTable)this.asType(IJdbcSpatialTable.class);
        }
        return null;
    }

    public List<Object> getFirstRow() throws Exception {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            try {
                if (rs.isBeforeFirst() && !rs.next()) {
                    throw new SQLException("Unable go to the first row.");
                }
                if (!rs.isFirst() && !rs.first()) {
                    throw new SQLException("Unable go to the first row.");
                }
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 1; i <= this.getColumnCount(); ++i) {
                    list.add(rs.getObject(i));
                }
                return list;
            }
            catch (SQLException e) {
                throw new SQLException("Unable to query the first row of the table.", e);
            }
        }
        throw new SQLException("Unable to query the first row of the table.");
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    public Object asType(Class<?> clazz) throws Exception {
        if (ICustomPrinter.class.isAssignableFrom(clazz)) {
            Ascii printer;
            StringBuilder builder = new StringBuilder();
            if (clazz == Ascii.class) {
                printer = new Ascii(builder);
            } else if (clazz == Html.class) {
                printer = new Html(builder);
            } else {
                return this;
            }
            Collection<String> columnNames = this.getColumnNames();
            if (columnNames == null) {
                printer.endTable();
                return printer;
            }
            printer.startTable(20, columnNames.size());
            printer.appendTableTitle((Object)this.getName());
            printer.appendTableLineSeparator();
            for (String column : columnNames) {
                printer.appendTableHeaderValue((Object)column, ICustomPrinter.CellPosition.CENTER);
            }
            printer.appendTableLineSeparator();
            ResultSet rs = this.getResultSet();
            if (rs != null) {
                while (rs.next()) {
                    for (String column : columnNames) {
                        Object obj = rs.getObject(column);
                        if (obj instanceof Number) {
                            printer.appendTableValue(rs.getObject(column), ICustomPrinter.CellPosition.RIGHT);
                            continue;
                        }
                        printer.appendTableValue(rs.getObject(column), ICustomPrinter.CellPosition.LEFT);
                    }
                }
            }
            printer.appendTableLineSeparator();
            printer.endTable();
            return printer;
        }
        if (ITable.class.isAssignableFrom(clazz)) {
            return this;
        }
        return null;
    }

    private String formatColumnName(String column) {
        return this.getDbType() == DBTypes.H2GIS ? column.toUpperCase() : column.toLowerCase();
    }

    public JdbcTableSummary getSummary() throws Exception {
        return new JdbcTableSummary(this.getTableLocation(), this.getColumnCount(), this.getRowCount());
    }

    public List<Object> getParams() {
        return this.params;
    }

    public void setResultSetProperties(IResultSetProperties properties) {
        if (properties != null) {
            this.rsp = properties.copy();
        }
    }

    public IResultSetProperties getResultSetProperties() {
        return this.rsp;
    }

    public void eachRow(Closure<Object> closure) {
        this.forEach(arg_0 -> closure.call(arg_0));
        Connection con = null;
        try {
            con = this.getJdbcDataSource().getConnection();
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get connection.", (Throwable)e);
        }
        try {
            if (!con.getAutoCommit()) {
                con.commit();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Unable to commit each row action.", (Throwable)e);
            try {
                con.rollback();
            }
            catch (SQLException e2) {
                LOGGER.error("Unable to rollback.", (Throwable)e2);
            }
        }
    }

    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        Iterator var2 = this.iterator();
        while (var2.hasNext()) {
            ResultSet t = (ResultSet)var2.next();
            action.accept(t);
        }
    }

    public boolean isEmpty() throws Exception {
        Connection con = this.jdbcDataSource.getConnection();
        Object query = "";
        query = this.tableLocation == null ? "SELECT 1 FROM (" + this.getBaseQuery() + ") AS FOO LIMIT 1" : "SELECT 1 FROM " + this.tableLocation.toString(this.getDbType()) + " LIMIT 1";
        try {
            ResultSet rowQuery = con.createStatement().executeQuery((String)query);
            return !rowQuery.next();
        }
        catch (SQLException e) {
            try {
                if (con != null && !con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (SQLException e1) {
                throw new SQLException("Unable to rollback.", e1);
            }
            throw new SQLException("Unable to read the table.", e);
        }
    }

    public Object get(int column) throws Exception {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getObject(column);
        }
        throw new SQLException("Cannot get the value");
    }

    public Object get(String column) throws Exception {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getObject(column);
        }
        throw new SQLException("Cannot get the value");
    }
}

