/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetIterator<T extends ResultSet>
implements Iterator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetIterator.class);
    private final T resultSet;
    private boolean nextDone = false;

    public ResultSetIterator(T resultSet) {
        this.resultSet = resultSet;
        if (this.resultSet == null) {
            LOGGER.warn("There is no ResultSet so there will no data.");
        }
    }

    @Override
    public boolean hasNext() {
        try {
            this.nextDone = true;
            return this.resultSet != null && this.resultSet.next();
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get next row.\n", (Throwable)e);
            this.nextDone = false;
            return false;
        }
    }

    @Override
    public T next() {
        if (!this.nextDone && !this.hasNext()) {
            return null;
        }
        return this.resultSet;
    }
}

