/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.jdbc.dsl;

import groovy.lang.Closure;
import org.orbisgis.commons.printer.ICustomPrinter;
import org.orbisgis.data.api.dataset.ISpatialTable;
import org.orbisgis.data.api.dataset.ITable;
import org.orbisgis.data.api.datasource.IJdbcDataSource;
import org.orbisgis.data.api.dsl.IBuilderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BuilderResult
implements IBuilderResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuilderResult.class);

    protected abstract IJdbcDataSource getDataSource();

    protected abstract String getQuery();

    public void eachRow(Closure<Object> closure) throws Exception {
        ISpatialTable table = (ISpatialTable)this.asType(ISpatialTable.class);
        if (table != null) {
            table.eachRow(closure);
        }
    }

    public Object asType(Class<?> clazz) throws Exception {
        ITable table;
        if (ICustomPrinter.class.isAssignableFrom(clazz) && (table = this.getTable()) != null) {
            return table.asType(clazz);
        }
        if (ISpatialTable.class.isAssignableFrom(clazz)) {
            return this.getSpatialTable();
        }
        if (ITable.class.isAssignableFrom(clazz)) {
            return this.getTable();
        }
        return null;
    }

    public String toString() {
        return "(" + this.getQuery() + ") as foo";
    }

    public ITable getTable() throws Exception {
        return this.getDataSource().getTable(this.toString(), this.getParams());
    }

    public ISpatialTable getSpatialTable() throws Exception {
        return this.getDataSource().getSpatialTable(this.toString(), this.getParams());
    }
}

