/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.jdbc.dsl;

import groovy.lang.GString;
import java.util.LinkedList;
import java.util.List;
import org.orbisgis.data.api.dataset.ISpatialTable;
import org.orbisgis.data.api.dataset.ITable;
import org.orbisgis.data.api.datasource.IJdbcDataSource;
import org.orbisgis.data.api.dsl.IBuilderResult;
import org.orbisgis.data.api.dsl.IFilterBuilder;
import org.orbisgis.data.api.dsl.IResultSetProperties;
import org.orbisgis.data.jdbc.dsl.BuilderResult;
import org.orbisgis.data.jdbc.dsl.ResultSetBuilder;

public class FilterBuilder
extends BuilderResult
implements IFilterBuilder {
    private final StringBuilder query;
    private final List<Object> params;
    private final IJdbcDataSource dataSource;
    private final IResultSetProperties rsp;

    public FilterBuilder(IJdbcDataSource dataSource, String query, List<Object> params, IResultSetProperties properties) {
        this.dataSource = dataSource;
        this.query = new StringBuilder(query == null ? "" : query);
        if (query != null && query.startsWith("(") && query.endsWith(")")) {
            this.query.append(" as foo");
        }
        this.params = new LinkedList<Object>(params);
        this.rsp = properties;
    }

    public FilterBuilder(IJdbcDataSource dataSource, String query, IResultSetProperties properties) {
        this.dataSource = dataSource;
        this.query = new StringBuilder(query == null ? "" : query);
        if (query != null && query.startsWith("(") && query.endsWith(")")) {
            this.query.append(" as foo");
        }
        this.params = new LinkedList<Object>();
        this.rsp = properties;
    }

    public IBuilderResult filter(String filter) {
        if (filter != null) {
            this.query.append(" ").append(filter);
        }
        return this;
    }

    public IBuilderResult filter(GString filter) {
        this.params.addAll(this.dataSource.getParameters(filter));
        this.query.append(" ").append(this.dataSource.asSql(filter, this.params));
        return this;
    }

    public IBuilderResult filter(String filter, List<Object> params) {
        this.params.addAll(params);
        this.query.append(" ").append(filter);
        return this;
    }

    @Override
    protected IJdbcDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    protected String getQuery() {
        return this.query.toString();
    }

    @Override
    public String toString() {
        return "(" + this.getQuery() + ")";
    }

    public List<Object> getParams() {
        return this.params;
    }

    public ITable<?, ?> getTable() throws Exception {
        ResultSetBuilder rsb = new ResultSetBuilder(this.getDataSource(), this.rsp);
        return rsb.getTable(this.toString(), this.getParams());
    }

    public ISpatialTable<?> getSpatialTable() throws Exception {
        ResultSetBuilder rsb = new ResultSetBuilder(this.getDataSource(), this.rsp);
        return rsb.getSpatialTable(this.toString(), this.getParams());
    }
}

