/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.jdbc.dsl;

import groovy.lang.GString;
import java.util.Arrays;
import java.util.List;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.orbisgis.data.api.dataset.ISpatialTable;
import org.orbisgis.data.api.dataset.ITable;
import org.orbisgis.data.api.datasource.IJdbcDataSource;
import org.orbisgis.data.api.dsl.IBuilderResult;
import org.orbisgis.data.api.dsl.IFilterBuilder;
import org.orbisgis.data.api.dsl.IQueryBuilder;
import org.orbisgis.data.api.dsl.IResultSetProperties;
import org.orbisgis.data.jdbc.dsl.BuilderResult;
import org.orbisgis.data.jdbc.dsl.FilterBuilder;
import org.orbisgis.data.jdbc.dsl.ResultSetBuilder;

public class QueryBuilder
extends BuilderResult
implements IQueryBuilder {
    private String columns = "*";
    private final String location;
    private final IJdbcDataSource dataSource;
    private final IResultSetProperties rsp;

    public QueryBuilder(IJdbcDataSource dataSource, String nameOrQuery, IResultSetProperties properties) {
        this.dataSource = dataSource;
        this.location = nameOrQuery.startsWith("(") && nameOrQuery.endsWith(")") ? nameOrQuery + " as foo" : TableLocation.parse((String)nameOrQuery, (DBTypes)dataSource.getDataBaseType()).toString();
        this.rsp = properties.copy();
    }

    public IBuilderResult filter(String filter) {
        FilterBuilder filterBuilder = new FilterBuilder(this.dataSource, this.getQuery(), this.getResultSetProperties());
        if (filter != null) {
            return filterBuilder.filter(filter);
        }
        return filterBuilder;
    }

    public IBuilderResult filter(GString filter) {
        FilterBuilder filterBuilder = new FilterBuilder(this.dataSource, this.getQuery(), this.getResultSetProperties());
        if (filter != null) {
            return filterBuilder.filter(filter);
        }
        return filterBuilder;
    }

    public IBuilderResult filter(String filter, List<Object> params) {
        FilterBuilder filterBuilder = new FilterBuilder(this.dataSource, this.getQuery(), this.getResultSetProperties());
        if (filter != null) {
            return filterBuilder.filter(filter, params);
        }
        return filterBuilder;
    }

    public IFilterBuilder columns(String ... columns) {
        this.columns = columns == null || columns.length == 0 || Arrays.stream(columns).allMatch(s -> s == null || s.isEmpty()) ? "*" : String.join((CharSequence)", ", columns);
        return new FilterBuilder(this.dataSource, this.getQuery(), this.getResultSetProperties());
    }

    @Override
    protected IJdbcDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    protected String getQuery() {
        return "SELECT " + this.columns + " FROM " + this.location;
    }

    @Override
    public String toString() {
        return "(" + this.getQuery() + ")";
    }

    public List<Object> getParams() {
        return null;
    }

    public IResultSetProperties getResultSetProperties() {
        return this.rsp;
    }

    public ITable<?, ?> getTable() throws Exception {
        ResultSetBuilder rsb = new ResultSetBuilder(this.getDataSource(), this.rsp);
        return rsb.getTable(this.toString(), this.getParams());
    }

    public ISpatialTable<?> getSpatialTable() throws Exception {
        ResultSetBuilder rsb = new ResultSetBuilder(this.getDataSource(), this.rsp);
        return rsb.getSpatialTable(this.toString(), this.getParams());
    }
}

