/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.jdbc.dsl;

import groovy.lang.GString;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.orbisgis.data.api.dataset.IJdbcSpatialTable;
import org.orbisgis.data.api.dataset.IJdbcTable;
import org.orbisgis.data.api.dataset.ISpatialTable;
import org.orbisgis.data.api.dataset.ITable;
import org.orbisgis.data.api.datasource.IJdbcDataSource;
import org.orbisgis.data.api.dsl.IResultSetBuilder;
import org.orbisgis.data.api.dsl.IResultSetProperties;
import org.orbisgis.data.jdbc.dsl.ResultSetProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetBuilder
implements IResultSetBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetBuilder.class);
    private final IJdbcDataSource dataSource;
    private IResultSetProperties rsp = new ResultSetProperties();

    public ResultSetBuilder(IJdbcDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ResultSetBuilder(IJdbcDataSource dataSource, IResultSetProperties properties) {
        this.dataSource = dataSource;
        this.rsp = properties.copy();
    }

    public IResultSetBuilder forwardOnly() {
        this.rsp.setType(1003);
        return this;
    }

    public IResultSetBuilder scrollInsensitive() {
        this.rsp.setType(1004);
        return this;
    }

    public IResultSetBuilder scrollSensitive() {
        this.rsp.setType(1005);
        return this;
    }

    public IResultSetBuilder readOnly() {
        this.rsp.setConcurrency(1007);
        return this;
    }

    public IResultSetBuilder updatable() {
        this.rsp.setConcurrency(1007);
        return this;
    }

    public IResultSetBuilder holdCursorOverCommit() {
        this.rsp.setHoldability(1);
        return this;
    }

    public IResultSetBuilder closeCursorAtCommit() {
        this.rsp.setHoldability(2);
        return this;
    }

    public IResultSetBuilder fetchForward() {
        this.rsp.setFetchDirection(1000);
        return this;
    }

    public IResultSetBuilder fetchReverse() {
        this.rsp.setFetchDirection(1001);
        return this;
    }

    public IResultSetBuilder fetchUnknown() {
        this.rsp.setFetchDirection(1002);
        return this;
    }

    public IResultSetBuilder fetchSize(int size) {
        this.rsp.setFetchSize(size);
        return this;
    }

    public IResultSetBuilder timeout(int timeout) {
        this.rsp.setTimeout(timeout);
        return this;
    }

    public IResultSetBuilder maxRow(int maxRow) {
        this.rsp.setMaxRows(maxRow);
        return this;
    }

    public IResultSetBuilder cursorName(String name) {
        this.rsp.setCursorName(name);
        return this;
    }

    public IResultSetBuilder poolable() {
        this.rsp.setPoolable(true);
        return this;
    }

    public IResultSetBuilder maxFieldSize(int size) {
        this.rsp.setMaxFieldSize(size);
        return this;
    }

    private Statement getStatement() throws SQLException {
        Statement st = this.rsp.getType() != -1 && this.rsp.getConcurrency() != -1 && this.rsp.getHoldability() != -1 ? this.dataSource.getConnection().createStatement(this.rsp.getType(), this.rsp.getConcurrency(), this.rsp.getHoldability()) : (this.rsp.getType() != -1 && this.rsp.getConcurrency() != -1 ? this.dataSource.getConnection().createStatement(this.rsp.getType(), this.rsp.getConcurrency()) : (this.rsp.getType() != -1 ? this.dataSource.getConnection().createStatement(this.rsp.getType(), 1007) : (this.rsp.getConcurrency() != -1 ? this.dataSource.getConnection().createStatement(1003, this.rsp.getConcurrency()) : this.dataSource.getConnection().createStatement())));
        if (this.rsp.getFetchDirection() != -1) {
            st.setFetchDirection(this.rsp.getFetchDirection());
        }
        if (this.rsp.getFetchSize() > -1) {
            st.setFetchSize(this.rsp.getFetchSize());
        }
        if (this.rsp.getTimeout() > -1) {
            st.setQueryTimeout(this.rsp.getTimeout());
        }
        if (this.rsp.getMaxRows() > -1) {
            st.setMaxRows(this.rsp.getMaxRows());
        }
        if (this.rsp.getCursorName() != null) {
            st.setCursorName(this.rsp.getCursorName());
        }
        if (this.rsp.isPoolable()) {
            st.setPoolable(true);
        }
        if (this.rsp.getMaxFieldSize() > -1) {
            st.setMaxFieldSize(this.rsp.getMaxFieldSize());
        }
        return st;
    }

    private Statement getStatement(String query, List<Object> params) throws SQLException {
        if (params == null || params.isEmpty()) {
            return this.getStatement();
        }
        PreparedStatement st = this.rsp.getType() != -1 && this.rsp.getConcurrency() != -1 && this.rsp.getHoldability() != -1 ? this.dataSource.getConnection().prepareStatement(query, this.rsp.getType(), this.rsp.getConcurrency(), this.rsp.getHoldability()) : (this.rsp.getType() != -1 && this.rsp.getConcurrency() != -1 ? this.dataSource.getConnection().prepareStatement(query, this.rsp.getType(), this.rsp.getConcurrency()) : (this.rsp.getType() != -1 ? this.dataSource.getConnection().prepareStatement(query, this.rsp.getType(), 1007) : (this.rsp.getConcurrency() != -1 ? this.dataSource.getConnection().prepareStatement(query, 1003, this.rsp.getConcurrency()) : this.dataSource.getConnection().prepareStatement(query))));
        for (int i = 0; i < params.size(); ++i) {
            st.setObject(i + 1, params.get(i));
        }
        if (this.rsp.getFetchDirection() != -1) {
            st.setFetchDirection(this.rsp.getFetchDirection());
        }
        if (this.rsp.getFetchSize() > -1) {
            st.setFetchSize(this.rsp.getFetchSize());
        }
        if (this.rsp.getTimeout() > -1) {
            st.setQueryTimeout(this.rsp.getTimeout());
        }
        if (this.rsp.getMaxRows() > -1) {
            st.setMaxRows(this.rsp.getMaxRows());
        }
        if (this.rsp.getCursorName() != null) {
            st.setCursorName(this.rsp.getCursorName());
        }
        if (this.rsp.isPoolable()) {
            st.setPoolable(true);
        }
        if (this.rsp.getMaxFieldSize() > -1) {
            st.setMaxFieldSize(this.rsp.getMaxFieldSize());
        }
        return st;
    }

    public boolean execute(String sql) throws SQLException {
        return this.getStatement().execute(sql);
    }

    public boolean execute(GString sql) throws SQLException {
        return this.getStatement().execute(sql.toString());
    }

    public int[] executeBatch(String[] queries) throws SQLException {
        Statement st = this.getStatement();
        for (String query : queries) {
            st.addBatch(query);
        }
        return st.executeBatch();
    }

    public int[] executeBatch(GString[] queries) throws SQLException {
        Statement st = this.getStatement();
        for (GString query : queries) {
            st.addBatch(query.toString());
        }
        return st.executeBatch();
    }

    public long[] executeLargeBatch(String[] queries) throws SQLException {
        Statement st = this.getStatement();
        for (String query : queries) {
            st.addBatch(query);
        }
        return st.executeLargeBatch();
    }

    public long[] executeLargeBatch(GString[] queries) throws SQLException {
        Statement st = this.getStatement();
        for (GString query : queries) {
            st.addBatch(query.toString());
        }
        return st.executeLargeBatch();
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.getStatement().executeUpdate(sql);
    }

    public int executeUpdate(GString sql) throws SQLException {
        return this.getStatement().executeUpdate(sql.toString());
    }

    public long executeLargeUpdate(String sql) throws SQLException {
        return this.getStatement().executeLargeUpdate(sql);
    }

    public long executeLargeUpdate(GString sql) throws SQLException {
        return this.getStatement().executeLargeUpdate(sql.toString());
    }

    public IJdbcTable<?> getTable(String nameOrQuery) throws Exception {
        try {
            IJdbcTable table = this.dataSource.getTable(nameOrQuery, this.getStatement());
            table.setResultSetProperties(this.rsp);
            return table;
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get the statement.", (Throwable)e);
            return this.dataSource.getTable(nameOrQuery);
        }
    }

    public IJdbcSpatialTable<?> getSpatialTable(String nameOrQuery) throws Exception {
        try {
            IJdbcSpatialTable table = this.dataSource.getSpatialTable(nameOrQuery, this.getStatement());
            table.setResultSetProperties(this.rsp);
            return table;
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get the statement.", (Throwable)e);
            return this.dataSource.getSpatialTable(nameOrQuery);
        }
    }

    public ITable<?, ?> getTable(GString nameOrQuery) throws Exception {
        if (nameOrQuery.getValueCount() == 0) {
            return this.getTable(nameOrQuery.toString());
        }
        List params = this.dataSource.getParameters(nameOrQuery);
        String sql = this.dataSource.asSql(nameOrQuery, params);
        return this.getTable(sql, params);
    }

    public ISpatialTable<?> getSpatialTable(GString nameOrQuery) throws Exception {
        if (nameOrQuery.getValueCount() == 0) {
            return this.getSpatialTable(nameOrQuery.toString());
        }
        List params = this.dataSource.getParameters(nameOrQuery);
        String sql = this.dataSource.asSql(nameOrQuery, params);
        return this.getSpatialTable(sql, params);
    }

    public ITable<?, ?> getTable(String query, List<Object> params) throws Exception {
        try {
            IJdbcTable table = this.dataSource.getTable(query, params, this.getStatement(query, params));
            table.setResultSetProperties(this.rsp);
            return table;
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get the statement.", (Throwable)e);
            return this.dataSource.getTable(query, params);
        }
    }

    public ISpatialTable<?> getSpatialTable(String query, List<Object> params) throws Exception {
        try {
            IJdbcSpatialTable table = this.dataSource.getSpatialTable(query, params, this.getStatement(query, params));
            table.setResultSetProperties(this.rsp);
            return table;
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get the statement.", (Throwable)e);
            return this.dataSource.getSpatialTable(query, params);
        }
    }
}

