/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.jdbc.dsl;

import org.orbisgis.data.api.dsl.IResultSetProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetProperties
implements IResultSetProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetProperties.class);
    private int type = -1;
    private int concurrency = -1;
    private int holdability = -1;
    private int fetchDirection = -1;
    private int fetchSize = 100;
    private int timeout = -1;
    private int maxRows = -1;
    private String cursorName = null;
    private boolean poolable = false;
    private int maxFieldSize = -1;

    public void setType(int type) {
        if (type != 1003 && type != 1004 && type != 1005 && type != -1) {
            LOGGER.warn("ResultSet type should be 'TYPE_FORWARD_ONLY' or 'TYPE_SCROLL_INSENSITIVE' or 'TYPE_SCROLL_SENSITIVE'.");
            this.type = -1;
        } else {
            this.type = type;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setConcurrency(int concurrency) {
        if (concurrency != 1007 && concurrency != 1008 && concurrency != -1) {
            LOGGER.warn("ResultSet concurrency should be 'CONCUR_READ_ONLY' or 'CONCUR_UPDATABLE'.");
            this.concurrency = -1;
        } else {
            this.concurrency = concurrency;
        }
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setHoldability(int holdability) {
        if (holdability != 1 && holdability != 2 && holdability != -1) {
            LOGGER.warn("ResultSet holdability should be 'HOLD_CURSORS_OVER_COMMIT' or 'CLOSE_CURSORS_AT_COMMIT'.");
            this.holdability = -1;
        } else {
            this.holdability = holdability;
        }
    }

    public int getHoldability() {
        return this.holdability;
    }

    public void setFetchDirection(int fetchDirection) {
        if (fetchDirection != 1000 && fetchDirection != 1001 && fetchDirection != 1002 && fetchDirection != -1) {
            LOGGER.warn("ResultSet holdability should be 'FETCH_FORWARD' or 'FETCH_REVERSE' or 'FETCH_UNKNOWN'.");
            this.fetchDirection = -1;
        } else {
            this.fetchDirection = fetchDirection;
        }
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public void setFetchSize(int fetchSize) {
        if (fetchSize < 0) {
            LOGGER.warn("The fetch size cannot be under 0 so it will be disabled.");
            this.fetchSize = 100;
        } else {
            this.fetchSize = fetchSize;
        }
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setTimeout(int timeout) {
        if (timeout < -1) {
            LOGGER.warn("The timeout cannot be under 0 so it will be disabled.");
            this.timeout = -1;
        } else {
            this.timeout = timeout;
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setMaxRows(int maxRows) {
        if (maxRows < -1) {
            LOGGER.warn("The max rows count cannot be under 0 so it will be disabled.");
            this.maxRows = -1;
        } else {
            this.maxRows = maxRows;
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setCursorName(String cursorName) {
        this.cursorName = cursorName;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public void setPoolable(boolean poolable) {
        this.poolable = poolable;
    }

    public boolean isPoolable() {
        return this.poolable;
    }

    public void setMaxFieldSize(int maxFieldSize) {
        if (maxFieldSize < -1) {
            LOGGER.warn("The max field size cannot be under 0 so it will be disabled.");
            this.maxFieldSize = -1;
        } else {
            this.maxFieldSize = maxFieldSize;
        }
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public IResultSetProperties copy() {
        ResultSetProperties rsp = new ResultSetProperties();
        rsp.type = this.type;
        rsp.concurrency = this.concurrency;
        rsp.holdability = this.holdability;
        rsp.fetchDirection = this.fetchDirection;
        rsp.fetchSize = this.fetchSize;
        rsp.timeout = this.timeout;
        rsp.maxRows = this.maxRows;
        rsp.cursorName = this.cursorName;
        rsp.poolable = this.poolable;
        rsp.maxFieldSize = this.maxFieldSize;
        return rsp;
    }
}

