/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.monitoring;

import com.caoccao.javet.enums.V8AllocationSpace;
import java.util.Objects;

public final class V8HeapSpaceStatistics {
    private final long physicalSpaceSize;
    private final long spaceAvailableSize;
    private final String spaceName;
    private final long spaceSize;
    private final long spaceUsedSize;
    private V8AllocationSpace v8AllocationSpace;

    public V8HeapSpaceStatistics(String spaceName, long physicalSpaceSize, long spaceAvailableSize, long spaceSize, long spaceUsedSize) {
        this.spaceName = spaceName;
        this.physicalSpaceSize = physicalSpaceSize;
        this.spaceAvailableSize = spaceAvailableSize;
        this.spaceSize = spaceSize;
        this.spaceUsedSize = spaceUsedSize;
    }

    public V8AllocationSpace getAllocationSpace() {
        return this.v8AllocationSpace;
    }

    public long getPhysicalSpaceSize() {
        return this.physicalSpaceSize;
    }

    public long getSpaceAvailableSize() {
        return this.spaceAvailableSize;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public long getSpaceSize() {
        return this.spaceSize;
    }

    public long getSpaceUsedSize() {
        return this.spaceUsedSize;
    }

    public V8HeapSpaceStatistics minus(V8HeapSpaceStatistics v8HeapSpaceStatistics) {
        return new V8HeapSpaceStatistics(this.spaceName, this.physicalSpaceSize - v8HeapSpaceStatistics.physicalSpaceSize, this.spaceAvailableSize - v8HeapSpaceStatistics.spaceAvailableSize, this.spaceSize - v8HeapSpaceStatistics.spaceSize, this.spaceUsedSize - v8HeapSpaceStatistics.spaceUsedSize);
    }

    public V8HeapSpaceStatistics setAllocationSpace(V8AllocationSpace v8AllocationSpace) {
        this.v8AllocationSpace = Objects.requireNonNull(v8AllocationSpace);
        return this;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean ignoreZero) {
        StringBuilder sb = new StringBuilder();
        sb.append("name = ").append(this.getClass().getSimpleName());
        sb.append(", ").append("spaceName = ").append(this.spaceName);
        if (!ignoreZero || this.physicalSpaceSize != 0L) {
            sb.append(", ").append("physicalSpaceSize = ").append(this.physicalSpaceSize);
        }
        if (!ignoreZero || this.spaceAvailableSize != 0L) {
            sb.append(", ").append("spaceAvailableSize = ").append(this.spaceAvailableSize);
        }
        if (!ignoreZero || this.spaceSize != 0L) {
            sb.append(", ").append("spaceSize = ").append(this.spaceSize);
        }
        if (!ignoreZero || this.spaceUsedSize != 0L) {
            sb.append(", ").append("spaceUsedSize = ").append(this.spaceUsedSize);
        }
        return sb.toString();
    }
}

