/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.enums.V8ConversionMode;
import com.caoccao.javet.enums.V8ProxyMode;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetEntitySymbol;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.binding.ClassDescriptor;
import com.caoccao.javet.interop.binding.ClassDescriptorStore;
import com.caoccao.javet.interop.binding.IClassProxyPlugin;
import com.caoccao.javet.interop.binding.IClassProxyPluginFunction;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.proxy.BaseJavetReflectionProxyHandler;
import com.caoccao.javet.interop.proxy.plugins.JavetProxyPluginDefault;
import com.caoccao.javet.utils.ArrayUtils;
import com.caoccao.javet.utils.StringUtils;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import java.util.Objects;

public class JavetReflectionProxyObjectHandler<T, E extends Exception>
extends BaseJavetReflectionProxyHandler<T, E> {
    public JavetReflectionProxyObjectHandler(V8Runtime v8Runtime, T targetObject) {
        super(v8Runtime, Objects.requireNonNull(targetObject));
    }

    protected boolean deleteFromCollection(V8Value property) throws JavetException {
        IClassProxyPlugin classProxyPlugin = this.classDescriptor.getClassProxyPlugin();
        if (classProxyPlugin.isDeleteSupported(this.classDescriptor.getTargetClass())) {
            return classProxyPlugin.deleteByObject(this.targetObject, this.v8Runtime.toObject(property));
        }
        return false;
    }

    @Override
    public V8ValueBoolean deleteProperty(V8Value target, V8Value property) throws JavetException, E {
        boolean deleted = this.deleteFromCollection(property);
        if (deleted) {
            return this.v8Runtime.createV8ValueBoolean(true);
        }
        return super.deleteProperty(target, property);
    }

    protected V8Value getByIndex(V8Value property) throws JavetException {
        Object result;
        int index;
        String propertyString;
        IClassProxyPlugin classProxyPlugin = this.classDescriptor.getClassProxyPlugin();
        if (classProxyPlugin.isIndexSupported(this.classDescriptor.getTargetClass()) && property instanceof V8ValueString && StringUtils.isDigital(propertyString = (String)((V8ValueString)property).getValue()) && (index = Integer.parseInt(propertyString)) >= 0 && (result = classProxyPlugin.getByIndex(this.targetObject, index)) != null) {
            return this.v8Runtime.toV8Value(result);
        }
        return null;
    }

    protected V8Value getByPolyfill(V8Value property) throws JavetException, E {
        IClassProxyPluginFunction classProxyPluginFunction = null;
        if (property instanceof V8ValueString) {
            String propertyName = (String)((V8ValueString)property).getValue();
            classProxyPluginFunction = this.classDescriptor.getClassProxyPlugin().getProxyGetByString(this.classDescriptor.getTargetClass(), propertyName);
        } else if (property instanceof V8ValueSymbol) {
            V8ValueSymbol propertySymbol = (V8ValueSymbol)property;
            String description = propertySymbol.getDescription();
            classProxyPluginFunction = this.classDescriptor.getClassProxyPlugin().getProxyGetBySymbol(this.classDescriptor.getTargetClass(), description);
        }
        if (classProxyPluginFunction != null) {
            return classProxyPluginFunction.invoke(this.v8Runtime, this.targetObject);
        }
        return null;
    }

    @Override
    public JavetCallbackContext[] getCallbackContexts() {
        if (this.callbackContexts == null) {
            this.callbackContexts = new JavetCallbackContext[]{new JavetCallbackContext("deleteProperty", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.deleteProperty(v8Values[0], v8Values[1])), new JavetCallbackContext("get", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.get(v8Values[0], v8Values[1], v8Values[2])), new JavetCallbackContext("getOwnPropertyDescriptor", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.getOwnPropertyDescriptor(v8Values[0], v8Values[1])), new JavetCallbackContext("getPrototypeOf", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.getPrototypeOf(v8Values[0])), new JavetCallbackContext("has", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.has(v8Values[0], v8Values[1])), new JavetCallbackContext("ownKeys", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.ownKeys(v8Values[0])), new JavetCallbackContext("set", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.set(v8Values[0], v8Values[1], v8Values[2], v8Values[3]))};
        }
        return this.callbackContexts;
    }

    @Override
    public V8ProxyMode getProxyMode() {
        return V8ProxyMode.Object;
    }

    @Override
    public V8ValueBoolean has(V8Value target, V8Value property) throws JavetException {
        boolean isFound = this.hasFromCollection(property);
        isFound = isFound || this.hasFromRegular(property);
        isFound = isFound || this.hasFromGeneric(property);
        return this.v8Runtime.createV8ValueBoolean(isFound);
    }

    protected boolean hasFromCollection(V8Value property) throws JavetException {
        IClassProxyPlugin classProxyPlugin = this.classDescriptor.getClassProxyPlugin();
        if (classProxyPlugin.isHasSupported(this.classDescriptor.getTargetClass())) {
            return classProxyPlugin.hasByObject(this.targetObject, this.v8Runtime.toObject(property));
        }
        return false;
    }

    @Override
    protected void initialize() {
        Class<?> targetClass = this.targetObject.getClass();
        this.classDescriptor = ClassDescriptorStore.getObjectMap().get(targetClass);
        if (this.classDescriptor == null) {
            IClassProxyPlugin iClassProxyPlugin = this.v8Runtime.getConverter().getConfig().getProxyPlugins().stream().filter(p -> p.isProxyable(targetClass)).findFirst().orElse(JavetProxyPluginDefault.getInstance());
            this.classDescriptor = new ClassDescriptor(V8ProxyMode.Object, targetClass, iClassProxyPlugin);
            if (this.targetObject instanceof Class) {
                this.initializeFieldsAndMethods((Class)this.targetObject, true);
            }
            this.initializeCollection();
            this.initializeFieldsAndMethods(targetClass, false);
            ClassDescriptorStore.getObjectMap().put(targetClass, this.classDescriptor);
        }
    }

    protected void initializeCollection() {
        IClassProxyPlugin classProxyPlugin = this.classDescriptor.getClassProxyPlugin();
        if (classProxyPlugin.isUniqueKeySupported(this.classDescriptor.getTargetClass())) {
            classProxyPlugin.populateUniqueKeys(this.classDescriptor.getUniqueKeySet(), this.targetObject);
        }
    }

    protected void initializeFieldsAndMethods(Class<?> currentClass, boolean staticMode) {
        V8ConversionMode conversionMode = this.classDescriptor.getConversionMode();
        do {
            this.initializePublicFields(currentClass, conversionMode, staticMode);
            this.initializePublicMethods(currentClass, conversionMode, staticMode);
        } while (currentClass != Object.class && (currentClass = currentClass.getSuperclass()) != null);
    }

    @Override
    protected V8Value internalGet(V8Value target, V8Value property) throws JavetException, E {
        V8Value v8Value = this.getByIndex(property);
        v8Value = v8Value == null ? this.getByField(property) : v8Value;
        v8Value = v8Value == null ? this.getByMethod(target, property) : v8Value;
        v8Value = v8Value == null ? this.getByGetter(property) : v8Value;
        v8Value = v8Value == null ? this.getByPolyfill(property) : v8Value;
        return v8Value;
    }

    @Override
    public V8ValueArray ownKeys(V8Value target) throws JavetException, E {
        IClassProxyPlugin classProxyPlugin = this.classDescriptor.getClassProxyPlugin();
        if (classProxyPlugin.isOwnKeysSupported(this.classDescriptor.getTargetClass())) {
            Object[] keys = classProxyPlugin.getProxyOwnKeys(this.targetObject);
            if (ArrayUtils.isEmpty(keys)) {
                keys = this.classDescriptor.getUniqueKeySet().toArray();
            }
            for (int i2 = 0; i2 < keys.length; ++i2) {
                Object key = keys[i2];
                keys[i2] = key instanceof String ? this.v8Runtime.createV8ValueString((String)key) : (key instanceof IJavetEntitySymbol ? this.v8Runtime.createV8ValueSymbol(((IJavetEntitySymbol)key).getDescription()) : this.v8Runtime.createV8ValueString(String.valueOf(key)));
            }
            return V8ValueUtils.createV8ValueArray(this.v8Runtime, keys);
        }
        return super.ownKeys(target);
    }

    @Override
    public V8ValueBoolean set(V8Value target, V8Value propertyKey, V8Value propertyValue, V8Value receiver) throws JavetException {
        boolean isSet = this.setByIndex(propertyKey, propertyValue);
        isSet = isSet || this.setToField(propertyKey, propertyValue);
        isSet = isSet || this.setToSetter(target, propertyKey, propertyValue);
        return this.v8Runtime.createV8ValueBoolean(isSet);
    }

    protected boolean setByIndex(V8Value propertyKey, V8Value propertyValue) throws JavetException {
        int index;
        String propertyKeyString;
        IClassProxyPlugin classProxyPlugin = this.classDescriptor.getClassProxyPlugin();
        if (classProxyPlugin.isIndexSupported(this.classDescriptor.getTargetClass()) && propertyKey instanceof V8ValueString && StringUtils.isDigital(propertyKeyString = (String)((V8ValueString)propertyKey).getValue()) && (index = Integer.parseInt(propertyKeyString)) >= 0) {
            return classProxyPlugin.setByIndex(this.targetObject, index, this.v8Runtime.toObject(propertyValue));
        }
        return false;
    }
}

