/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import com.caoccao.javet.utils.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class JavetTypeUtils {
    public static Object toApproximatePrimitive(Class<?> expectedClass, Object object) {
        if (expectedClass == Integer.TYPE || expectedClass == Integer.class) {
            if (object instanceof Integer) {
                return object;
            }
            if (object instanceof Long) {
                return ((Long)object).intValue();
            }
            if (object instanceof Short) {
                return ((Short)object).intValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).intValue();
            }
        }
        if ((expectedClass == Boolean.TYPE || expectedClass == Boolean.class) && object instanceof Boolean) {
            return object;
        }
        if (expectedClass == Double.TYPE || expectedClass == Double.class) {
            if (object instanceof Double) {
                return object;
            }
            if (object instanceof Float) {
                return ((Float)object).doubleValue();
            }
            if (object instanceof Integer) {
                return ((Integer)object).doubleValue();
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue();
            }
            if (object instanceof Short) {
                return ((Short)object).doubleValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).doubleValue();
            }
        }
        if (expectedClass == Float.TYPE || expectedClass == Float.class) {
            if (object instanceof Float) {
                return object;
            }
            if (object instanceof Double) {
                return Float.valueOf(((Double)object).floatValue());
            }
            if (object instanceof Integer) {
                return Float.valueOf(((Integer)object).floatValue());
            }
            if (object instanceof Long) {
                return Float.valueOf(((Long)object).floatValue());
            }
            if (object instanceof Short) {
                return Float.valueOf(((Short)object).floatValue());
            }
            if (object instanceof Byte) {
                return Float.valueOf(((Byte)object).floatValue());
            }
        }
        if (expectedClass == Long.TYPE || expectedClass == Long.class) {
            if (object instanceof Long) {
                return object;
            }
            if (object instanceof Integer) {
                return ((Integer)object).longValue();
            }
            if (object instanceof Short) {
                return ((Short)object).longValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).longValue();
            }
        }
        if (expectedClass == Short.TYPE || expectedClass == Short.class) {
            if (object instanceof Short) {
                return object;
            }
            if (object instanceof Integer) {
                return ((Integer)object).shortValue();
            }
            if (object instanceof Long) {
                return ((Long)object).shortValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).shortValue();
            }
        }
        if (expectedClass == Byte.TYPE || expectedClass == Byte.class) {
            if (object instanceof Byte) {
                return object;
            }
            if (object instanceof Integer) {
                return ((Integer)object).byteValue();
            }
            if (object instanceof Long) {
                return ((Long)object).byteValue();
            }
            if (object instanceof Short) {
                return ((Short)object).byteValue();
            }
        }
        if (expectedClass == Character.TYPE || expectedClass == Character.class) {
            String objectString;
            if (object instanceof Character) {
                return object;
            }
            if (object instanceof String && StringUtils.isNotEmpty(objectString = (String)object)) {
                return Character.valueOf(objectString.charAt(0));
            }
        }
        return null;
    }

    public static DoubleStream toDoubleStream(Object object) {
        Collection collection;
        if (object instanceof double[]) {
            return DoubleStream.of((double[])object);
        }
        if (object instanceof Collection && (collection = (Collection)object).stream().allMatch(i2 -> i2 instanceof Double)) {
            return collection.stream().mapToDouble(i2 -> (Double)i2);
        }
        return null;
    }

    public static Object toExactPrimitive(Class<?> expectedClass, Object object) {
        if (expectedClass == Integer.TYPE && object instanceof Integer) {
            return (int)((Integer)object);
        }
        if (expectedClass == Boolean.TYPE && object instanceof Boolean) {
            return (boolean)((Boolean)object);
        }
        if (expectedClass == Double.TYPE && object instanceof Double) {
            return (double)((Double)object);
        }
        if (expectedClass == Float.TYPE && object instanceof Float) {
            return Float.valueOf(((Float)object).floatValue());
        }
        if (expectedClass == Long.TYPE && object instanceof Long) {
            return (long)((Long)object);
        }
        if (expectedClass == Short.TYPE && object instanceof Short) {
            return (short)((Short)object);
        }
        if (expectedClass == Byte.TYPE && object instanceof Byte) {
            return (byte)((Byte)object);
        }
        if (expectedClass == Character.TYPE && object instanceof Character) {
            return Character.valueOf(((Character)object).charValue());
        }
        return null;
    }

    public static IntStream toIntStream(Object object) {
        Collection collection;
        if (object instanceof int[]) {
            return IntStream.of((int[])object);
        }
        if (object instanceof Collection && (collection = (Collection)object).stream().allMatch(i2 -> i2 instanceof Integer)) {
            return collection.stream().mapToInt(i2 -> (Integer)i2);
        }
        return null;
    }

    public static LongStream toLongStream(Object object) {
        Collection collection;
        if (object instanceof long[]) {
            return LongStream.of((long[])object);
        }
        if (object instanceof Collection && (collection = (Collection)object).stream().allMatch(i2 -> i2 instanceof Long)) {
            return collection.stream().mapToLong(i2 -> (Long)i2);
        }
        return null;
    }

    public static Stream<?> toStream(Object object) {
        if (object.getClass().isArray()) {
            if (object instanceof int[]) {
                return Arrays.stream((int[])object).boxed();
            }
            if (object instanceof long[]) {
                return Arrays.stream((long[])object).boxed();
            }
            if (object instanceof double[]) {
                return Arrays.stream((double[])object).boxed();
            }
            if (object instanceof boolean[]) {
                boolean[] booleanArray = (boolean[])object;
                Object[] objects = new Object[booleanArray.length];
                for (int i2 = 0; i2 < booleanArray.length; ++i2) {
                    objects[i2] = booleanArray[i2];
                }
                return Stream.of(objects);
            }
            if (object instanceof float[]) {
                float[] floatArray = (float[])object;
                Object[] objects = new Object[floatArray.length];
                for (int i3 = 0; i3 < floatArray.length; ++i3) {
                    objects[i3] = Float.valueOf(floatArray[i3]);
                }
                return Stream.of(objects);
            }
            if (object instanceof byte[]) {
                byte[] byteArray = (byte[])object;
                Object[] objects = new Object[byteArray.length];
                for (int i4 = 0; i4 < byteArray.length; ++i4) {
                    objects[i4] = byteArray[i4];
                }
                return Stream.of(objects);
            }
            if (object instanceof short[]) {
                short[] shortArray = (short[])object;
                Object[] objects = new Object[shortArray.length];
                for (int i5 = 0; i5 < shortArray.length; ++i5) {
                    objects[i5] = shortArray[i5];
                }
                return Stream.of(objects);
            }
            if (object instanceof char[]) {
                char[] charArray = (char[])object;
                Object[] objects = new Object[charArray.length];
                for (int i6 = 0; i6 < charArray.length; ++i6) {
                    objects[i6] = Character.valueOf(charArray[i6]);
                }
                return Stream.of(objects);
            }
            return Stream.of((Object[])object);
        }
        if (object instanceof Collection) {
            return ((Collection)object).stream();
        }
        return null;
    }
}

