/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import com.caoccao.javet.utils.ArrayUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> int addAll(List<T> list, Object array) {
        int length = Array.getLength(array);
        for (int i2 = 0; i2 < length; ++i2) {
            list.add(Array.get(array, i2));
        }
        return length;
    }

    public static <T> void flat(List<T> targetList, List<T> sourceList, int depth) {
        if (depth <= 0) {
            targetList.addAll(sourceList);
        } else if (!sourceList.isEmpty()) {
            for (T object : sourceList) {
                if (object instanceof List) {
                    ListUtils.flat(targetList, (List)object, depth - 1);
                    continue;
                }
                if (object != null && object.getClass().isArray()) {
                    int length = Array.getLength(object);
                    ArrayList<Object> childList = new ArrayList<Object>(length);
                    for (int i2 = 0; i2 < length; ++i2) {
                        childList.add(Array.get(object, i2));
                    }
                    ListUtils.flat(targetList, childList, depth - 1);
                    continue;
                }
                targetList.add(object);
            }
        }
    }

    public static <T> boolean includes(List<T> list, T element, int fromIndex) {
        int index = 0;
        for (T item : list) {
            if (Objects.equals(item, element) && index >= fromIndex) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public static <T> int indexOf(List<T> list, T element, int fromIndex) {
        int length = list.size();
        if (fromIndex >= 0 && fromIndex < length) {
            for (int i2 = fromIndex; i2 < length; ++i2) {
                if (!Objects.equals(list.get(i2), element)) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNotEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    public static <T> int lastIndexOf(List<T> list, T element, int fromIndex) {
        int length = list.size();
        if (fromIndex >= 0 && fromIndex < length) {
            for (int i2 = fromIndex; i2 >= 0; --i2) {
                if (!Objects.equals(list.get(i2), element)) continue;
                return i2;
            }
        }
        return -1;
    }

    public static <T> T pop(List<T> list) {
        int size = list.size();
        if (size > 0) {
            return list.remove(size - 1);
        }
        return null;
    }

    public static <T> int push(List<T> list, T ... elements) {
        if (ArrayUtils.isNotEmpty(elements)) {
            Collections.addAll(list, elements);
        }
        return list.size();
    }

    public static <T> T shift(List<T> list) {
        int size = list.size();
        if (size > 0) {
            return list.remove(0);
        }
        return null;
    }

    public static <T> int unshift(List<T> list, T ... elements) {
        if (ArrayUtils.isNotEmpty(elements)) {
            list.addAll(0, Arrays.asList(elements));
        }
        return list.size();
    }
}

