/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import com.caoccao.javet.enums.V8ValueErrorType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.exceptions.V8ErrorTemplate;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.V8Scope;
import com.caoccao.javet.utils.ArrayUtils;
import com.caoccao.javet.utils.JavetVirtualObject;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueMap;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValueSet;
import java.util.Map;
import java.util.StringJoiner;

public final class V8ValueUtils {
    private V8ValueUtils() {
    }

    public static int asInt(V8Value[] v8Values, int index) throws JavetException {
        return V8ValueUtils.asInt(v8Values, index, 0);
    }

    public static int asInt(V8Value[] v8Values, int index, int defaultValue) throws JavetException {
        if (v8Values != null && index >= 0 && index < v8Values.length && v8Values[index] != null) {
            return v8Values[index].asInt();
        }
        return defaultValue;
    }

    public static String asString(V8Value[] v8Values, int index) {
        return V8ValueUtils.asString(v8Values, index, "undefined");
    }

    public static String asString(V8Value[] v8Values, int index, String defaultValue) {
        if (v8Values != null && index >= 0 && index < v8Values.length && v8Values[index] != null) {
            return v8Values[index].toString();
        }
        return defaultValue;
    }

    public static String asString(V8Value v8Value) {
        return V8ValueUtils.asString(v8Value, "undefined");
    }

    public static String asString(V8Value v8Value, String defaultValue) {
        return v8Value == null ? defaultValue : v8Value.toString();
    }

    public static V8Value asV8Value(V8Value[] v8Values, int index) {
        if (v8Values != null && index >= 0 && index < v8Values.length) {
            return v8Values[index];
        }
        return null;
    }

    public static V8ValueFunction asV8ValueFunction(V8Value[] v8Values, int index) {
        V8Value v8Value;
        if (ArrayUtils.isNotEmpty(v8Values) && index >= 0 && index < v8Values.length && (v8Value = v8Values[index]) instanceof V8ValueFunction) {
            return (V8ValueFunction)v8Value;
        }
        return null;
    }

    public static V8ValueFunction asV8ValueFunctionWithError(V8Runtime v8Runtime, V8Value[] v8Values, int index) {
        V8Value v8Value = null;
        if (ArrayUtils.isNotEmpty(v8Values) && index >= 0 && index < v8Values.length && (v8Value = v8Values[index]) instanceof V8ValueFunction) {
            return (V8ValueFunction)v8Value;
        }
        v8Runtime.throwError(V8ValueErrorType.TypeError, V8ErrorTemplate.typeErrorValueIsNotAFunction(v8Value));
        return null;
    }

    public static V8ValueObject asV8ValueObject(V8Value[] v8Values, int index) {
        if (v8Values != null && index >= 0 && index < v8Values.length && v8Values[index] instanceof V8ValueObject) {
            return (V8ValueObject)v8Values[index];
        }
        return null;
    }

    public static String concat(String delimiter, V8Value ... v8Values) {
        if (ArrayUtils.isEmpty(v8Values)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringJoiner stringJoiner = new StringJoiner(delimiter);
        for (V8Value v8Value : v8Values) {
            stringJoiner.add(V8ValueUtils.asString(v8Value));
        }
        return stringJoiner.toString();
    }

    public static JavetVirtualObject[] convertToVirtualObjects(V8Value ... v8Values) {
        int length = v8Values == null ? 0 : v8Values.length;
        JavetVirtualObject[] javetVirtualObjects = new JavetVirtualObject[length];
        for (int i2 = 0; i2 < length; ++i2) {
            javetVirtualObjects[i2] = new JavetVirtualObject(v8Values[i2]);
        }
        return javetVirtualObjects;
    }

    public static V8ValueArray createV8ValueArray(V8Runtime v8Runtime, Object ... objects) throws JavetException {
        try (V8Scope v8Scope = v8Runtime.getV8Scope();){
            V8ValueArray v8ValueArray = v8Scope.createV8ValueArray();
            if (ArrayUtils.isNotEmpty(objects)) {
                v8ValueArray.push(objects);
            }
            v8Scope.setEscapable();
            V8ValueArray v8ValueArray2 = v8ValueArray;
            return v8ValueArray2;
        }
    }

    public static V8ValueMap createV8ValueMap(V8Runtime v8Runtime, Map<?, ?> map) throws JavetException {
        try (V8Scope v8Scope = v8Runtime.getV8Scope();){
            V8ValueMap v8ValueMap = v8Scope.createV8ValueMap();
            if (map != null && !map.isEmpty()) {
                Object[] keyAndValuePairs = new Object[map.size() << 1];
                int index = 0;
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    keyAndValuePairs[index++] = entry.getKey();
                    keyAndValuePairs[index++] = entry.getValue();
                }
                v8ValueMap.set(keyAndValuePairs);
            }
            v8Scope.setEscapable();
            V8ValueMap v8ValueMap2 = v8ValueMap;
            return v8ValueMap2;
        }
    }

    public static V8ValueObject createV8ValueObject(V8Runtime v8Runtime, Object ... objects) throws JavetException {
        try (V8Scope v8Scope = v8Runtime.getV8Scope();){
            V8ValueObject v8ValueObject = v8Scope.createV8ValueObject();
            if (ArrayUtils.isNotEmpty(objects)) {
                v8ValueObject.set(objects);
            }
            v8Scope.setEscapable();
            V8ValueObject v8ValueObject2 = v8ValueObject;
            return v8ValueObject2;
        }
    }

    public static V8ValueSet createV8ValueSet(V8Runtime v8Runtime, Object ... objects) throws JavetException {
        try (V8Scope v8Scope = v8Runtime.getV8Scope();){
            V8ValueSet v8ValueSet = v8Scope.createV8ValueSet();
            if (ArrayUtils.isNotEmpty(objects)) {
                for (Object object : objects) {
                    v8ValueSet.add(object);
                }
            }
            v8Scope.setEscapable();
            V8ValueSet v8ValueSet2 = v8ValueSet;
            return v8ValueSet2;
        }
    }

    public static Object[] toArray(V8Runtime v8Runtime, V8Value ... v8Values) throws JavetException {
        int length = v8Values == null ? 0 : v8Values.length;
        Object[] objects = new Object[length];
        for (int i2 = 0; i2 < length; ++i2) {
            objects[i2] = v8Runtime.toObject(v8Values[i2]);
        }
        return objects;
    }

    public static String trimAnonymousFunction(String sourceCode) {
        int length;
        if (sourceCode != null && (length = sourceCode.length()) > 0) {
            int endPosition = length;
            boolean completed = false;
            block3: while (!completed && endPosition > 0) {
                switch (sourceCode.charAt(endPosition - 1)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ';': {
                        --endPosition;
                        continue block3;
                    }
                }
                completed = true;
            }
            if (endPosition == length) {
                return sourceCode;
            }
            return sourceCode.substring(0, endPosition);
        }
        return null;
    }
}

