/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils.receivers;

import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import java.lang.reflect.Method;
import java.util.Arrays;

public interface IJavetCallbackReceiver {
    default public Method getMethod(String methodName) throws NoSuchMethodException {
        return this.getMethod(methodName, false, 0);
    }

    default public Method getMethod(String methodName, int argCount) throws NoSuchMethodException {
        return this.getMethod(methodName, false, argCount);
    }

    default public Method getMethod(String methodName, boolean thisObjectRequired) throws NoSuchMethodException {
        return this.getMethod(methodName, thisObjectRequired, 0);
    }

    default public Method getMethod(String methodName, boolean thisObjectRequired, int argCount) throws NoSuchMethodException {
        if (argCount < 0) {
            if (thisObjectRequired) {
                return this.getClass().getMethod(methodName, V8Value.class, V8Value[].class);
            }
            return this.getClass().getMethod(methodName, V8Value[].class);
        }
        if (argCount == 0) {
            if (thisObjectRequired) {
                return this.getClass().getMethod(methodName, V8Value.class);
            }
            return this.getClass().getMethod(methodName, new Class[0]);
        }
        Object[] classes = new Class[thisObjectRequired ? argCount + 1 : argCount];
        Arrays.fill(classes, V8Value.class);
        return this.getClass().getMethod(methodName, (Class<?>[])classes);
    }

    default public Method getMethod(String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return this.getClass().getMethod(methodName, parameterTypes);
    }

    default public Method getMethodVarargs(String methodName) throws NoSuchMethodException {
        return this.getMethod(methodName, false, -1);
    }

    default public Method getMethodVarargs(String methodName, boolean thisObjectRequired) throws NoSuchMethodException {
        return this.getMethod(methodName, thisObjectRequired, -1);
    }

    public V8Runtime getV8Runtime();
}

