/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.primitive;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.JavetDateTimeUtils;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import java.time.ZonedDateTime;
import java.util.Objects;

public final class V8ValueZonedDateTime
extends V8ValuePrimitive<ZonedDateTime> {
    public V8ValueZonedDateTime(V8Runtime v8Runtime) throws JavetException {
        this(v8Runtime, null);
    }

    public V8ValueZonedDateTime(V8Runtime v8Runtime, long jsTimestamp) throws JavetException {
        this(v8Runtime, JavetDateTimeUtils.toZonedDateTime(jsTimestamp));
    }

    public V8ValueZonedDateTime(V8Runtime v8Runtime, ZonedDateTime value) throws JavetException {
        super(v8Runtime, Objects.requireNonNull(value));
    }

    @Override
    public boolean asBoolean() {
        return this.value != null;
    }

    @Override
    public int asInt() throws JavetException {
        return this.asBoolean() ? 1 : 0;
    }

    public V8ValueZonedDateTime toClone(boolean referenceCopy) throws JavetException {
        return this;
    }

    public long toPrimitive() {
        return ((ZonedDateTime)this.value).toInstant().toEpochMilli();
    }
}

