/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ContextType;
import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8Context;
import com.caoccao.javet.values.reference.V8ValueReference;

public class V8Context
extends V8ValueReference
implements IV8Context {
    protected static final String ERROR_ELEMENT_LENGTH_MUST_BE_NON_NEGATIVE = "Element length must be non-negative.";

    V8Context(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    @Override
    public <T extends V8Value> T get(int index) throws JavetException {
        return this.checkV8Runtime().getV8Internal().contextGet(this, index);
    }

    @Override
    public int getLength() throws JavetException {
        return this.checkV8Runtime().getV8Internal().contextGetLength(this);
    }

    @Override
    public V8ValueReferenceType getType() {
        return V8ValueReferenceType.Context;
    }

    @Override
    public boolean isContextType(V8ContextType v8ContextType) throws JavetException {
        return this.checkV8Runtime().getV8Internal().contextIsContextType(this, v8ContextType.getId());
    }

    @Override
    public boolean setLength(int length) throws JavetException {
        assert (length >= 0) : "Element length must be non-negative.";
        return this.checkV8Runtime().getV8Internal().contextSetLength(this, length);
    }

    public V8Context toClone(boolean referenceCopy) throws JavetException {
        return this;
    }
}

