/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.units.Quantity;
import org.cts.units.Unit;

public class UnitConversion
extends AbstractCoordinateOperation {
    private Unit[] sourceUnits;
    private Unit[] targetUnits;
    private static final Map<String, UnitConversion> unitConverters = new HashMap<String, UnitConversion>();

    private UnitConversion(Unit[] sourceUnits, Unit[] targetUnits) {
        super(new Identifier(CoordinateOperation.class, sourceUnits[0].getName() + " to " + targetUnits[0].getName()));
        this.sourceUnits = sourceUnits;
        this.targetUnits = targetUnits;
    }

    private UnitConversion(Identifier identifier, Unit[] sourceUnits, Unit[] targetUnits) {
        super(identifier);
        this.sourceUnits = sourceUnits;
        this.targetUnits = targetUnits;
        unitConverters.put(Arrays.toString(sourceUnits) + Arrays.toString(targetUnits), this);
    }

    @Override
    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord == null || coord.length == 0) {
            throw new CoordinateDimensionException(Arrays.toString(coord) + " is an invalid coordinate");
        }
        int length = Math.min(coord.length, this.sourceUnits.length);
        for (int i2 = 0; i2 < length; ++i2) {
            if (Double.isNaN(coord[i2])) continue;
            coord[i2] = coord[i2] * this.sourceUnits[i2].getScale() / this.targetUnits[i2].getScale();
        }
        return coord;
    }

    @Override
    public CoordinateOperation inverse() {
        return new UnitConversion(this.targetUnits, this.sourceUnits);
    }

    public static UnitConversion createUnitConverter(Unit sourceUnit, Unit targetUnit) {
        if (sourceUnit.getQuantity().equals(Quantity.LENGTH)) {
            Identifier identifier = new Identifier(CoordinateOperation.class, sourceUnit.getName() + " to " + targetUnit.getName());
            String key = Arrays.toString(new Unit[]{sourceUnit, sourceUnit, sourceUnit}) + Arrays.toString(new Unit[]{targetUnit, targetUnit, targetUnit});
            if (unitConverters.containsKey(key)) {
                return unitConverters.get(key);
            }
            UnitConversion converter = new UnitConversion(identifier, new Unit[]{sourceUnit, sourceUnit, sourceUnit}, new Unit[]{targetUnit, targetUnit, targetUnit});
            unitConverters.put(key, converter);
            return converter;
        }
        if (sourceUnit.getQuantity().equals(Quantity.ANGLE)) {
            Identifier identifier = new Identifier(CoordinateOperation.class, sourceUnit.getName() + " to " + targetUnit.getName());
            String key = Arrays.toString(new Unit[]{sourceUnit, sourceUnit, Unit.METER}) + Arrays.toString(new Unit[]{targetUnit, targetUnit, Unit.METER});
            if (unitConverters.containsKey(key)) {
                return unitConverters.get(key);
            }
            UnitConversion converter = new UnitConversion(identifier, new Unit[]{sourceUnit, sourceUnit, Unit.METER}, new Unit[]{targetUnit, targetUnit, Unit.METER});
            unitConverters.put(key, converter);
            return converter;
        }
        throw new IllegalArgumentException("Source or target unit represents an unknown quantity : " + sourceUnit.getQuantity());
    }

    public static UnitConversion createUnitConverter(Unit planiSourceUnit, Unit planiTargetUnit, Unit altiSourceUnit, Unit altiTargetUnit) {
        Identifier identifier;
        if (planiSourceUnit.getQuantity().equals(Quantity.LENGTH)) {
            identifier = new Identifier(CoordinateOperation.class, planiSourceUnit.getName() + " to " + planiTargetUnit.getName());
        } else if (planiSourceUnit.getQuantity().equals(Quantity.ANGLE)) {
            identifier = new Identifier(CoordinateOperation.class, planiSourceUnit.getName() + " to " + planiTargetUnit.getName());
        } else {
            throw new IllegalArgumentException("Source or target unit represents an unknown quantity : " + planiSourceUnit.getQuantity());
        }
        String key = Arrays.toString(new Unit[]{planiSourceUnit, planiSourceUnit, altiSourceUnit}) + Arrays.toString(new Unit[]{planiTargetUnit, planiTargetUnit, altiTargetUnit});
        if (unitConverters.containsKey(key)) {
            return unitConverters.get(key);
        }
        UnitConversion converter = new UnitConversion(identifier, new Unit[]{planiSourceUnit, planiSourceUnit, altiSourceUnit}, new Unit[]{planiTargetUnit, planiTargetUnit, altiTargetUnit});
        unitConverters.put(key, converter);
        return converter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnitConversion) {
            UnitConversion converter = (UnitConversion)o;
            if (this.sourceUnits.length != converter.sourceUnits.length) {
                return false;
            }
            if (this.targetUnits.length != converter.targetUnits.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.sourceUnits.length; ++i2) {
                if (!this.sourceUnits[i2].equals(converter.sourceUnits[i2])) {
                    return false;
                }
                if (this.targetUnits[i2].equals(converter.targetUnits[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        for (Unit sourceUnit : this.sourceUnits) {
            hash += 13 * hash + sourceUnit.hashCode();
        }
        for (Unit targetUnit : this.targetUnits) {
            hash += 17 * hash + targetUnit.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isIdentity() {
        return Arrays.equals(this.sourceUnits, this.targetUnits);
    }
}

