/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

public class Krovak
extends Projection {
    public static final Identifier KROVAK = new Identifier("EPSG", "1041", "Krovak (North Orientated)", "KROVAK");
    protected final double lon0 = this.getCentralMeridian();
    protected final double FE;
    protected final double FN;
    protected final double alphac;
    protected final double latp;
    protected final double B;
    protected final double t0;
    protected final double n;
    protected final double r0;

    public Krovak(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(KROVAK, ellipsoid, parameters);
        double lat0 = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        this.alphac = this.getAzimuth();
        double kp = this.getScaleFactor();
        this.latp = 1.3700834628155485;
        double a = ellipsoid.getSemiMajorAxis();
        double e2 = ellipsoid.getSquareEccentricity();
        double e = ellipsoid.getEccentricity();
        double sin0 = Math.sin(lat0);
        double A2 = a * Math.sqrt(1.0 - e2) / (1.0 - e2 * sin0 * sin0);
        this.B = Math.sqrt(1.0 + e2 / (1.0 - e2) * Math.pow(Math.cos(lat0), 4.0));
        double gamma0 = Math.asin(sin0 / this.B);
        this.t0 = Math.tan((1.5707963267948966 + gamma0) / 2.0) * Math.pow(Math.pow((1.0 + e * sin0) / (1.0 - e * sin0), e / 2.0) / Math.tan((1.5707963267948966 + lat0) / 2.0), this.B);
        this.n = Math.sin(this.latp);
        this.r0 = kp * A2 / Math.tan(this.latp);
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CONICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.SECANT;
    }

    @Override
    public double[] transform(double[] coord) {
        double lat = coord[0];
        double lon = coord[1];
        double e = this.ellipsoid.getEccentricity();
        double esin = e * Math.sin(lat);
        double U = 2.0 * (Math.atan(this.t0 * Math.pow(Math.tan((1.5707963267948966 + lat) / 2.0) / Math.pow((1.0 + esin) / (1.0 - esin), e / 2.0), this.B)) - 0.7853981633974483);
        double V = this.B * (this.lon0 - lon);
        double T = Math.asin(Math.cos(this.alphac) * Math.sin(U) + Math.sin(this.alphac) * Math.cos(U) * Math.cos(V));
        double sinD = Math.cos(U) * Math.sin(V) / Math.cos(T);
        double cosD = (Math.cos(this.alphac) * Math.sin(T) - Math.sin(U)) / Math.sin(this.alphac) / Math.cos(T);
        double D = Math.atan2(sinD, cosD);
        double theta = this.n * D;
        double r = this.r0 * Math.pow(Math.tan((this.latp + 1.5707963267948966) / 2.0) / Math.tan((T + 1.5707963267948966) / 2.0), this.n);
        coord[0] = this.FE - r * Math.sin(theta);
        coord[1] = this.FN - r * Math.cos(theta);
        return coord;
    }

    @Override
    public Projection inverse() {
        return new Krovak(this.ellipsoid, this.parameters){

            @Override
            public double[] transform(double[] coord) {
                double Xp = -coord[1] + this.FN;
                double Yp = -coord[0] + this.FE;
                double r = Math.sqrt(Xp * Xp + Yp * Yp);
                double theta = Math.atan(Yp / Xp);
                double D = theta / Math.sin(this.latp);
                double T = 2.0 * (Math.atan(Math.pow(this.r0 / r, 1.0 / this.n) * Math.tan((this.latp + 1.5707963267948966) / 2.0)) - 0.7853981633974483);
                double U = Math.asin(Math.cos(this.alphac) * Math.sin(T) - Math.sin(this.alphac) * Math.cos(T) * Math.cos(D));
                double V = Math.asin(Math.cos(T) * Math.sin(D) / Math.cos(U));
                double oldLat = 1.0E30;
                double lat = U;
                int MAXITER = 10;
                double e = this.ellipsoid.getEccentricity();
                int iter = 0;
                while (++iter < 10 && Math.abs(lat - oldLat) > 1.0E-15) {
                    oldLat = lat;
                    lat = 2.0 * (Math.atan(Math.pow(Math.tan((U + 1.5707963267948966) / 2.0) / this.t0, 1.0 / this.B) * Math.pow((1.0 + e * Math.sin(lat)) / (1.0 - e * Math.sin(lat)), e / 2.0)) - 0.7853981633974483);
                }
                if (iter == 10) {
                    throw new ArithmeticException("The inverse method diverges");
                }
                double lon = this.lon0 - V / this.B;
                coord[0] = lat;
                coord[1] = lon;
                return coord;
            }

            @Override
            public Projection inverse() {
                return Krovak.this;
            }

            @Override
            public boolean isDirect() {
                return false;
            }

            @Override
            public String toString() {
                return Krovak.this.toString() + " inverse";
            }
        };
    }
}

