/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation.grid;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import org.cts.op.transformation.grid.GridShift;
import org.cts.op.transformation.grid.Util;

public class SubGrid
implements Cloneable,
Serializable {
    private static final int REC_SIZE = 16;
    private String subGridName;
    private String parentSubGridName;
    private String created;
    private String updated;
    private double minLat;
    private double maxLat;
    private double minLon;
    private double maxLon;
    private double latInterval;
    private double lonInterval;
    private int nodeCount;
    private int lonColumnCount;
    private int latRowCount;
    private float[] latShift;
    private float[] lonShift;
    private float[] latAccuracy;
    private float[] lonAccuracy;
    private final RandomAccessFile raf;
    private long subGridOffset;
    boolean bigEndian;
    private SubGrid[] subGrid;

    public SubGrid(InputStream in, boolean bigEndian, boolean loadAccuracy) throws IOException {
        this.raf = null;
        byte[] b8 = new byte[8];
        byte[] b4 = new byte[4];
        in.read(b8);
        in.read(b8);
        this.subGridName = new String(b8).trim();
        in.read(b8);
        in.read(b8);
        this.parentSubGridName = new String(b8).trim();
        in.read(b8);
        in.read(b8);
        this.created = new String(b8);
        in.read(b8);
        in.read(b8);
        this.updated = new String(b8);
        in.read(b8);
        in.read(b8);
        this.minLat = Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.maxLat = Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.minLon = Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.maxLon = Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.latInterval = Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.lonInterval = Util.getDouble(b8, bigEndian);
        this.lonColumnCount = 1 + (int)((this.maxLon - this.minLon) / this.lonInterval);
        this.latRowCount = 1 + (int)((this.maxLat - this.minLat) / this.latInterval);
        in.read(b8);
        in.read(b8);
        this.nodeCount = Util.getInt(b8, bigEndian);
        if (this.nodeCount != this.lonColumnCount * this.latRowCount) {
            throw new IllegalStateException("SubGrid " + this.subGridName + " has inconsistent grid dimesions");
        }
        this.latShift = new float[this.nodeCount];
        this.lonShift = new float[this.nodeCount];
        if (loadAccuracy) {
            this.latAccuracy = new float[this.nodeCount];
            this.lonAccuracy = new float[this.nodeCount];
        }
        for (int i2 = 0; i2 < this.nodeCount; ++i2) {
            in.read(b4);
            this.latShift[i2] = Util.getFloat(b4, bigEndian);
            in.read(b4);
            this.lonShift[i2] = Util.getFloat(b4, bigEndian);
            in.read(b4);
            if (loadAccuracy) {
                this.latAccuracy[i2] = Util.getFloat(b4, bigEndian);
            }
            in.read(b4);
            if (!loadAccuracy) continue;
            this.lonAccuracy[i2] = Util.getFloat(b4, bigEndian);
        }
    }

    public SubGrid(RandomAccessFile raf, long subGridOffset, boolean bigEndian) throws IOException {
        this.raf = raf;
        this.subGridOffset = subGridOffset;
        this.bigEndian = bigEndian;
        raf.seek(subGridOffset);
        byte[] b8 = new byte[8];
        raf.read(b8);
        raf.read(b8);
        this.subGridName = new String(b8).trim();
        raf.read(b8);
        raf.read(b8);
        this.parentSubGridName = new String(b8).trim();
        raf.read(b8);
        raf.read(b8);
        this.created = new String(b8);
        raf.read(b8);
        raf.read(b8);
        this.updated = new String(b8);
        raf.read(b8);
        raf.read(b8);
        this.minLat = Util.getDouble(b8, bigEndian);
        raf.read(b8);
        raf.read(b8);
        this.maxLat = Util.getDouble(b8, bigEndian);
        raf.read(b8);
        raf.read(b8);
        this.minLon = Util.getDouble(b8, bigEndian);
        raf.read(b8);
        raf.read(b8);
        this.maxLon = Util.getDouble(b8, bigEndian);
        raf.read(b8);
        raf.read(b8);
        this.latInterval = Util.getDouble(b8, bigEndian);
        raf.read(b8);
        raf.read(b8);
        this.lonInterval = Util.getDouble(b8, bigEndian);
        this.lonColumnCount = 1 + (int)((this.maxLon - this.minLon) / this.lonInterval);
        this.latRowCount = 1 + (int)((this.maxLat - this.minLat) / this.latInterval);
        raf.read(b8);
        raf.read(b8);
        this.nodeCount = Util.getInt(b8, bigEndian);
        if (this.nodeCount != this.lonColumnCount * this.latRowCount) {
            throw new IllegalStateException("SubGrid " + this.subGridName + " has inconsistent grid dimesions");
        }
    }

    public SubGrid getSubGridForCoord(double lon, double lat) {
        if (this.isCoordWithin(lon, lat)) {
            if (this.subGrid == null) {
                return this;
            }
            for (SubGrid aSubGrid : this.subGrid) {
                if (!aSubGrid.isCoordWithin(lon, lat)) continue;
                return aSubGrid.getSubGridForCoord(lon, lat);
            }
            return this;
        }
        return null;
    }

    private boolean isCoordWithin(double lon, double lat) {
        return lon >= this.minLon && lon < this.maxLon && lat >= this.minLat && lat < this.maxLat;
    }

    private double interpolate(float a, float b, float c, float d, double X2, double Y) {
        return (double)a + (double)(b - a) * X2 + (double)(c - a) * Y + (double)(a + d - b - c) * X2 * Y;
    }

    public GridShift interpolateGridShift(GridShift gs) throws IOException {
        int lonIndex = (int)((gs.getLonPositiveWestSeconds() - this.minLon) / this.lonInterval);
        int latIndex = (int)((gs.getLatSeconds() - this.minLat) / this.latInterval);
        double X2 = (gs.getLonPositiveWestSeconds() - (this.minLon + this.lonInterval * (double)lonIndex)) / this.lonInterval;
        double Y = (gs.getLatSeconds() - (this.minLat + this.latInterval * (double)latIndex)) / this.latInterval;
        int indexA = lonIndex + latIndex * this.lonColumnCount;
        int indexB = indexA + 1;
        int indexC = indexA + this.lonColumnCount;
        int indexD = indexC + 1;
        if (this.raf == null) {
            gs.setLonShiftPositiveWestSeconds(this.interpolate(this.lonShift[indexA], this.lonShift[indexB], this.lonShift[indexC], this.lonShift[indexD], X2, Y));
            gs.setLatShiftSeconds(this.interpolate(this.latShift[indexA], this.latShift[indexB], this.latShift[indexC], this.latShift[indexD], X2, Y));
            if (this.lonAccuracy == null) {
                gs.setLonAccuracyAvailable(false);
            } else {
                gs.setLonAccuracyAvailable(true);
                gs.setLonAccuracySeconds(this.interpolate(this.lonAccuracy[indexA], this.lonAccuracy[indexB], this.lonAccuracy[indexC], this.lonAccuracy[indexD], X2, Y));
            }
            if (this.latAccuracy == null) {
                gs.setLatAccuracyAvailable(false);
            } else {
                gs.setLatAccuracyAvailable(true);
                gs.setLatAccuracySeconds(this.interpolate(this.latAccuracy[indexA], this.latAccuracy[indexB], this.latAccuracy[indexC], this.latAccuracy[indexD], X2, Y));
            }
        } else {
            byte[] b4 = new byte[4];
            long nodeOffset = this.subGridOffset + 176L + (long)(indexA * 16);
            this.raf.seek(nodeOffset);
            this.raf.read(b4);
            float latShiftA = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float lonShiftA = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float latAccuracyA = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float lonAccuracyA = Util.getFloat(b4, this.bigEndian);
            nodeOffset = this.subGridOffset + 176L + (long)(indexB * 16);
            this.raf.seek(nodeOffset);
            this.raf.read(b4);
            float latShiftB = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float lonShiftB = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float latAccuracyB = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float lonAccuracyB = Util.getFloat(b4, this.bigEndian);
            nodeOffset = this.subGridOffset + 176L + (long)(indexC * 16);
            this.raf.seek(nodeOffset);
            this.raf.read(b4);
            float latShiftC = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float lonShiftC = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float latAccuracyC = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float lonAccuracyC = Util.getFloat(b4, this.bigEndian);
            nodeOffset = this.subGridOffset + 176L + (long)(indexD * 16);
            this.raf.seek(nodeOffset);
            this.raf.read(b4);
            float latShiftD = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float lonShiftD = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float latAccuracyD = Util.getFloat(b4, this.bigEndian);
            this.raf.read(b4);
            float lonAccuracyD = Util.getFloat(b4, this.bigEndian);
            gs.setLonShiftPositiveWestSeconds(this.interpolate(lonShiftA, lonShiftB, lonShiftC, lonShiftD, X2, Y));
            gs.setLatShiftSeconds(this.interpolate(latShiftA, latShiftB, latShiftC, latShiftD, X2, Y));
            gs.setLonAccuracyAvailable(true);
            gs.setLonAccuracySeconds(this.interpolate(lonAccuracyA, lonAccuracyB, lonAccuracyC, lonAccuracyD, X2, Y));
            gs.setLatAccuracyAvailable(true);
            gs.setLatAccuracySeconds(this.interpolate(latAccuracyA, latAccuracyB, latAccuracyC, latAccuracyD, X2, Y));
        }
        return gs;
    }

    public String getParentSubGridName() {
        return this.parentSubGridName;
    }

    public String getSubGridName() {
        return this.subGridName;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getSubGridCount() {
        return this.subGrid == null ? 0 : this.subGrid.length;
    }

    public SubGrid getSubGrid(int index) {
        return this.subGrid == null ? null : this.subGrid[index];
    }

    public void setSubGridArray(SubGrid[] subGrid) {
        this.subGrid = subGrid;
    }

    public String toString() {
        return this.subGridName;
    }

    public String getDetails() {
        return "Sub Grid : " + this.subGridName + "\nParent   : " + this.parentSubGridName + "\nCreated  : " + this.created + "\nUpdated  : " + this.updated + "\nMin Lat  : " + this.minLat + "\nMax Lat  : " + this.maxLat + "\nMin Lon  : " + this.minLon + "\nMax Lon  : " + this.maxLon + "\nLat Intvl: " + this.latInterval + "\nLon Intvl: " + this.lonInterval + "\nNode Cnt : " + this.nodeCount;
    }

    public Object clone() {
        SubGrid clone = null;
        try {
            clone = (SubGrid)super.clone();
            if (this.subGrid != null) {
                clone.subGrid = new SubGrid[this.subGrid.length];
                for (int i2 = 0; i2 < this.subGrid.length; ++i2) {
                    clone.subGrid[i2] = (SubGrid)this.subGrid[i2].clone();
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }
}

