/*
 * Decompiled with CFR 0.152.
 */
package org.cts.parser.proj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.cts.parser.proj.ProjKeyParameters;
import org.cts.registry.Registry;

public class ProjParser {
    private final Registry registry;

    public ProjParser(Registry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> readParameters(String crsCode, Pattern regexPattern) throws IOException {
        Map<String, String> args;
        InputStream inStr = Registry.class.getResourceAsStream(this.registry.getRegistryName());
        if (inStr == null) {
            throw new IllegalStateException("Unable to access CRS file: " + this.registry.getRegistryName());
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inStr));){
            args = this.readRegistry(reader, crsCode, regexPattern);
        }
        return args;
    }

    private Map<String, String> readRegistry(BufferedReader br, String nameOfCRS, Pattern regex) throws IOException {
        Object line;
        String crsName = null;
        while (null != (line = br.readLine())) {
            if (((String)line).startsWith("#")) {
                crsName = ((String)line).substring(1).trim();
                continue;
            }
            if (!((String)line).startsWith("<")) continue;
            while (!((String)line).endsWith(">")) {
                int i2 = ((String)line).indexOf(35);
                if (i2 != -1) {
                    crsName = ((String)line).substring(i2 + 2);
                    line = ((String)line).substring(0, i2 - 1);
                }
                line = (String)line + " " + br.readLine();
            }
            String[] tokens = regex.split((CharSequence)line);
            HashMap<String, String> v = new HashMap<String, String>();
            boolean crsFound = true;
            for (String token : tokens) {
                String key;
                if (token.startsWith("<") && token.endsWith(">") && token.length() > 2) {
                    String crsID = token.substring(1, token.length() - 1);
                    if (crsID.equalsIgnoreCase(nameOfCRS)) continue;
                    crsFound = false;
                    crsName = null;
                    break;
                }
                if (token.equals("<>")) break;
                String[] keyValue = token.split("=");
                if (keyValue.length == 2) {
                    key = ProjParser.formatKey(keyValue[0]);
                    ProjKeyParameters.checkUnsupported(key);
                    v.put(key, keyValue[1]);
                    continue;
                }
                key = ProjParser.formatKey(token);
                ProjKeyParameters.checkUnsupported(key);
                if (key.equals("wktext")) {
                    String[] lines = regex.split((CharSequence)line, 2);
                    v.put(key, lines[1]);
                    continue;
                }
                v.put(key, null);
            }
            if (!crsFound) continue;
            if (!v.containsKey("title") && crsName != null) {
                v.put("title", crsName);
            }
            return v;
        }
        return null;
    }

    private static String formatKey(String key) {
        String formatKey = key;
        if (key.startsWith("+")) {
            formatKey = key.substring(1);
        }
        return formatKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSupportedCodes(Pattern regex) throws IOException {
        InputStream inStr = Registry.class.getResourceAsStream(this.registry.getRegistryName());
        if (inStr == null) {
            throw new IllegalStateException("Unable to access CRS file: " + this.registry.getRegistryName());
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inStr));){
            String line;
            HashSet<String> codes = new HashSet<String>();
            while (null != (line = br.readLine())) {
                if (!line.startsWith("<")) continue;
                String token = regex.split(line, 2)[0];
                codes.add(token.substring(1, token.length() - 1));
            }
            HashSet<String> hashSet = codes;
            return hashSet;
        }
    }
}

