/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileUtilities {
    public static boolean deleteFiles(File directory) throws IOException {
        return FileUtilities.deleteFiles(directory, false);
    }

    public static boolean deleteFiles(File directory, boolean delete) throws IOException {
        if (directory == null) {
            throw new IOException("The directory cannot be null");
        }
        if (!directory.isDirectory()) {
            throw new IOException("The input path must be a directory");
        }
        Path pathToBeDeleted = directory.toPath();
        try (Stream<Path> walk = Files.walk(pathToBeDeleted, new FileVisitOption[0]);){
            if (delete) {
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            } else {
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).filter(item -> !item.toPath().equals(pathToBeDeleted)).forEach(File::delete);
            }
        }
        return Files.exists(pathToBeDeleted, new LinkOption[0]);
    }

    public static List<String> listFiles(File directory, String extension) throws IOException {
        if (directory == null) {
            throw new IOException("The directory cannot be null");
        }
        if (!directory.isDirectory()) {
            throw new IOException("The input path must be a directory");
        }
        if (extension == null || extension.isEmpty()) {
            throw new IOException("The file extension cannot be null or empty");
        }
        Path pathToBeDeleted = directory.toPath();
        ArrayList<String> result = new ArrayList();
        try (Stream<Path> walk = Files.walk(pathToBeDeleted, new FileVisitOption[0]);){
            result = walk.map(x -> x.toAbsolutePath().toString()).filter(f -> f.toLowerCase().endsWith("." + extension)).collect(Collectors.toList());
        }
        return result;
    }

    public static List<String> listFiles(File directory) throws IOException {
        if (directory == null) {
            throw new IOException("The directory cannot be null");
        }
        if (!directory.isDirectory()) {
            throw new IOException("The input path must be a directory");
        }
        Path pathToBeDeleted = directory.toPath();
        ArrayList<String> result = new ArrayList();
        try (Stream<Path> walk = Files.walk(pathToBeDeleted, new FileVisitOption[0]);){
            result = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(x -> x.toAbsolutePath().toString()).collect(Collectors.toList());
        }
        return result;
    }

    public static void unzip(File zipFile) throws IOException {
        String fileName;
        String withoutExtension;
        Path parentDir = zipFile.toPath().getParent();
        File targetDir = parentDir.resolve(withoutExtension = (fileName = zipFile.getName()).substring(0, fileName.lastIndexOf(".")).replace(".", "_")).toFile();
        if (!targetDir.exists()) {
            targetDir.mkdir();
        }
        FileUtilities.unzip(zipFile, targetDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File directory) throws IOException {
        if (directory == null) {
            throw new IOException("The directory cannot be null");
        }
        if (!directory.isDirectory()) {
            throw new IOException("The input path must be a directory");
        }
        if (zipFile == null) {
            throw new IOException("The file to zip cannot be null");
        }
        if (!zipFile.exists()) {
            throw new IOException("The file to zip cannot doesn't exist");
        }
        if (!FileUtilities.isExtensionWellFormated(zipFile, "zip")) {
            throw new IOException("The extension of the file to zip must be .zip");
        }
        if (zipFile.equals(directory)) {
            throw new IOException("The destination file must be different than the zip file");
        }
        try (ZipInputStream zis = null;){
            byte[] buffer = new byte[1024];
            zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = FileUtilities.newFile(directory, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    int len;
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
        }
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target directory: " + zipEntry.getName());
        }
        return destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File[] filesToZip, File outFile) throws IOException {
        if (filesToZip == null) {
            throw new IOException("The file to zip cannot be null");
        }
        if (outFile == null) {
            throw new IOException("The destination file to zip cannot be null");
        }
        if (outFile.exists()) {
            throw new IOException("The destination file to zip already exist");
        }
        if (!FileUtilities.isExtensionWellFormated(outFile, "zip")) {
            throw new IOException("The extension of the file to zip must be .zip");
        }
        try (ZipOutputStream out = null;){
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            int BUF_SIZE = 65536;
            byte[] data = new byte[BUF_SIZE];
            for (File file : filesToZip) {
                if (!file.exists()) continue;
                try (BufferedInputStream in = null;){
                    in = new BufferedInputStream(new FileInputStream(file), BUF_SIZE);
                    out.putNextEntry(new ZipEntry(file.getName()));
                    int count = in.read(data, 0, BUF_SIZE);
                    while (count != -1) {
                        out.write(data, 0, count);
                        count = in.read(data, 0, BUF_SIZE);
                    }
                    out.closeEntry();
                }
            }
            out.flush();
        }
    }

    public static void zip(File toZip) throws IOException {
        Path parentDir = toZip.toPath().getParent();
        String fileName = toZip.getName();
        int lastIndex = fileName.lastIndexOf(".");
        if (lastIndex != -1) {
            fileName = fileName.substring(0, lastIndex).replace(".", "_");
        }
        Path targetDir = parentDir.resolve(fileName + ".zip");
        FileUtilities.zip(toZip, targetDir.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File toZip, File outFile) throws IOException {
        if (toZip == null || !toZip.exists()) {
            throw new IOException("The file to zip cannot be null");
        }
        if (!toZip.exists()) {
            throw new IOException("The file to zip cannot doesn't exist");
        }
        if (outFile == null) {
            throw new IOException("The destination file to zip cannot be null");
        }
        if (outFile.exists()) {
            throw new IOException("The destination file to zip already exist");
        }
        if (!FileUtilities.isExtensionWellFormated(outFile, "zip")) {
            throw new IOException("The extension of the file to zip must be .zip");
        }
        if (toZip.equals(outFile)) {
            throw new IOException("The destination file must be different than the input file");
        }
        try (ZipOutputStream out = null;){
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            int BUF_SIZE = 65536;
            byte[] data = new byte[BUF_SIZE];
            ArrayList<File> listToZip = new ArrayList<File>();
            listToZip.add(toZip);
            while (listToZip.size() > 0) {
                File file = (File)listToZip.remove(0);
                if (file.isDirectory()) {
                    File[] children = file.listFiles();
                    if (children == null) continue;
                    listToZip.addAll(Arrays.asList(children));
                    continue;
                }
                BufferedInputStream in = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(file), BUF_SIZE);
                    out.putNextEntry(new ZipEntry(FileUtilities.getRelativePath(toZip, file)));
                    int count = in.read(data, 0, BUF_SIZE);
                    while (count != -1) {
                        out.write(data, 0, count);
                        count = in.read(data, 0, BUF_SIZE);
                    }
                    out.closeEntry();
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            out.flush();
        }
    }

    public static String getRelativePath(File base, File file) {
        String absolutePath = file.getAbsolutePath();
        String path = absolutePath.substring(base.getAbsolutePath().length());
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static boolean isFileImportable(File file, String prefix) throws SQLException, FileNotFoundException {
        if (FileUtilities.isExtensionWellFormated(file, prefix)) {
            if (file.exists()) {
                return true;
            }
            throw new FileNotFoundException("The following file does not exists:\n" + file.getPath());
        }
        throw new SQLException("Please use " + prefix + " extension.");
    }

    public static boolean isExtensionWellFormated(File file, String prefix) {
        String path = file.getAbsolutePath();
        String extension = "";
        int i2 = path.lastIndexOf(46);
        if (i2 >= 0) {
            extension = path.substring(i2 + 1);
        }
        return extension.equalsIgnoreCase(prefix);
    }
}

