/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.cts.util.UTMUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class GeographyUtilities {
    public static final double RADIUS_OF_EARTH_IN_METERS = 6378137.0;

    public static Envelope createEnvelope(Coordinate point, double dx, double dy) {
        if (dx == 0.0 || dy == 0.0) {
            return null;
        }
        if (dx < 0.0 || dy < 0.0) {
            throw new IllegalArgumentException("Create operation does not accept negative value");
        }
        double pLat = point.getY();
        double pLon = point.getX();
        if (!UTMUtils.isValidLatitude((float)pLat)) {
            throw new IllegalArgumentException("Invalid latitude" + pLat);
        }
        if (!UTMUtils.isValidLatitude((float)pLon)) {
            throw new IllegalArgumentException("Invalid longitude" + pLon);
        }
        double dLat = GeographyUtilities.computeLatitudeDistance(dy);
        double dLon = GeographyUtilities.computeLongitudeDistance(dx, pLat);
        return new Envelope(Math.max(-180.0, pLon), Math.min(180.0, pLon + dLon), Math.max(-90.0, pLat), Math.min(90.0, pLat + dLat));
    }

    public static Envelope createEnvelope(Coordinate point, double dx, double dy, int quadrant) {
        if (dx == 0.0 || dy == 0.0) {
            return null;
        }
        if (dx < 0.0 || dy < 0.0) {
            throw new IllegalArgumentException("Create operation does not accept negative value");
        }
        if (quadrant < 1 || quadrant > 4) {
            throw new IllegalArgumentException("Quadrant must range in [1,4] interval");
        }
        double pLat = point.getY();
        double pLon = point.getX();
        if (!UTMUtils.isValidLatitude((float)pLat)) {
            throw new IllegalArgumentException("Invalid latitude: " + pLat);
        }
        if (!UTMUtils.isValidLatitude((float)pLon)) {
            throw new IllegalArgumentException("Invalid longitude: " + pLon);
        }
        double dLat = GeographyUtilities.computeLatitudeDistance(dy);
        double dLon = GeographyUtilities.computeLongitudeDistance(dx, pLat);
        switch (quadrant) {
            case 1: {
                return new Envelope(Math.max(-180.0, pLon), Math.min(180.0, pLon + dLon), Math.max(-90.0, pLat), Math.min(90.0, pLat + dLat));
            }
            case 2: {
                return new Envelope(Math.max(-180.0, pLon - dLon), Math.min(180.0, pLon), Math.max(-90.0, pLat), Math.min(90.0, pLat + dLat));
            }
            case 3: {
                return new Envelope(Math.max(-180.0, pLon - dLon), Math.min(180.0, pLon), Math.max(-90.0, pLat - dLat), Math.min(90.0, pLat));
            }
            case 4: {
                return new Envelope(Math.max(-180.0, pLon), Math.min(180.0, pLon + dLon), Math.max(-90.0, pLat - dLat), Math.min(90.0, pLat));
            }
        }
        throw new IllegalArgumentException("Invalid quadrant argument: " + quadrant);
    }

    public static Envelope expandEnvelopeByMeters(Envelope envelope, double distance) {
        if (envelope.isNull()) {
            return null;
        }
        if (distance == 0.0) {
            return envelope;
        }
        if (distance < 0.0) {
            throw new IllegalArgumentException("Extend operation does not accept negative value");
        }
        double minLon = envelope.getMinX();
        double maxLon = envelope.getMaxX();
        double maxLat = envelope.getMaxY();
        double minLat = envelope.getMinY();
        if (!UTMUtils.isValidLatitude((float)minLat)) {
            throw new IllegalArgumentException("Invalid min latitude");
        }
        if (!UTMUtils.isValidLatitude((float)maxLat)) {
            throw new IllegalArgumentException("Invalid max latitude");
        }
        if (!UTMUtils.isValidLongitude((float)minLon)) {
            throw new IllegalArgumentException("Invalid min longitude");
        }
        if (!UTMUtils.isValidLongitude((float)maxLon)) {
            throw new IllegalArgumentException("Invalid max longitude");
        }
        double verticalExpansion = GeographyUtilities.computeLatitudeDistance(distance);
        double horizontalExpansion = GeographyUtilities.computeLongitudeDistance(distance, Math.max(Math.abs(minLat), Math.abs(maxLat)));
        return new Envelope(Math.max(-180.0, minLon - horizontalExpansion), Math.min(180.0, maxLon + horizontalExpansion), Math.max(-90.0, minLat - verticalExpansion), Math.min(90.0, maxLat + verticalExpansion));
    }

    public static double computeLatitudeDistance(double meters) {
        return meters * 360.0 / 4.007501668557849E7;
    }

    public static double computeLongitudeDistance(double meters, double latitude) {
        return meters * 360.0 / (4.007501668557849E7 * Math.cos(Math.toRadians(latitude)));
    }

    public static double getHaversineDistanceInMeters(Coordinate coordA, Coordinate coordB) {
        double dLat = Math.toRadians(coordB.getY() - coordA.getY());
        double dLon = Math.toRadians(coordB.getX() - coordA.getX());
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(coordA.getY())) * Math.cos(Math.toRadians(coordB.getY())) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double d = 6378137.0 * c;
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSRID(Connection connection, float latitude, float longitude) throws SQLException {
        int srid = -1;
        ps.setString(1, UTMUtils.getProj(latitude, longitude));
        try (PreparedStatement ps = connection.prepareStatement("select SRID from PUBLIC.SPATIAL_REF_SYS where PROJ4TEXT = ?");
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                srid = rs.getInt(1);
            }
        }
        return srid;
    }
}

