/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.math.MathUtil;

public class Distance {
    public static double segmentToSegment(Coordinate A2, Coordinate B, Coordinate C, Coordinate D) {
        if (A2.equals(B)) {
            return Distance.pointToSegment(A2, C, D);
        }
        if (C.equals(D)) {
            return Distance.pointToSegment(D, A2, B);
        }
        boolean noIntersection = false;
        if (!Envelope.intersects(A2, B, C, D)) {
            noIntersection = true;
        } else {
            double denom = (B.x - A2.x) * (D.y - C.y) - (B.y - A2.y) * (D.x - C.x);
            if (denom == 0.0) {
                noIntersection = true;
            } else {
                double r_num = (A2.y - C.y) * (D.x - C.x) - (A2.x - C.x) * (D.y - C.y);
                double s_num = (A2.y - C.y) * (B.x - A2.x) - (A2.x - C.x) * (B.y - A2.y);
                double s = s_num / denom;
                double r = r_num / denom;
                if (r < 0.0 || r > 1.0 || s < 0.0 || s > 1.0) {
                    noIntersection = true;
                }
            }
        }
        if (noIntersection) {
            return MathUtil.min(Distance.pointToSegment(A2, C, D), Distance.pointToSegment(B, C, D), Distance.pointToSegment(C, A2, B), Distance.pointToSegment(D, A2, B));
        }
        return 0.0;
    }

    public static double pointToSegmentString(Coordinate p, Coordinate[] line) {
        if (line.length == 0) {
            throw new IllegalArgumentException("Line array must contain at least one vertex");
        }
        double minDistance = p.distance(line[0]);
        for (int i2 = 0; i2 < line.length - 1; ++i2) {
            double dist = Distance.pointToSegment(p, line[i2], line[i2 + 1]);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    public static double pointToSegment(Coordinate p, Coordinate A2, Coordinate B) {
        if (A2.x == B.x && A2.y == B.y) {
            return p.distance(A2);
        }
        double len2 = (B.x - A2.x) * (B.x - A2.x) + (B.y - A2.y) * (B.y - A2.y);
        double r = ((p.x - A2.x) * (B.x - A2.x) + (p.y - A2.y) * (B.y - A2.y)) / len2;
        if (r <= 0.0) {
            return p.distance(A2);
        }
        if (r >= 1.0) {
            return p.distance(B);
        }
        double s = ((A2.y - p.y) * (B.x - A2.x) - (A2.x - p.x) * (B.y - A2.y)) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }

    public static double pointToLinePerpendicular(Coordinate p, Coordinate A2, Coordinate B) {
        double len2 = (B.x - A2.x) * (B.x - A2.x) + (B.y - A2.y) * (B.y - A2.y);
        double s = ((A2.y - p.y) * (B.x - A2.x) - (A2.x - p.x) * (B.y - A2.y)) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }

    public static double pointToLinePerpendicularSigned(Coordinate p, Coordinate A2, Coordinate B) {
        double len2 = (B.x - A2.x) * (B.x - A2.x) + (B.y - A2.y) * (B.y - A2.y);
        double s = ((A2.y - p.y) * (B.x - A2.x) - (A2.x - p.x) * (B.y - A2.y)) / len2;
        return s * Math.sqrt(len2);
    }
}

