/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.awt;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;

public class PolygonShape
implements Shape {
    private GeneralPath polygonPath;
    private GeneralPath ringPath;

    public PolygonShape(Coordinate[] shellVertices, Collection holeVerticesCollection) {
        this.polygonPath = this.toPath(shellVertices);
        for (Coordinate[] holeVertices : holeVerticesCollection) {
            this.polygonPath.append(this.toPath(holeVertices), false);
        }
    }

    public PolygonShape() {
    }

    void addToRing(Point2D p) {
        if (this.ringPath == null) {
            this.ringPath = new GeneralPath(0);
            this.ringPath.moveTo((float)p.getX(), (float)p.getY());
        } else {
            this.ringPath.lineTo((float)p.getX(), (float)p.getY());
        }
    }

    void endRing() {
        this.ringPath.closePath();
        if (this.polygonPath == null) {
            this.polygonPath = this.ringPath;
        } else {
            this.polygonPath.append(this.ringPath, false);
        }
        this.ringPath = null;
    }

    private GeneralPath toPath(Coordinate[] coordinates) {
        GeneralPath path = new GeneralPath(0, coordinates.length);
        if (coordinates.length > 0) {
            path.moveTo((float)coordinates[0].x, (float)coordinates[0].y);
            for (int i2 = 0; i2 < coordinates.length; ++i2) {
                path.lineTo((float)coordinates[i2].x, (float)coordinates[i2].y);
            }
        }
        return path;
    }

    @Override
    public Rectangle getBounds() {
        return this.polygonPath.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.polygonPath.getBounds2D();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.polygonPath.contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.polygonPath.contains(p);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.polygonPath.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.polygonPath.intersects(r);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.polygonPath.contains(x, y, w, h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.polygonPath.contains(r);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.polygonPath.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.polygonPath.getPathIterator(at, flatness);
    }
}

