/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.coverage;

import java.util.List;
import org.locationtech.jts.coverage.CornerArea;
import org.locationtech.jts.coverage.CoverageEdge;
import org.locationtech.jts.coverage.CoverageRingEdges;
import org.locationtech.jts.coverage.TPVWSimplifier;
import org.locationtech.jts.geom.Geometry;

public class CoverageSimplifier {
    private Geometry[] coverage;
    private double smoothWeight = 0.0;
    private double removableSizeFactor = 1.0;

    public static Geometry[] simplify(Geometry[] coverage, double tolerance) {
        CoverageSimplifier simplifier = new CoverageSimplifier(coverage);
        return simplifier.simplify(tolerance);
    }

    public static Geometry[] simplify(Geometry[] coverage, double[] tolerances) {
        CoverageSimplifier simplifier = new CoverageSimplifier(coverage);
        return simplifier.simplify(tolerances);
    }

    public static Geometry[] simplifyInner(Geometry[] coverage, double tolerance) {
        CoverageSimplifier simplifier = new CoverageSimplifier(coverage);
        return simplifier.simplify(tolerance, 0.0);
    }

    public static Geometry[] simplifyOuter(Geometry[] coverage, double tolerance) {
        CoverageSimplifier simplifier = new CoverageSimplifier(coverage);
        return simplifier.simplify(0.0, tolerance);
    }

    public CoverageSimplifier(Geometry[] coverage) {
        this.coverage = coverage;
    }

    public void setRemovableRingSizeFactor(double removableSizeFactor) {
        double factor = removableSizeFactor;
        if (factor < 0.0) {
            factor = 0.0;
        }
        this.removableSizeFactor = factor;
    }

    public void setSmoothWeight(double smoothWeight) {
        if (smoothWeight < 0.0 || smoothWeight > 1.0) {
            throw new IllegalArgumentException("smoothWeight must be in range [0 - 1]");
        }
        this.smoothWeight = smoothWeight;
    }

    public Geometry[] simplify(double tolerance) {
        return this.simplifyEdges(tolerance, tolerance);
    }

    public Geometry[] simplify(double toleranceInner, double toleranceOuter) {
        return this.simplifyEdges(toleranceInner, toleranceOuter);
    }

    public Geometry[] simplify(double[] tolerances) {
        if (tolerances.length != this.coverage.length) {
            throw new IllegalArgumentException("number of tolerances does not match number of coverage elements");
        }
        return this.simplifyEdges(tolerances);
    }

    private Geometry[] simplifyEdges(double[] tolerances) {
        CoverageRingEdges covRings = CoverageRingEdges.create(this.coverage);
        List<CoverageEdge> covEdges = covRings.getEdges();
        TPVWSimplifier.Edge[] edges = this.createEdges(covEdges, tolerances);
        return this.simplify(covRings, covEdges, edges);
    }

    private TPVWSimplifier.Edge[] createEdges(List<CoverageEdge> covEdges, double[] tolerances) {
        TPVWSimplifier.Edge[] edges = new TPVWSimplifier.Edge[covEdges.size()];
        for (int i2 = 0; i2 < covEdges.size(); ++i2) {
            CoverageEdge covEdge = covEdges.get(i2);
            double tol = this.computeTolerance(covEdge, tolerances);
            edges[i2] = CoverageSimplifier.createEdge(covEdge, tol);
        }
        return edges;
    }

    private double computeTolerance(CoverageEdge covEdge, double[] tolerances) {
        int index1;
        double tol1;
        int index0 = covEdge.getAdjacentIndex(0);
        double tolerance = tolerances[index0];
        if (covEdge.hasAdjacentIndex(1) && (tol1 = tolerances[index1 = covEdge.getAdjacentIndex(1)]) < tolerance) {
            tolerance = tol1;
        }
        return tolerance;
    }

    private Geometry[] simplifyEdges(double toleranceInner, double toleranceOuter) {
        CoverageRingEdges covRings = CoverageRingEdges.create(this.coverage);
        List<CoverageEdge> covEdges = covRings.getEdges();
        TPVWSimplifier.Edge[] edges = CoverageSimplifier.createEdges(covEdges, toleranceInner, toleranceOuter);
        return this.simplify(covRings, covEdges, edges);
    }

    private Geometry[] simplify(CoverageRingEdges covRings, List<CoverageEdge> covEdges, TPVWSimplifier.Edge[] edges) {
        CornerArea cornerArea = new CornerArea(this.smoothWeight);
        TPVWSimplifier.simplify(edges, cornerArea, this.removableSizeFactor);
        this.setCoordinates(covEdges, edges);
        Geometry[] result = covRings.buildCoverage();
        return result;
    }

    private static TPVWSimplifier.Edge[] createEdges(List<CoverageEdge> covEdges, double toleranceInner, double toleranceOuter) {
        TPVWSimplifier.Edge[] edges = new TPVWSimplifier.Edge[covEdges.size()];
        for (int i2 = 0; i2 < covEdges.size(); ++i2) {
            CoverageEdge covEdge = covEdges.get(i2);
            double tol = CoverageSimplifier.computeTolerance(covEdge, toleranceInner, toleranceOuter);
            edges[i2] = CoverageSimplifier.createEdge(covEdge, tol);
        }
        return edges;
    }

    private static TPVWSimplifier.Edge createEdge(CoverageEdge covEdge, double tol) {
        return new TPVWSimplifier.Edge(covEdge.getCoordinates(), tol, covEdge.isFreeRing(), covEdge.isRemovableRing());
    }

    private static double computeTolerance(CoverageEdge covEdge, double toleranceInner, double toleranceOuter) {
        return covEdge.isInner() ? toleranceInner : toleranceOuter;
    }

    private void setCoordinates(List<CoverageEdge> covEdges, TPVWSimplifier.Edge[] edges) {
        for (int i2 = 0; i2 < covEdges.size(); ++i2) {
            TPVWSimplifier.Edge edge = edges[i2];
            if (!(edge.getTolerance() > 0.0)) continue;
            covEdges.get(i2).setCoordinates(edges[i2].getCoordinates());
        }
    }
}

