/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.coverage;

import java.util.List;
import org.locationtech.jts.coverage.CoveragePolygonValidator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.index.strtree.STRtree;

public class CoverageValidator {
    private Geometry[] coverage;
    private double gapWidth;

    public static boolean isValid(Geometry[] coverage) {
        CoverageValidator v = new CoverageValidator(coverage);
        return !CoverageValidator.hasInvalidResult(v.validate());
    }

    public static boolean hasInvalidResult(Geometry[] validateResult) {
        for (Geometry geom : validateResult) {
            if (geom == null) continue;
            return true;
        }
        return false;
    }

    public static Geometry[] validate(Geometry[] coverage) {
        CoverageValidator v = new CoverageValidator(coverage);
        return v.validate();
    }

    public static Geometry[] validate(Geometry[] coverage, double gapWidth) {
        CoverageValidator v = new CoverageValidator(coverage);
        v.setGapWidth(gapWidth);
        return v.validate();
    }

    public CoverageValidator(Geometry[] coverage) {
        this.coverage = coverage;
    }

    public void setGapWidth(double gapWidth) {
        this.gapWidth = gapWidth;
    }

    public Geometry[] validate() {
        STRtree index = new STRtree();
        for (Geometry geom : this.coverage) {
            index.insert(geom.getEnvelopeInternal(), (Object)geom);
        }
        Geometry[] invalidLines = new Geometry[this.coverage.length];
        for (int i2 = 0; i2 < this.coverage.length; ++i2) {
            Geometry geom = this.coverage[i2];
            invalidLines[i2] = this.validate(geom, index);
        }
        return invalidLines;
    }

    private Geometry validate(Geometry targetGeom, STRtree index) {
        Envelope queryEnv = targetGeom.getEnvelopeInternal();
        queryEnv.expandBy(this.gapWidth);
        List nearGeomList = index.query(queryEnv);
        nearGeomList.remove(targetGeom);
        Geometry[] nearGeoms = GeometryFactory.toGeometryArray(nearGeomList);
        Geometry result = CoveragePolygonValidator.validate(targetGeom, nearGeoms, this.gapWidth);
        return result.isEmpty() ? null : result;
    }
}

